/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.nio.ByteBuffer;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.util.Args;

abstract class SSLManagedBuffer {
    SSLManagedBuffer() {
    }

    abstract ByteBuffer acquire();

    abstract void release();

    abstract boolean isAcquired();

    abstract boolean hasData();

    abstract void ensureWriteable(int var1);

    ByteBuffer ensureWriteable(ByteBuffer src, int size2) {
        if (src == null) {
            return null;
        }
        if (src.remaining() < size2) {
            int additionalCapacityNeeded = size2 - src.remaining();
            ByteBuffer expanded = ByteBuffer.allocate(src.capacity() + additionalCapacityNeeded);
            ByteBuffer tmp = src.duplicate();
            tmp.flip();
            expanded.put(tmp);
            return expanded;
        }
        return src;
    }

    static SSLManagedBuffer create(SSLBufferMode mode, int size2) {
        return mode == SSLBufferMode.DYNAMIC ? new DynamicBuffer(size2) : new StaticBuffer(size2);
    }

    static final class DynamicBuffer
    extends SSLManagedBuffer {
        private ByteBuffer wrapped;
        private final int length;

        public DynamicBuffer(int size2) {
            Args.positive(size2, "size");
            this.length = size2;
        }

        @Override
        public ByteBuffer acquire() {
            if (this.wrapped != null) {
                return this.wrapped;
            }
            this.wrapped = ByteBuffer.allocate(this.length);
            return this.wrapped;
        }

        @Override
        public void release() {
            this.wrapped = null;
        }

        @Override
        public boolean isAcquired() {
            return this.wrapped != null;
        }

        @Override
        public boolean hasData() {
            return this.wrapped != null && this.wrapped.position() > 0;
        }

        @Override
        void ensureWriteable(int size2) {
            this.wrapped = this.ensureWriteable(this.wrapped, size2);
        }
    }

    static final class StaticBuffer
    extends SSLManagedBuffer {
        private ByteBuffer buffer;

        public StaticBuffer(int size2) {
            Args.positive(size2, "size");
            this.buffer = ByteBuffer.allocate(size2);
        }

        @Override
        public ByteBuffer acquire() {
            return this.buffer;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isAcquired() {
            return true;
        }

        @Override
        public boolean hasData() {
            return this.buffer.position() > 0;
        }

        @Override
        void ensureWriteable(int size2) {
            this.buffer = this.ensureWriteable(this.buffer, size2);
        }
    }
}

