/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.session;

import com.intellij.ml.llm.chat.session.RollbackService;
import com.intellij.ml.llm.chat.session.RollbackServiceKt;
import com.intellij.ml.llm.messages.AIAChatBundle;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.a2ux.api.FileChange;
import org.jetbrains.a2ux.api.FileContent;
import org.jetbrains.a2ux.api.TextFileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0003\u000e\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0086@\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/chat/session/RollbackService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rollback", "", "change", "Lorg/jetbrains/a2ux/api/FileChange;", "(Lorg/jetbrains/a2ux/api/FileChange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changes", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "RollbackExecutor", "AIChatRollback", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nRollbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,249:1\n13#2:250\n*S KotlinDebug\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService\n*L\n30#1:250\n*E\n"})
public final class RollbackService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public RollbackService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final Object rollback(@NotNull FileChange change, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.rollback(CollectionsKt.listOf((Object)change), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object rollback(@NotNull List<FileChange> changes, @NotNull Continuation<? super Unit> $completion) {
        if (changes.isEmpty()) {
            return Unit.INSTANCE;
        }
        RollbackExecutor rollbackExecutor = RollbackExecutor.Companion.create(this.project);
        if (rollbackExecutor == null) {
            return Unit.INSTANCE;
        }
        RollbackExecutor executor = rollbackExecutor;
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, executor, changes, null){
            int label;
            final /* synthetic */ RollbackService this$0;
            final /* synthetic */ RollbackExecutor $executor;
            final /* synthetic */ List<FileChange> $changes;
            {
                this.this$0 = $receiver;
                this.$executor = $executor;
                this.$changes = $changes;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        WriteCommandAction.writeCommandAction((Project)RollbackService.access$getProject$p(this.this$0)).withName(AIAChatBundle.message("agents.rollback.name", new Object[0])).run(() -> rollback.3.invokeSuspend$lambda$0(this.$changes, this.$executor));
                        this.$executor.refreshAffectedFiles();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(List $changes, RollbackExecutor $executor) {
                Iterable $this$forEach$iv = $changes;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FileChange change = (FileChange)element$iv;
                    boolean bl = false;
                    try {
                        $executor.rollbackChange(change);
                    }
                    catch (Exception e) {
                        RollbackService.access$getLOG$cp().error("Failed to rollback file change: " + change, (Throwable)e);
                        throw e;
                    }
                }
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(RollbackService $this) {
        return $this.project;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RollbackService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/chat/session/RollbackService$AIChatRollback;", "", "<init>", "()V", "intellij.ml.llm.chat"})
    private static final class AIChatRollback {
        @NotNull
        public static final AIChatRollback INSTANCE = new AIChatRollback();

        private AIChatRollback() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/chat/session/RollbackService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/chat/session/RollbackService;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nRollbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,249:1\n30#2,2:250\n*S KotlinDebug\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService$Companion\n*L\n28#1:250,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RollbackService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RollbackService> serviceClass$iv = RollbackService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RollbackService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0012\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/chat/session/RollbackService$RollbackExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "projectRoot", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "vfsManager", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "Lorg/jetbrains/annotations/NotNull;", "projectRootVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToRefresh", "", "rollbackChange", "", "change", "Lorg/jetbrains/a2ux/api/FileChange;", "refreshAffectedFiles", "resolveFile", "relativePath", "", "recreateFile", "content", "Lorg/jetbrains/a2ux/api/FileContent;", "deleteFile", "moveFile", "restoreContent", "ensureParentDirectory", "filePath", "trackForRefresh", "file", "extractText", "writeTextToFile", "text", "Companion", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nRollbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService$RollbackExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1869#2,2:250\n774#2:253\n865#2,2:254\n1#3:252\n*S KotlinDebug\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService$RollbackExecutor\n*L\n100#1:250,2\n199#1:253\n199#1:254,2\n*E\n"})
    private static final class RollbackExecutor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Path projectRoot;
        @NotNull
        private final VirtualFileManager vfsManager;
        @Nullable
        private final VirtualFile projectRootVirtualFile;
        @NotNull
        private final Set<VirtualFile> filesToRefresh;

        private RollbackExecutor(Project project, Path projectRoot) {
            this.projectRoot = projectRoot;
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
            this.vfsManager = virtualFileManager;
            this.projectRootVirtualFile = ProjectUtil.guessProjectDir((Project)project);
            this.filesToRefresh = new LinkedHashSet();
        }

        public final void rollbackChange(@NotNull FileChange change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            if (RollbackServiceKt.isCreation(change)) {
                String string = change.getAfterRelativePath();
                Intrinsics.checkNotNull((Object)string);
                this.deleteFile(string);
            } else if (RollbackServiceKt.isDeletion(change)) {
                String string = change.getBeforeRelativePath();
                Intrinsics.checkNotNull((Object)string);
                this.recreateFile(string, change.getBeforeContent());
            } else if (RollbackServiceKt.isMove(change)) {
                this.moveFile(change);
            } else if (RollbackServiceKt.isModification(change)) {
                String string = change.getBeforeRelativePath();
                Intrinsics.checkNotNull((Object)string);
                this.restoreContent(string, change.getBeforeContent());
            }
        }

        public final void refreshAffectedFiles() {
            Iterable $this$forEach$iv = this.filesToRefresh;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                it.refresh(false, true);
            }
            this.filesToRefresh.clear();
        }

        private final VirtualFile resolveFile(String relativePath) {
            VirtualFile virtualFile2 = this.vfsManager.findFileByNioPath(this.projectRoot.resolve(relativePath));
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                return it;
            }
            VirtualFile virtualFile3 = this.projectRootVirtualFile;
            return virtualFile3 != null ? virtualFile3.findFileByRelativePath(relativePath) : null;
        }

        private final void recreateFile(String relativePath, FileContent content2) {
            String text2 = this.extractText(content2);
            if (text2 == null) {
                LOG.warn("Cannot recreate file " + relativePath + ": content is not text or is null");
                return;
            }
            Path filePath = this.projectRoot.resolve(relativePath);
            Intrinsics.checkNotNull((Object)filePath);
            VirtualFile virtualFile2 = this.ensureParentDirectory(filePath);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile parent = virtualFile2;
            VirtualFile virtualFile3 = parent.createChildData((Object)AIChatRollback.INSTANCE, ((Object)filePath.getFileName()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"createChildData(...)");
            VirtualFile newFile = virtualFile3;
            this.writeTextToFile(newFile, text2);
            this.trackForRefresh(newFile.getParent());
        }

        private final void deleteFile(String relativePath) {
            VirtualFile virtualFile2 = this.resolveFile(relativePath);
            if (virtualFile2 == null) {
                RollbackExecutor $this$deleteFile_u24lambda_u240 = this;
                boolean bl = false;
                LOG.warn("File not found for deletion: " + relativePath);
                return;
            }
            VirtualFile file = virtualFile2;
            VirtualFile parent = file.getParent();
            file.delete((Object)AIChatRollback.INSTANCE);
            this.trackForRefresh(parent);
        }

        private final void moveFile(FileChange change) {
            String string = change.getAfterRelativePath();
            Intrinsics.checkNotNull((Object)string);
            String fromPath = string;
            String string2 = change.getBeforeRelativePath();
            Intrinsics.checkNotNull((Object)string2);
            String toPath = string2;
            VirtualFile virtualFile2 = this.resolveFile(fromPath);
            if (virtualFile2 == null) {
                RollbackExecutor $this$moveFile_u24lambda_u240 = this;
                boolean bl = false;
                LOG.warn("Source file not found for move: " + fromPath);
                return;
            }
            VirtualFile sourceFile = virtualFile2;
            Path targetPath = this.projectRoot.resolve(toPath);
            VirtualFile existingTarget = this.resolveFile(toPath);
            if (existingTarget != null && !Intrinsics.areEqual((Object)existingTarget, (Object)sourceFile)) {
                LOG.warn("Target file already exists: " + toPath);
                return;
            }
            Intrinsics.checkNotNull((Object)targetPath);
            VirtualFile virtualFile3 = this.ensureParentDirectory(targetPath);
            if (virtualFile3 == null) {
                return;
            }
            VirtualFile targetParent = virtualFile3;
            String targetFileName = ((Object)targetPath.getFileName()).toString();
            if (!Intrinsics.areEqual((Object)sourceFile.getParent(), (Object)targetParent)) {
                sourceFile.move((Object)AIChatRollback.INSTANCE, targetParent);
            }
            if (!Intrinsics.areEqual((Object)sourceFile.getName(), (Object)targetFileName)) {
                sourceFile.rename((Object)AIChatRollback.INSTANCE, targetFileName);
            }
            if (change.getBeforeContent() != null && !Intrinsics.areEqual((Object)change.getBeforeContent(), (Object)change.getAfterContent())) {
                String text2 = this.extractText(change.getBeforeContent());
                if (text2 != null) {
                    this.writeTextToFile(sourceFile, text2);
                } else {
                    LOG.warn("Cannot restore content for moved file " + toPath + ": content is not text or is null");
                }
            }
            this.trackForRefresh(sourceFile.getParent());
        }

        private final void restoreContent(String relativePath, FileContent content2) {
            VirtualFile virtualFile2 = this.resolveFile(relativePath);
            if (virtualFile2 == null) {
                RollbackExecutor $this$restoreContent_u24lambda_u240 = this;
                boolean bl = false;
                LOG.warn("File not found for content restoration: " + relativePath);
                return;
            }
            VirtualFile file = virtualFile2;
            String text2 = this.extractText(content2);
            if (text2 == null) {
                LOG.warn("Cannot restore content for " + relativePath + ": content is not text or is null");
                return;
            }
            this.writeTextToFile(file, text2);
            this.trackForRefresh(file.getParent());
        }

        /*
         * WARNING - void declaration
         */
        private final VirtualFile ensureParentDirectory(Path filePath) {
            void $this$filterTo$iv$iv;
            Path parentPath = filePath.getParent();
            VirtualFile virtualFile2 = this.vfsManager.findFileByNioPath(parentPath);
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                return it;
            }
            virtualFile2 = this.vfsManager.refreshAndFindFileByNioPath(parentPath);
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                return it;
            }
            Path relativePath = this.projectRoot.relativize(parentPath);
            VirtualFile virtualFile3 = this.projectRootVirtualFile;
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile current = virtualFile3;
            char[] bl = new char[]{'/'};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((Object)relativePath).toString(), (char[])bl, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = ((CharSequence)it).length() > 0;
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (String segment : (List)destination$iv$iv) {
                VirtualFile virtualFile4 = current.findChild(segment);
                if (virtualFile4 == null) {
                    VirtualFile virtualFile5 = current.createChildDirectory((Object)AIChatRollback.INSTANCE, segment);
                    virtualFile4 = virtualFile5;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"createChildDirectory(...)");
                }
                current = virtualFile4;
            }
            return current;
        }

        private final void trackForRefresh(VirtualFile file) {
            block0: {
                VirtualFile virtualFile2 = file;
                if (virtualFile2 == null) break block0;
                VirtualFile it = virtualFile2;
                boolean bl = false;
                this.filesToRefresh.add(it);
            }
        }

        private final String extractText(FileContent $this$extractText) {
            String string;
            FileContent fileContent = $this$extractText;
            if (fileContent instanceof TextFileContent) {
                string = ((TextFileContent)$this$extractText).getText();
            } else if (fileContent == null) {
                string = null;
            } else {
                LOG.warn("Unsupported file content type: " + Reflection.getOrCreateKotlinClass($this$extractText.getClass()).getSimpleName());
                string = null;
            }
            return string;
        }

        private final void writeTextToFile(VirtualFile file, String text2) {
            Document document;
            if (!file.isWritable()) {
                LOG.warn("Cannot write text to " + file.getName() + " file: file is not writable");
            }
            if ((document = FileDocumentManager.getInstance().getDocument(file)) != null) {
                String string = StringUtil.convertLineSeparators((String)text2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
                String documentText = string;
                document.setText((CharSequence)documentText);
                FileDocumentManager.getInstance().saveDocument(document);
            } else {
                VirtualFileUtil.writeText((VirtualFile)file, (String)text2);
            }
        }

        public /* synthetic */ RollbackExecutor(Project project, Path projectRoot, DefaultConstructorMarker $constructor_marker) {
            this(project, projectRoot);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/chat/session/RollbackService$RollbackExecutor$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ml/llm/chat/session/RollbackService$RollbackExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.chat"})
        @SourceDebugExtension(value={"SMAP\nRollbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollbackService.kt\ncom/intellij/ml/llm/chat/session/RollbackService$RollbackExecutor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final RollbackExecutor create(@NotNull Project project) {
                Path projectPath;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
                if (projectDir == null) {
                    LOG.warn("Cannot determine project root directory");
                    return null;
                }
                Path path = VirtualFileUtil.toNioPathOrNull((VirtualFile)projectDir);
                if (path == null) {
                    String it = projectDir.getPath();
                    boolean bl = false;
                    path = Path.of(it, new String[0]);
                }
                if ((projectPath = path) == null) {
                    LOG.warn("Cannot convert project directory to Path");
                    return null;
                }
                return new RollbackExecutor(project, projectPath, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

