/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.retrievers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextRetrievalRequest;
import com.intellij.ml.llm.context.ContextRetriever;
import com.intellij.ml.llm.context.markers.PsiFileAwareContext;
import com.intellij.ml.llm.core.chat.context.retrievers.FileProblemsContextRequest;
import com.intellij.ml.llm.core.chat.context.retrievers.FileProblemsRetrieverSource;
import com.intellij.ml.llm.core.chat.context.uiPicker.problems.ProblemsAttachmentUtil;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileProblemsContextAttachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/context/retrievers/FileProblemsContextRetriever;", "Lcom/intellij/ml/llm/context/ContextRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isApplicable", "", "request", "Lcom/intellij/ml/llm/context/ContextRetrievalRequest;", "computeContextFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ml/llm/context/ContextEntity;", "toContextAttachment", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileProblemsContextAttachment;", "file", "Lcom/intellij/psi/PsiFile;", "problems", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "intellij.ml.llm.chat"})
public final class FileProblemsContextRetriever
implements ContextRetriever {
    @NotNull
    private final Project project;

    public FileProblemsContextRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean isApplicable(@NotNull ContextRetrievalRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof FileProblemsContextRequest)) {
            return false;
        }
        return ((PsiFileAwareContext)request).getPsiFile() != null;
    }

    @NotNull
    public Flow<ContextEntity> computeContextFlow(@NotNull ContextRetrievalRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof FileProblemsContextRequest)) {
            return FlowKt.emptyFlow();
        }
        PsiFile psiFile = ((PsiFileAwareContext)request).getPsiFile();
        if (psiFile == null) {
            return FlowKt.emptyFlow();
        }
        PsiFile file = psiFile;
        List<HighlightInfo> problems = ProblemsAttachmentUtil.INSTANCE.getFileProblems(file, this.project);
        if (problems.isEmpty()) {
            return FlowKt.emptyFlow();
        }
        return FlowKt.flowOf((Object)this.toContextAttachment(file, problems));
    }

    private final FileProblemsContextAttachment toContextAttachment(PsiFile file, List<? extends HighlightInfo> problems) {
        VirtualFile virtualFile2 = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return new FileProblemsContextAttachment(this.project, virtualFile2, ProblemsAttachmentUtil.INSTANCE.getProblemsSummary(file, problems), FileProblemsRetrieverSource.INSTANCE, problems.size(), false, 32, null);
    }
}

