/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.web;

import com.intellij.ml.llm.core.chat.ui.chat.context.ContextAttachmentView;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J4\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u001bH\u0002J\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/core/chat/context/web/WebSearchAttachmentIconBuilder;", "", "<init>", "()V", "ICON_SRC_RESOLUTION", "", "ICON_TARGET_RESOLUTION", "FAVICON_TARGET_RESOLUTION", "WHITE_DETECTION_TOLERANCE", "build", "Ljavax/swing/Icon;", "domain", "", "loadFaviconIcon", "Ljava/awt/image/BufferedImage;", "buildIcon", "img", "fillMaxSize", "", "isWhiteOrTransparent", "image", "x", "y", "tolerance", "getCropBounds", "Ljava/awt/Rectangle;", "filter", "Lkotlin/Function3;", "SQUARE_CORNER_COEFFICIENT", "", "hasRoundCorners", "WebIcon", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nWebSearchAttachmentIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSearchAttachmentIcon.kt\ncom/intellij/ml/llm/core/chat/context/web/WebSearchAttachmentIconBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1869#2,2:285\n*S KotlinDebug\n*F\n+ 1 WebSearchAttachmentIcon.kt\ncom/intellij/ml/llm/core/chat/context/web/WebSearchAttachmentIconBuilder\n*L\n271#1:285,2\n*E\n"})
public final class WebSearchAttachmentIconBuilder {
    @NotNull
    public static final WebSearchAttachmentIconBuilder INSTANCE = new WebSearchAttachmentIconBuilder();
    private static final int ICON_SRC_RESOLUTION = 64;
    private static final int ICON_TARGET_RESOLUTION = 16;
    private static final int FAVICON_TARGET_RESOLUTION = 14;
    private static final int WHITE_DETECTION_TOLERANCE = 50;
    private static final float SQUARE_CORNER_COEFFICIENT = 0.15f;

    private WebSearchAttachmentIconBuilder() {
    }

    @Nullable
    public final Icon build(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        BufferedImage bufferedImage = this.loadFaviconIcon(domain);
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage png = bufferedImage;
        return WebSearchAttachmentIconBuilder.buildIcon$default(this, png, false, 2, null);
    }

    private final BufferedImage loadFaviconIcon(String domain) {
        BufferedImage bufferedImage;
        String url = "https://www.google.com/s2/favicons?domain=" + domain + "&sz=64";
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.connect();
            bufferedImage = ImageIO.read(connection.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            bufferedImage = null;
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final Icon buildIcon(@NotNull BufferedImage img, boolean fillMaxSize) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        v0 = ImageUtil.createImage((int)64, (int)64, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createImage(...)");
        bufferedImage = v0;
        v1 = bufferedImage.createGraphics();
        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        g2d = v1;
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            circleMask = new Ellipse2D.Float(0.0f, 0.0f, 64.0f, 64.0f);
            g2d.setColor((Color)ContextAttachmentView.Companion.getFocusedBorderColor());
            g2d.clip(circleMask);
            g2d.fillRect(0, 0, 64, 64);
            cropRect = this.getCropBounds(img, (Function3<? super BufferedImage, ? super Integer, ? super Integer, Boolean>)(Function3)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, buildIcon$lambda$0(java.awt.image.BufferedImage int int ), (Ljava/awt/image/BufferedImage;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Boolean;)());
            croppedImage = cropRect != null ? img.getSubimage(cropRect.x, cropRect.y, cropRect.width, cropRect.height) : img;
            innerCircle = 56.0f;
            intend = ((float)64 - innerCircle) / 2.0f;
            faviconMask = new Ellipse2D.Float(intend, intend, innerCircle, innerCircle);
            g2d.clip(faviconMask);
            if (fillMaxSize) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)croppedImage);
            if (this.hasRoundCorners(croppedImage, 50)) lbl-1000:
            // 2 sources

            {
                v2 = innerCircle;
            } else {
                v2 = (innerCircle / 2.0f * (float)Math.sqrt(2.0f) + innerCircle) / 2.0f;
            }
            faviconRes = v2;
            faviconIntend = ((float)64 - faviconRes) / 2.0f;
            if (WebSearchAttachmentIconBuilder.buildIcon$isShouldFitTo(croppedImage.getWidth(), croppedImage.getHeight(), fillMaxSize)) {
                height = (int)(faviconRes / (float)croppedImage.getWidth() * (float)croppedImage.getHeight());
                yShift = (int)((faviconRes - (float)height) / (float)2);
                v3 = g2d.drawImage(croppedImage, (int)faviconIntend, (int)faviconIntend + yShift, (int)faviconRes, height, null);
            } else if (WebSearchAttachmentIconBuilder.buildIcon$isShouldFitTo(croppedImage.getHeight(), croppedImage.getWidth(), fillMaxSize)) {
                width = (int)(faviconRes / (float)croppedImage.getHeight() * (float)croppedImage.getWidth());
                xShift = (faviconRes - (float)width) / (float)2;
                v3 = g2d.drawImage(croppedImage, (int)(faviconIntend + xShift), (int)faviconIntend, width, (int)faviconRes, null);
            } else {
                v3 = g2d.drawImage(croppedImage, (int)faviconIntend, (int)faviconIntend, (int)faviconRes, (int)faviconRes, null);
            }
            var13_15 = (Icon)new WebIcon(bufferedImage, 16);
            return var13_15;
        }
        finally {
            g2d.dispose();
        }
    }

    public static /* synthetic */ Icon buildIcon$default(WebSearchAttachmentIconBuilder webSearchAttachmentIconBuilder, BufferedImage bufferedImage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return webSearchAttachmentIconBuilder.buildIcon(bufferedImage, bl);
    }

    private final boolean isWhiteOrTransparent(BufferedImage image, int x, int y, int tolerance) {
        int argb = image.getRGB(x, y);
        int alpha = argb >> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        if (alpha == 0) {
            return true;
        }
        return Math.abs(red - 255) <= tolerance && Math.abs(green - 255) <= tolerance && Math.abs(blue - 255) <= tolerance;
    }

    private final Rectangle getCropBounds(BufferedImage image, Function3<? super BufferedImage, ? super Integer, ? super Integer, Boolean> filter2) {
        int y;
        int x;
        int n;
        int y1;
        if (image == null) {
            return null;
        }
        int x1 = 0;
        int x2 = image.getWidth();
        int y2 = image.getHeight();
        if (x2 == 0 || y2 == 0) {
            return null;
        }
        block0: for (y1 = 0; y1 < y2 - 1; ++y1) {
            n = x2 - 1;
            for (x = 0; x < n; ++x) {
                if (!((Boolean)filter2.invoke((Object)image, (Object)x, (Object)y1)).booleanValue()) break block0;
            }
        }
        if (y1 == y2) {
            return null;
        }
        block2: while (x1 < x2 - 1) {
            n = y2 - 1;
            for (y = y1; y < n; ++y) {
                if (!((Boolean)filter2.invoke((Object)image, (Object)x1, (Object)y)).booleanValue()) break block2;
            }
            ++x1;
        }
        block4: while (--x2 >= x1) {
            n = y2;
            for (y = y1; y < n; ++y) {
                if (!((Boolean)filter2.invoke((Object)image, (Object)x2, (Object)y)).booleanValue()) break block4;
            }
        }
        ++x2;
        block6: while (--y2 >= y1) {
            n = x2;
            for (x = x1; x < n; ++x) {
                if (!((Boolean)filter2.invoke((Object)image, (Object)x, (Object)y2)).booleanValue()) break block6;
            }
        }
        if (x1 == x2 || y1 == ++y2) {
            return null;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }

    public final boolean hasRoundCorners(@NotNull BufferedImage image, int tolerance) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.getWidth() == 0 || image.getHeight() == 0) {
            throw new IllegalArgumentException("Image cannot have zero width or height");
        }
        float checkToX = (float)image.getWidth() * 0.15f;
        float checkToY = (float)image.getHeight() * 0.15f;
        Iterable $this$forEach$iv = (Iterable)RangesKt.step((IntProgression)((IntProgression)new IntRange(0, image.getWidth())), (int)3);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (checkToX < (float)i || checkToY < (float)i) {
                return true;
            }
            if (!INSTANCE.isWhiteOrTransparent(image, i, i, tolerance)) {
                return false;
            }
            if (!INSTANCE.isWhiteOrTransparent(image, image.getWidth() - i - 1, i, tolerance)) {
                return false;
            }
            if (!INSTANCE.isWhiteOrTransparent(image, i, image.getHeight() - i - 1, tolerance)) {
                return false;
            }
            if (INSTANCE.isWhiteOrTransparent(image, image.getWidth() - i - 1, image.getHeight() - i - 1, tolerance)) continue;
            return false;
        }
        return true;
    }

    private static final boolean buildIcon$lambda$0(BufferedImage img, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return INSTANCE.isWhiteOrTransparent(img, x, y, 50);
    }

    private static final boolean buildIcon$isShouldFitTo(int a, int b, boolean zoomFit) {
        return zoomFit ? a < b : a > b;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/chat/context/web/WebSearchAttachmentIconBuilder$WebIcon;", "Lcom/intellij/util/ui/JBImageIcon;", "srcImage", "Ljava/awt/image/BufferedImage;", "size", "", "<init>", "(Ljava/awt/image/BufferedImage;I)V", "cachedImageData", "Lkotlin/Pair;", "Ljava/awt/Image;", "getImage", "getIconWidth", "getIconHeight", "intellij.ml.llm.chat"})
    private static final class WebIcon
    extends JBImageIcon {
        private final int size;
        @Nullable
        private Pair<? extends Image, Integer> cachedImageData;

        public WebIcon(@NotNull BufferedImage srcImage, int size) {
            Intrinsics.checkNotNullParameter((Object)srcImage, (String)"srcImage");
            super((Image)srcImage);
            this.size = size;
        }

        @NotNull
        public Image getImage() {
            int scaledSize = JBUIScale.scale((int)this.size);
            Pair pair = this.cachedImageData;
            if (pair == null) {
                pair = new Pair(null, (Object)0);
            }
            Pair pair2 = pair;
            Image cachedImage = (Image)pair2.component1();
            int cachedSize = ((Number)pair2.component2()).intValue();
            if (cachedSize == scaledSize && cachedImage != null) {
                return cachedImage;
            }
            Image scaledImage = ImageUtil.scaleImage((Image)super.getImage(), (int)this.getIconWidth(), (int)this.getIconHeight());
            this.cachedImageData = TuplesKt.to((Object)scaledImage, (Object)scaledSize);
            Intrinsics.checkNotNull((Object)scaledImage);
            return scaledImage;
        }

        public int getIconWidth() {
            return JBUIScale.scale((int)this.size);
        }

        public int getIconHeight() {
            return JBUIScale.scale((int)this.size);
        }
    }
}

