/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.proxy;

import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.ChatMessageVm;
import com.intellij.ml.llm.core.chat.proxy.AIAAgentAndModeSelectorSessionProxy;
import com.intellij.ml.llm.core.chat.proxy.AIAAgentAndModeSelectorSessionProxyMonolith;
import com.intellij.ml.llm.core.chat.proxy.AIAAgentModelSelectorSessionProxy;
import com.intellij.ml.llm.core.chat.proxy.AIAAgentModelSelectorSessionProxyMonolith;
import com.intellij.ml.llm.core.chat.proxy.AIAChatInputProxy;
import com.intellij.ml.llm.core.chat.session.AIInput;
import com.intellij.ml.llm.core.chat.session.ChatSessionState;
import com.intellij.ml.llm.core.chat.session.impl.ChatSessionImpl;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextVm;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'H\u0016J\u0016\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u001f\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001a\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001f\u0010\u001c\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/core/chat/proxy/AIAChatInputProxyMonolith;", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatInputProxy;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/impl/ChatSessionImpl;", "<init>", "(Lcom/intellij/ml/llm/core/chat/session/impl/ChatSessionImpl;)V", "contextViewModel", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextVm;", "getContextViewModel", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextVm;", "isAskAISession", "", "state", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionState;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "chatMode", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "getChatMode", "compilationErrors", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "getCompilationErrors", "()Lkotlinx/coroutines/flow/Flow;", "fastInputValidationErrors", "getFastInputValidationErrors", "slowInputValidationErrors", "getSlowInputValidationErrors", "setAssociatedInput", "", "input", "Lcom/intellij/ml/llm/core/chat/session/AIInput;", "createInputDocument", "Lcom/intellij/openapi/editor/Document;", "getLastUserMessageDisplayText", "Lcom/intellij/ml/llm/privacy/PSString;", "getUserMessageHistory", "", "setCodebaseEnabled", "isEnabled", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createModelSelectorSessionProxy", "Lcom/intellij/ml/llm/core/chat/proxy/AIAAgentModelSelectorSessionProxy;", "createAgentAndModeSelectorSessionProxy", "Lcom/intellij/ml/llm/core/chat/proxy/AIAAgentAndModeSelectorSessionProxy;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAChatSessionProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAChatSessionProxy.kt\ncom/intellij/ml/llm/core/chat/proxy/AIAChatInputProxyMonolith\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,558:1\n543#2,6:559\n774#2:565\n865#2,2:566\n1617#2,9:568\n1869#2:577\n1870#2:579\n1626#2:580\n1#3:578\n*S KotlinDebug\n*F\n+ 1 AIAChatSessionProxy.kt\ncom/intellij/ml/llm/core/chat/proxy/AIAChatInputProxyMonolith\n*L\n477#1:559,6\n482#1:565\n482#1:566,2\n483#1:568,9\n483#1:577\n483#1:579\n483#1:580\n483#1:578\n*E\n"})
public final class AIAChatInputProxyMonolith
implements AIAChatInputProxy {
    @NotNull
    private final ChatSessionImpl chatSession;

    public AIAChatInputProxyMonolith(@NotNull ChatSessionImpl chatSession2) {
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        this.chatSession = chatSession2;
    }

    @Override
    @NotNull
    public AIChatContextVm getContextViewModel() {
        return this.chatSession.getContextViewModel();
    }

    @Override
    public boolean isAskAISession() {
        return this.chatSession.getChatMode().getCurrentChatMode().getValue() instanceof NewChatMode.AskAi;
    }

    @Override
    @NotNull
    public StateFlow<ChatSessionState> getState() {
        return this.chatSession.getStateFlow();
    }

    @Override
    @NotNull
    public StateFlow<NewChatMode> getChatMode() {
        return this.chatSession.getChatMode().getCurrentChatMode();
    }

    @Override
    @NotNull
    public Flow<String> getCompilationErrors() {
        return this.chatSession.getCompilationErrors();
    }

    @Override
    @NotNull
    public Flow<String> getFastInputValidationErrors() {
        return this.chatSession.getFastInputValidationErrors();
    }

    @Override
    @NotNull
    public Flow<String> getSlowInputValidationErrors() {
        return this.chatSession.getSlowInputValidationErrors();
    }

    @Override
    public void setAssociatedInput(@NotNull AIInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.chatSession.getAssociatedInput().setValue((Object)input);
    }

    @Override
    @NotNull
    public Document createInputDocument() {
        return this.chatSession.createInputDocument();
    }

    @Override
    @Nullable
    public PSString getLastUserMessageDisplayText() {
        ChatMessageVm chatMessageVm;
        block1: {
            List<ChatMessageVm> $this$lastOrNull$iv = this.chatSession.getMessageVms();
            boolean $i$f$lastOrNull = false;
            ListIterator<ChatMessageVm> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                ChatMessageVm element$iv;
                ChatMessageVm it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getAuthor() == ChatMessageAuthor.User)) continue;
                chatMessageVm = element$iv;
                break block1;
            }
            chatMessageVm = null;
        }
        ChatMessageVm chatMessageVm2 = chatMessageVm;
        return chatMessageVm2 != null ? chatMessageVm2.getDisplayText() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PSString> getUserMessageHistory() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.chatSession.getMessageVms();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatMessageVm it = (ChatMessageVm)element$iv$iv;
            boolean bl = false;
            if (!(it.getAuthor() == ChatMessageAuthor.User)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PSString it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatMessageVm it = (ChatMessageVm)element$iv$iv;
            boolean bl2 = false;
            if (it.getDisplayText() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object setCodebaseEnabled(boolean isEnabled, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.chatSession.setCodebaseEnabled(isEnabled, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public AIAAgentModelSelectorSessionProxy createModelSelectorSessionProxy() {
        return new AIAAgentModelSelectorSessionProxyMonolith(this.chatSession);
    }

    @Override
    @NotNull
    public AIAAgentAndModeSelectorSessionProxy createAgentAndModeSelectorSessionProxy() {
        return new AIAAgentAndModeSelectorSessionProxyMonolith(this.chatSession);
    }
}

