/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.services.paste;

import com.intellij.ml.llm.core.chat.context.UserInputContextTrigger;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.services.paste.ContentSource;
import com.intellij.ml.llm.core.chat.session.AIInput;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/AIAssistantCopyPasteListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "lastCopyRecord", "Lcom/intellij/ml/llm/core/chat/services/paste/AIAssistantCopyPasteListener$CopyRecord;", "afterActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "invokeContextUpdate", "session", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "getCopiedContents", "", "determineTextSource", "Lcom/intellij/ml/llm/core/chat/services/paste/ContentSource;", "editor", "isAIChatInput", "", "isInTestsExecutionConsole", "CopyRecord", "intellij.ml.llm.chat"})
public final class AIAssistantCopyPasteListener
implements AnActionListener {
    @NotNull
    private CopyRecord lastCopyRecord = new CopyRecord(null, null, null, 7, null);

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        block23: {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            String string = ActionManager.getInstance().getId(action2);
            if (string == null) break block23;
            int n = -1;
            switch (string.hashCode()) {
                case -1277759289: {
                    if (string.equals("AIAssistant.ToolWindow.Snippet.CopyToClipboard")) {
                        n = 1;
                    }
                    break;
                }
                case 436576930: {
                    if (string.equals("EditorCopy")) {
                        n = 2;
                    }
                    break;
                }
                case 660574470: {
                    if (string.equals("EditorPaste")) {
                        n = 3;
                    }
                    break;
                }
                case 1457725359: {
                    if (string.equals("Terminal.CopySelectedText")) {
                        n = 4;
                    }
                    break;
                }
                case -1743102682: {
                    if (string.equals("Terminal.CopyBlock")) {
                        n = 4;
                    }
                    break;
                }
                case 152630645: {
                    if (string.equals("EditorCut")) {
                        n = 2;
                    }
                    break;
                }
            }
            switch (n) {
                case 4: {
                    this.lastCopyRecord = new CopyRecord(this.getCopiedContents(), ContentSource.TERMINAL, null, 4, null);
                    break;
                }
                case 1: {
                    this.lastCopyRecord = new CopyRecord(this.getCopiedContents(), ContentSource.CHAT_MESSAGE_CODE_SNIPPET_ACTION, null, 4, null);
                    break;
                }
                case 2: {
                    Editor editor = this.getEditor(event);
                    ContentSource source2 = this.determineTextSource(editor, event);
                    this.lastCopyRecord = new CopyRecord(this.getCopiedContents(), source2, new WeakReference<Editor>(editor));
                    break;
                }
                case 3: {
                    Editor editor = this.getEditor(event);
                    if (editor != null) {
                        Editor it = editor;
                        boolean bl = false;
                        if (!this.isAIChatInput(it)) break;
                        ChatSession chatSession2 = (ChatSession)event.getDataContext().getData(ChatSession.Companion.getCurrentSession());
                        if (Intrinsics.areEqual((Object)this.lastCopyRecord.getText(), (Object)this.getCopiedContents())) {
                            AIAssistantChatEventLogger.logTextInserted(it.getProject(), chatSession2, this.lastCopyRecord.getEditorRef(), this.lastCopyRecord.getSource());
                        } else {
                            AIAssistantChatEventLogger.logTextInserted(it.getProject(), chatSession2, null, ContentSource.UNKNOWN);
                        }
                        this.invokeContextUpdate(event, chatSession2);
                    }
                    break;
                }
            }
        }
    }

    private final void invokeContextUpdate(AnActionEvent event, ChatSession session) {
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (session == null || project == null) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, project, null){
            int label;
            final /* synthetic */ ChatSession $session;
            final /* synthetic */ Project $project;
            {
                this.$session = $session;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AIInput.Companion.getAssociatedInput(this.$session, (Continuation<? super AIInput>)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        document = ((AIInput)v0).getDocument();
                        $this$service$iv = (ComponentManager)this.$project;
                        $i$f$service = false;
                        serviceClass$iv = UserInputContextTrigger.class;
                        v1 = $this$service$iv.getService(serviceClass$iv);
                        if (v1 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        UserInputContextTrigger.updateUserInput$default((UserInputContextTrigger)v1, this.$session, ExtensionsKtKt.privacySafe((Document)document, (Project)this.$project).getText(), false, 4, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Editor getEditor(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    private final String getCopiedContents() {
        String string;
        try {
            Transferable transferable = CopyPasteManager.getInstance().getContents();
            Object object = transferable != null ? transferable.getTransferData(DataFlavor.stringFlavor) : null;
            String string2 = object instanceof String ? (String)object : null;
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            string = "";
        }
        return string;
    }

    private final ContentSource determineTextSource(Editor editor, AnActionEvent event) {
        boolean containsChatData;
        if (this.isInTestsExecutionConsole(event)) {
            return ContentSource.TESTS_CONSOLE;
        }
        boolean bl = containsChatData = event.getDataContext().getData(ChatSession.Companion.getCurrentSession()) != null;
        if (editor != null) {
            Editor it = editor;
            boolean bl2 = false;
            if (this.isAIChatInput(it)) {
                return ContentSource.CHAT_INPUT_EDITOR;
            }
            if (containsChatData) {
                return ContentSource.CHAT_MESSAGE_CODE_SNIPPET_MANUAL;
            }
            EditorKind editorKind = it.getEditorKind();
            Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
            return ContentSource.Companion.toCodeSource(editorKind);
        }
        if (containsChatData) {
            return ContentSource.CHAT_MESSAGE_PLAINTEXT;
        }
        return ContentSource.UNIDENTIFIED_EDITOR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAIChatInput(Editor editor) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (!(file instanceof LightVirtualFile)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"AIAssistantInput-", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isInTestsExecutionConsole(AnActionEvent event) {
        return Intrinsics.areEqual((Object)event.getDataContext().getData(PlatformDataKeys.HELP_ID), (Object)"reference.runToolWindow.testResultsTab");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/AIAssistantCopyPasteListener$CopyRecord;", "", "text", "", "source", "Lcom/intellij/ml/llm/core/chat/services/paste/ContentSource;", "editorRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/services/paste/ContentSource;Ljava/lang/ref/WeakReference;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getSource", "()Lcom/intellij/ml/llm/core/chat/services/paste/ContentSource;", "setSource", "(Lcom/intellij/ml/llm/core/chat/services/paste/ContentSource;)V", "getEditorRef", "()Ljava/lang/ref/WeakReference;", "setEditorRef", "(Ljava/lang/ref/WeakReference;)V", "intellij.ml.llm.chat"})
    private static final class CopyRecord {
        @NotNull
        private String text;
        @NotNull
        private ContentSource source;
        @Nullable
        private WeakReference<Editor> editorRef;

        public CopyRecord(@NotNull String text2, @NotNull ContentSource source2, @Nullable WeakReference<Editor> editorRef) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)source2), (String)"source");
            this.text = text2;
            this.source = source2;
            this.editorRef = editorRef;
        }

        public /* synthetic */ CopyRecord(String string, ContentSource contentSource, WeakReference weakReference, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                contentSource = ContentSource.UNKNOWN;
            }
            if ((n & 4) != 0) {
                weakReference = null;
            }
            this(string, contentSource, weakReference);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.text = string;
        }

        @NotNull
        public final ContentSource getSource() {
            return this.source;
        }

        public final void setSource(@NotNull ContentSource contentSource) {
            Intrinsics.checkNotNullParameter((Object)((Object)contentSource), (String)"<set-?>");
            this.source = contentSource;
        }

        @Nullable
        public final WeakReference<Editor> getEditorRef() {
            return this.editorRef;
        }

        public final void setEditorRef(@Nullable WeakReference<Editor> weakReference) {
            this.editorRef = weakReference;
        }

        public CopyRecord() {
            this(null, null, null, 7, null);
        }
    }
}

