/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.session.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.core.chat.session.impl.CodexAuthMethod;
import com.intellij.ml.llm.core.chat.session.impl.CodexAuthMethodStateServiceKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.apache.hc.core5.annotation.Internal;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/session/impl/CodexAuthMethodStateService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "confirmedCodexChatSessionAuthMethods", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/core/chat/session/impl/CodexAuthMethod;", "codexAuthMethodStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getCodexAuthMethodStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "openAiApiKeyHashFlow", "", "getOpenAiApiKeyHashFlow", "isAuthMethodChangeRequired", "", "chatSessionId", "isAuthMethodChangeRequired$intellij_ml_llm_chat", "confirmAuthMethod", "", "authMethod", "Companion", "intellij.ml.llm.chat"})
@Internal
public final class CodexAuthMethodStateService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<String, CodexAuthMethod> confirmedCodexChatSessionAuthMethods;
    @NotNull
    private final StateFlow<CodexAuthMethod> codexAuthMethodStateFlow;
    @NotNull
    private final StateFlow<Integer> openAiApiKeyHashFlow;

    public CodexAuthMethodStateService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.confirmedCodexChatSessionAuthMethods = new ConcurrentHashMap();
        this.codexAuthMethodStateFlow = FlowKt.stateIn((Flow)AiaActivationManager.Companion.snapshotFlowOf(CodexAuthMethodStateService::codexAuthMethodStateFlow$lambda$0), (CoroutineScope)this.coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        this.openAiApiKeyHashFlow = FlowKt.stateIn((Flow)AiaActivationManager.Companion.snapshotFlowOf(CodexAuthMethodStateService::openAiApiKeyHashFlow$lambda$0), (CoroutineScope)this.coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
    }

    @NotNull
    public final StateFlow<CodexAuthMethod> getCodexAuthMethodStateFlow() {
        return this.codexAuthMethodStateFlow;
    }

    @NotNull
    public final StateFlow<Integer> getOpenAiApiKeyHashFlow() {
        return this.openAiApiKeyHashFlow;
    }

    public final boolean isAuthMethodChangeRequired$intellij_ml_llm_chat(@NotNull String chatSessionId) {
        Intrinsics.checkNotNullParameter((Object)chatSessionId, (String)"chatSessionId");
        CodexAuthMethod confirmedMethod = ((Map)this.confirmedCodexChatSessionAuthMethods).getOrDefault(chatSessionId, null);
        if (confirmedMethod == null) {
            return false;
        }
        return confirmedMethod != this.codexAuthMethodStateFlow.getValue();
    }

    public final void confirmAuthMethod(@NotNull String chatSessionId, @NotNull CodexAuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)chatSessionId, (String)"chatSessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)authMethod), (String)"authMethod");
        ((Map)this.confirmedCodexChatSessionAuthMethods).put(chatSessionId, authMethod);
    }

    private static final CodexAuthMethod codexAuthMethodStateFlow$lambda$0(AiaActivationManager $this$snapshotFlowOf) {
        Intrinsics.checkNotNullParameter((Object)$this$snapshotFlowOf, (String)"$this$snapshotFlowOf");
        return CodexAuthMethodStateServiceKt.access$getCodexAuthMethod($this$snapshotFlowOf);
    }

    private static final Integer openAiApiKeyHashFlow$lambda$0(AiaActivationManager $this$snapshotFlowOf) {
        Intrinsics.checkNotNullParameter((Object)$this$snapshotFlowOf, (String)"$this$snapshotFlowOf");
        return CodexAuthMethodStateServiceKt.access$getOpenAiApiKeyHash($this$snapshotFlowOf);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/session/impl/CodexAuthMethodStateService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/chat/session/impl/CodexAuthMethodStateService;", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nCodexAuthMethodStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodexAuthMethodStateService.kt\ncom/intellij/ml/llm/core/chat/session/impl/CodexAuthMethodStateService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,86:1\n42#2,3:87\n*S KotlinDebug\n*F\n+ 1 CodexAuthMethodStateService.kt\ncom/intellij/ml/llm/core/chat/session/impl/CodexAuthMethodStateService$Companion\n*L\n54#1:87,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CodexAuthMethodStateService getInstance() {
            boolean $i$f$service = false;
            Class<CodexAuthMethodStateService> serviceClass$iv = CodexAuthMethodStateService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CodexAuthMethodStateService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

