/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.parts.MessagePartTextListener;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartViewExtension;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartView;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartViewKt;
import com.intellij.ml.llm.core.chat.ui.chat.UserMessageTextToHtmlConvertor;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphore;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphoreKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Iterator;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0010\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0006\u0010\u0014\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartViewUpdater;", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartTextListener;", "partView", "Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartView;", "editorPane", "Ljavax/swing/JEditorPane;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartView;Ljavax/swing/JEditorPane;Lcom/intellij/openapi/project/Project;)V", "myBackgroundProcessingSemaphore", "Lcom/intellij/platform/util/coroutines/sync/OverflowSemaphore;", "onTextChanged", "", "newText", "", "convertTextToHTML", "Lcom/intellij/openapi/util/NlsSafe;", "txt", "schedulePostProcessingIfNecessary", "stop", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nTextPartView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPartView.kt\ncom/intellij/ml/llm/core/chat/ui/chat/TextPartViewUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1869#2,2:225\n*S KotlinDebug\n*F\n+ 1 TextPartView.kt\ncom/intellij/ml/llm/core/chat/ui/chat/TextPartViewUpdater\n*L\n170#1:225,2\n*E\n"})
final class TextPartViewUpdater
implements MessagePartTextListener {
    @NotNull
    private final TextPartView partView;
    @NotNull
    private final JEditorPane editorPane;
    @NotNull
    private final Project project;
    @NotNull
    private final OverflowSemaphore myBackgroundProcessingSemaphore;

    public TextPartViewUpdater(@NotNull TextPartView partView, @NotNull JEditorPane editorPane, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)partView, (String)"partView");
        Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.partView = partView;
        this.editorPane = editorPane;
        this.project = project;
        this.myBackgroundProcessingSemaphore = OverflowSemaphoreKt.OverflowSemaphore((int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
    }

    @Override
    public void onTextChanged(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        String newFastHtml = this.convertTextToHTML(newText);
        this.editorPane.setText(newFastHtml);
        this.editorPane.invalidate();
        if (TextPartViewKt.access$getLOG$p().isTraceEnabled()) {
            TextPartViewKt.access$getLOG$p().trace("fast update:\n" + newFastHtml + "\n");
        }
        this.schedulePostProcessingIfNecessary();
    }

    private final String convertTextToHTML(String txt) {
        if (this.partView.getPart().getMessage().getAuthor() == ChatMessageAuthor.Assistant) {
            MessagePartViewExtension.Context extCtx = new MessagePartViewExtension.Context(this.partView, this.project);
            return TextPartViewKt.markdownToChatHtml(txt, this.partView, extCtx);
        }
        ChatMessage chatMessage = this.partView.getPart().getMessage();
        Intrinsics.checkNotNull((Object)chatMessage, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage");
        Language language = ((MarkdownChatMessage)chatMessage).getMarkupLanguage();
        if (language != null) {
            Language markupLanguage = language;
            boolean bl = false;
            Iterable $this$forEach$iv = UserMessageTextToHtmlConvertor.Companion.getEP().getExtensionList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UserMessageTextToHtmlConvertor convertor = (UserMessageTextToHtmlConvertor)element$iv;
                boolean bl2 = false;
                String string = convertor.convert(txt, markupLanguage);
                if (string == null) continue;
                String convertedResult = string;
                boolean bl3 = false;
                return convertedResult;
            }
        }
        String string = XmlStringUtil.escapeString((String)txt);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeString(...)");
        return string;
    }

    private final void schedulePostProcessingIfNecessary() {
        if (this.partView.getPart().getMessage().getAuthor() == ChatMessageAuthor.Assistant) {
            ThreadingAssertions.assertEventDispatchThread();
            String html = this.editorPane.getText();
            MessagePartViewExtension.Context extCtx = new MessagePartViewExtension.Context(this.partView, this.project);
            CoroutineScope scope = AIAssistantServiceScope.Companion.getScope(this.project);
            BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, html, extCtx, null){
                int label;
                final /* synthetic */ TextPartViewUpdater this$0;
                final /* synthetic */ String $html;
                final /* synthetic */ MessagePartViewExtension.Context $extCtx;
                {
                    this.this$0 = $receiver;
                    this.$html = $html;
                    this.$extCtx = $extCtx;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = TextPartViewUpdater.access$getMyBackgroundProcessingSemaphore$p(this.this$0).withPermit((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$html, this.$extCtx, this.this$0, null){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                Object L$5;
                                Object L$6;
                                Object L$7;
                                int I$0;
                                int I$1;
                                int label;
                                final /* synthetic */ String $html;
                                final /* synthetic */ MessagePartViewExtension.Context $extCtx;
                                final /* synthetic */ TextPartViewUpdater this$0;
                                {
                                    this.$html = $html;
                                    this.$extCtx = $extCtx;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var3_3 = MessagePartViewExtension.Companion.getEP().getExtensionList();
                                            var4_4 = this.$html;
                                            var5_5 = this.$extCtx;
                                            $i$f$fold = 0;
                                            accumulator$iv = initial$iv;
                                            var8_8 = $this$fold$iv.iterator();
lbl11:
                                            // 2 sources

                                            while (var8_8.hasNext()) {
                                                element$iv = var8_8.next();
                                                var10_10 = (MessagePartViewExtension)element$iv;
                                                acc = accumulator$iv;
                                                $i$a$-fold-TextPartViewUpdater$schedulePostProcessingIfNecessary$1$1$newHtml$1 = 0;
                                                Intrinsics.checkNotNull((Object)acc);
                                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$fold$iv);
                                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)initial$iv);
                                                this.L$2 = var5_5;
                                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)accumulator$iv);
                                                this.L$4 = var8_8;
                                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                                this.L$6 = SpillingKt.nullOutSpilledVariable((Object)extension);
                                                this.L$7 = SpillingKt.nullOutSpilledVariable((Object)acc);
                                                this.I$0 = $i$f$fold;
                                                this.I$1 = $i$a$-fold-TextPartViewUpdater$schedulePostProcessingIfNecessary$1$1$newHtml$1;
                                                this.label = 1;
                                                v0 = extension.postProcessRawHTML(acc, var5_5, (Continuation<? super String>)this);
                                                if (v0 == var13_2) {
                                                    return var13_2;
                                                }
                                                ** GOTO lbl46
                                            }
                                            break;
                                        }
                                        case 1: {
                                            $i$a$-fold-TextPartViewUpdater$schedulePostProcessingIfNecessary$1$1$newHtml$1 = this.I$1;
                                            $i$f$fold = this.I$0;
                                            acc = (String)this.L$7;
                                            extension = (MessagePartViewExtension)this.L$6;
                                            element$iv = this.L$5;
                                            var8_8 = (Iterator)this.L$4;
                                            accumulator$iv = (String)this.L$3;
                                            var5_5 = (MessagePartViewExtension.Context)this.L$2;
                                            initial$iv = (String)this.L$1;
                                            $this$fold$iv = (Iterable)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl46:
                                            // 2 sources

                                            accumulator$iv = (String)v0;
                                            ** GOTO lbl11
                                        }
                                    }
                                    newHtml = accumulator$iv;
                                    if (!Intrinsics.areEqual((Object)this.$html, (Object)newHtml)) {
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)newHtml);
                                        this.L$1 = null;
                                        this.L$2 = null;
                                        this.L$3 = null;
                                        this.L$4 = null;
                                        this.L$5 = null;
                                        this.L$6 = null;
                                        this.L$7 = null;
                                        this.label = 2;
                                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$html, newHtml, null){
                                            int label;
                                            final /* synthetic */ TextPartViewUpdater this$0;
                                            final /* synthetic */ String $html;
                                            final /* synthetic */ String $newHtml;
                                            {
                                                this.this$0 = $receiver;
                                                this.$html = $html;
                                                this.$newHtml = $newHtml;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        if (Intrinsics.areEqual((Object)TextPartViewUpdater.access$getEditorPane$p(this.this$0).getText(), (Object)this.$html)) {
                                                            TextPartViewUpdater.access$getEditorPane$p(this.this$0).setText(this.$newHtml);
                                                            TextPartViewUpdater.access$getEditorPane$p(this.this$0).invalidate();
                                                            if (TextPartViewKt.access$getLOG$p().isTraceEnabled()) {
                                                                TextPartViewKt.access$getLOG$p().trace("slow update:\n" + this.$newHtml + "\n");
                                                            }
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v1 == var13_2) {
                                            return var13_2;
                                        }
                                    }
                                    ** GOTO lbl67
                                    {
                                        case 2: {
                                            newHtml = (String)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl67:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void stop() {
        CoroutineScope scope = AIAssistantServiceScope.Companion.getScope(this.project);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TextPartViewUpdater this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TextPartViewUpdater.access$getMyBackgroundProcessingSemaphore$p(this.this$0).withPermit((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ OverflowSemaphore access$getMyBackgroundProcessingSemaphore$p(TextPartViewUpdater $this) {
        return $this.myBackgroundProcessingSemaphore;
    }

    public static final /* synthetic */ JEditorPane access$getEditorPane$p(TextPartViewUpdater $this) {
        return $this.editorPane;
    }
}

