/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.ui.AIAssistantModelSelectorVmImpl;
import com.intellij.ml.llm.core.chat.ui.ChatModel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatPanel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatQuotaManager;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInput;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputSendActionKt;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputTrigger;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantSendActionState;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import java.awt.AWTKeyStroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputSendAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getInput", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInput;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantInputSendAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantInputSendAction.kt\ncom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputSendAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,109:1\n1#2:110\n42#3,3:111\n*S KotlinDebug\n*F\n+ 1 AIAssistantInputSendAction.kt\ncom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputSendAction\n*L\n71#1:111,3\n*E\n"})
public final class AIAssistantInputSendAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        AWTKeyStroke aWTKeyStroke;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!e.getPresentation().isEnabled()) {
            AIAssistantInputSendActionKt.access$getLog$p().info("Action was disabled in presentation");
            return;
        }
        AIAssistantInput input = this.getInput(e);
        if (input == null) {
            AIAssistantInputSendActionKt.access$getLog$p().error("Input is null");
            return;
        }
        if (!((Boolean)AIAssistantChatQuotaManager.Companion.getInstance().isGlobalSendAllowed().getValue()).booleanValue() && !input.isCodexOAuthBypassingQuota$intellij_ml_llm_chat()) {
            AIAssistantInputSendActionKt.access$getLog$p().warn("Action was invoked when Send button is disabled by a service. This means that `update` wasn't called before executing `actionPerformed`");
        }
        AIAssistantInputTrigger trigger = e.getInputEvent() instanceof KeyEvent ? AIAssistantInputTrigger.Key : AIAssistantInputTrigger.Button;
        InputEvent inputEvent = e.getInputEvent();
        KeyEvent keyEvent = inputEvent instanceof KeyEvent ? (KeyEvent)inputEvent : null;
        if (keyEvent != null) {
            KeyEvent it = keyEvent;
            boolean bl = false;
            aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(it);
        } else {
            aWTKeyStroke = null;
        }
        boolean forceRagMode = Intrinsics.areEqual((Object)aWTKeyStroke, (Object)input.getRagShortcut$intellij_ml_llm_chat());
        BuildersKt.launch$default((CoroutineScope)input.getScope$intellij_ml_llm_chat(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(input, trigger, forceRagMode, null){
            int label;
            final /* synthetic */ AIAssistantInput $input;
            final /* synthetic */ AIAssistantInputTrigger $trigger;
            final /* synthetic */ boolean $forceRagMode;
            {
                this.$input = $input;
                this.$trigger = $trigger;
                this.$forceRagMode = $forceRagMode;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$input.onButtonSendAction(this.$trigger, this.$forceRagMode, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AIAssistantInput input = this.getInput(e);
        if (input == null) {
            return;
        }
        if (input.isSubmitDisabledForJunieStubMode$intellij_ml_llm_chat()) {
            e.getPresentation().setEnabledAndVisible(false);
            AIAssistantInputSendActionKt.access$getLog$p().debug("Send button disabled: Junie stub mode");
        } else if (input.getSendingMode()) {
            void $this$update_u24lambda_u240;
            HelpTooltip helpTooltip;
            e.getPresentation().setIcon(AllIcons.Run.Stop);
            HelpTooltip helpTooltip2 = helpTooltip = new HelpTooltip();
            Key key = ActionButton.CUSTOM_HELP_TOOLTIP;
            Presentation presentation = e.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u240.setTitle(LLMBundle.message((String)"tooltip.title.stop", (Object[])new Object[0]));
            Unit unit = Unit.INSTANCE;
            presentation.putClientProperty(key, (Object)helpTooltip);
            AIAssistantInputSendActionKt.access$getLog$p().debug("Send button in sending mode (stop icon)");
        } else {
            HelpTooltip helpTooltip;
            boolean shouldApplyQuotaLock;
            boolean $i$f$service = false;
            Class<AIAssistantModelSelectorVmImpl> serviceClass$iv = AIAssistantModelSelectorVmImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            AIAssistantModelSelectorVmImpl modelSelector = (AIAssistantModelSelectorVmImpl)object;
            AIAssistantChatQuotaManager chatQuotaManager = AIAssistantChatQuotaManager.Companion.getInstance();
            ChatModel chatModel = (ChatModel)modelSelector.getSelectedModel().getValue();
            String modelId = chatModel != null ? chatModel.getId() : null;
            String string = modelId;
            if (string == null) {
                string = "";
            }
            boolean bl = shouldApplyQuotaLock = !chatQuotaManager.isLocalModel(string) && !input.isCodexOAuthBypassingQuota$intellij_ml_llm_chat();
            if (chatQuotaManager.lockActionIfNeeded(e, shouldApplyQuotaLock)) {
                e.getPresentation().setIcon(MLLlmIcons.Chat.Send);
                AIAssistantInputSendActionKt.access$getLog$p().debug("Send button disabled: quota/license restriction");
                return;
            }
            AIAssistantSendActionState sendActionState = input.getSendActionState();
            e.getPresentation().setEnabled(sendActionState.isEnabled());
            e.getPresentation().setIcon(MLLlmIcons.Chat.Send);
            ValidationInfo validationInfo = input.getInputValidationInfo$intellij_ml_llm_chat();
            HelpTooltip helpTooltip3 = helpTooltip = new HelpTooltip();
            Key key = ActionButton.CUSTOM_HELP_TOOLTIP;
            Presentation presentation = e.getPresentation();
            boolean bl2 = false;
            if (validationInfo == null) {
                $this$update_u24lambda_u241.setTitle(LLMBundle.message((String)"tooltip.title.send", (Object[])new Object[0]));
                $this$update_u24lambda_u241.setShortcut("Enter");
            } else {
                $this$update_u24lambda_u241.setTitle(validationInfo.message);
                e.getPresentation().setEnabled(false);
            }
            Unit unit = Unit.INSTANCE;
            presentation.putClientProperty(key, (Object)helpTooltip);
            if (e.getPresentation().isEnabled()) {
                AIAssistantInputSendActionKt.access$getLog$p().debug("Send button enabled");
            } else {
                AIAssistantInputSendActionKt.access$getLog$p().debug("Send button disabled: " + sendActionState + ", validationInfo=" + validationInfo);
            }
        }
    }

    private final AIAssistantInput getInput(AnActionEvent $this$getInput) {
        AIAssistantChatPanel chat;
        AIAssistantChatPanel aIAssistantChatPanel = chat = (AIAssistantChatPanel)$this$getInput.getDataContext().getData(AIAssistantChatPanel.Companion.getCurrentDialogKey());
        return aIAssistantChatPanel != null ? aIAssistantChatPanel.getInput() : null;
    }
}

