/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.ml.llm.agents.A2UXEvent;
import com.intellij.ml.llm.agents.AgentClient;
import com.intellij.ml.llm.agents.AgentClientEvent;
import com.intellij.ml.llm.chat.session.FileChangesMergeUtil;
import com.intellij.ml.llm.chat.session.FileChangesTracker;
import com.intellij.ml.llm.chat.session.SessionHistoryStorage;
import com.intellij.ml.llm.core.statistics.fus.AgentChatEventLogger;
import com.intellij.ml.llm.core.statistics.fus.AgentChatStatisticCollectorKt;
import com.intellij.ml.llm.core.statistics.fus.FileChangeStats;
import com.intellij.ml.llm.core.statistics.fus.FileChangeStatsKt;
import com.intellij.ml.llm.core.statistics.fus.FusTaskExitStatus;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.a2ux.api.AgentEvent;
import org.jetbrains.a2ux.api.AgentFailureEvent;
import org.jetbrains.a2ux.api.FileChange;
import org.jetbrains.a2ux.api.FileChangesBlockUpdatedEvent;
import org.jetbrains.a2ux.api.ResultBlockUpdatedEvent;
import org.jetbrains.a2ux.extensions.A2uxTaskState;
import org.jetbrains.a2ux.extensions.TaskRequestId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector;", "", "<init>", "()V", "activities", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/a2ux/extensions/TaskRequestId;", "Lcom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle;", "logAgentClientEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;", "taskRequestId", "agentClient", "Lcom/intellij/ml/llm/agents/AgentClient;", "event", "Lcom/intellij/ml/llm/agents/AgentClientEvent;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lorg/jetbrains/a2ux/extensions/TaskRequestId;Lcom/intellij/ml/llm/agents/AgentClient;Lcom/intellij/ml/llm/agents/AgentClientEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logAgentRollback", "totalPromptsRolledBack", "", "changes", "", "Lorg/jetbrains/a2ux/api/FileChange;", "(Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;ILjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logSingleRollback", "change", "(Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lorg/jetbrains/a2ux/api/FileChange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "RequestLifecycle", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAgentChatStatisticCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1563#2:148\n1634#2,3:149\n1563#2:152\n1634#2,3:153\n*S KotlinDebug\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector\n*L\n83#1:148\n83#1:149,3\n87#1:152\n87#1:153,3\n*E\n"})
public final class AgentChatStatisticCollector {
    @NotNull
    public static final AgentChatStatisticCollector INSTANCE = new AgentChatStatisticCollector();
    @NotNull
    private static final ConcurrentHashMap<TaskRequestId, RequestLifecycle> activities = new ConcurrentHashMap();

    private AgentChatStatisticCollector() {
    }

    @Nullable
    public final Object logAgentClientEvent(@NotNull Project project, @Nullable SessionHistoryStorage.PersistanceId sessionId, @NotNull TaskRequestId taskRequestId, @NotNull AgentClient agentClient, @NotNull AgentClientEvent event, @NotNull Continuation<? super Unit> $completion) {
        FusTaskExitStatus exitStatus;
        AgentEvent innerEvent;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        if (!(event instanceof A2UXEvent)) {
            return Unit.INSTANCE;
        }
        if (AgentChatStatisticCollectorKt.access$isTerminalState(((A2UXEvent)event).getState()) && activities.get(taskRequestId) == null) {
            return Unit.INSTANCE;
        }
        RequestLifecycle requestLifecycle = activities.computeIfAbsent(taskRequestId, arg_0 -> AgentChatStatisticCollector.logAgentClientEvent$lambda$1(arg_0 -> AgentChatStatisticCollector.logAgentClientEvent$lambda$0(project, agentClient, sessionId, taskRequestId, event, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)requestLifecycle, (String)"computeIfAbsent(...)");
        RequestLifecycle requestState = requestLifecycle;
        AgentEvent agentEvent = innerEvent = ((A2UXEvent)event).getEvent();
        if (agentEvent instanceof FileChangesBlockUpdatedEvent) {
            requestState.recordChanges((FileChangesBlockUpdatedEvent)innerEvent);
        } else if (agentEvent instanceof ResultBlockUpdatedEvent) {
            requestState.recordChanges((ResultBlockUpdatedEvent)innerEvent);
        }
        AgentEvent agentEvent2 = innerEvent;
        FusTaskExitStatus fusTaskExitStatus = agentEvent2 instanceof AgentFailureEvent ? FusTaskExitStatus.FAILED : (exitStatus = agentEvent2 instanceof ResultBlockUpdatedEvent ? AgentChatStatisticCollectorKt.access$toFusExitStatus((ResultBlockUpdatedEvent)innerEvent) : null);
        if (exitStatus != null) {
            AgentChatEventLogger.INSTANCE.logGenerationFinished$intellij_ml_llm_chat(requestState.getIdeActivity(), agentClient, sessionId, taskRequestId, requestState.computeStats(), exitStatus);
            activities.remove(taskRequestId);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logAgentRollback(@NotNull SessionHistoryStorage.PersistanceId sessionId, int totalPromptsRolledBack, @NotNull List<FileChange> changes, @NotNull Continuation<? super Unit> $completion) {
        Collection<FileChangeStats> collection;
        FileChange it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = FileChangesMergeUtil.INSTANCE.mergeFileChanges(changes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FileChangesMergeUtil.FileChangesMerged fileChangesMerged = (FileChangesMergeUtil.FileChangesMerged)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getMergedChange());
        }
        List mergedChanges = (List)destination$iv$iv;
        $this$map$iv = mergedChanges;
        int n = totalPromptsRolledBack;
        SessionHistoryStorage.PersistanceId persistanceId = sessionId;
        object = AgentChatEventLogger.INSTANCE;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FileChange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileChangeStatsKt.computeStats(it));
        }
        collection = (List)destination$iv$iv;
        ((AgentChatEventLogger)((Object)object)).logGenerationsRejected$intellij_ml_llm_chat(persistanceId, n, (List<FileChangeStats>)collection);
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logSingleRollback(@NotNull SessionHistoryStorage.PersistanceId sessionId, @NotNull FileChange change, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        AgentChatEventLogger.INSTANCE.logRollbackFile$intellij_ml_llm_chat(sessionId, FileChangeStatsKt.computeStats(change));
        return Unit.INSTANCE;
    }

    private static final RequestLifecycle logAgentClientEvent$lambda$0(Project $project, AgentClient $agentClient, SessionHistoryStorage.PersistanceId $sessionId, TaskRequestId $taskRequestId, AgentClientEvent $event, TaskRequestId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StructuredIdeActivity ideActivity = AgentChatEventLogger.INSTANCE.logGenerationStarted($project, $agentClient, $sessionId, $taskRequestId);
        return new RequestLifecycle($taskRequestId, ((A2UXEvent)$event).getState(), ideActivity);
    }

    private static final RequestLifecycle logAgentClientEvent$lambda$1(Function1 $tmp0, Object p0) {
        return (RequestLifecycle)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle;", "", "taskRequestId", "Lorg/jetbrains/a2ux/extensions/TaskRequestId;", "state", "Lorg/jetbrains/a2ux/extensions/A2uxTaskState;", "ideActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "<init>", "(Lorg/jetbrains/a2ux/extensions/TaskRequestId;Lorg/jetbrains/a2ux/extensions/A2uxTaskState;Lcom/intellij/internal/statistic/StructuredIdeActivity;)V", "getTaskRequestId", "()Lorg/jetbrains/a2ux/extensions/TaskRequestId;", "getState", "()Lorg/jetbrains/a2ux/extensions/A2uxTaskState;", "getIdeActivity", "()Lcom/intellij/internal/statistic/StructuredIdeActivity;", "fileChangesTracker", "Lcom/intellij/ml/llm/chat/session/FileChangesTracker;", "resultEvent", "Lorg/jetbrains/a2ux/api/ResultBlockUpdatedEvent;", "recordChanges", "", "event", "Lorg/jetbrains/a2ux/api/FileChangesBlockUpdatedEvent;", "computeStats", "", "Lcom/intellij/ml/llm/core/statistics/fus/FileChangeStats;", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nAgentChatStatisticCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1563#2:148\n1634#2,3:149\n*S KotlinDebug\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle\n*L\n120#1:148\n120#1:149,3\n*E\n"})
    private static final class RequestLifecycle {
        @NotNull
        private final TaskRequestId taskRequestId;
        @Nullable
        private final A2uxTaskState state;
        @NotNull
        private final StructuredIdeActivity ideActivity;
        @NotNull
        private final FileChangesTracker fileChangesTracker;
        @Nullable
        private ResultBlockUpdatedEvent resultEvent;

        public RequestLifecycle(@NotNull TaskRequestId taskRequestId, @Nullable A2uxTaskState state, @NotNull StructuredIdeActivity ideActivity) {
            Intrinsics.checkNotNullParameter((Object)taskRequestId, (String)"taskRequestId");
            Intrinsics.checkNotNullParameter((Object)ideActivity, (String)"ideActivity");
            this.taskRequestId = taskRequestId;
            this.state = state;
            this.ideActivity = ideActivity;
            this.fileChangesTracker = new FileChangesTracker();
        }

        @NotNull
        public final TaskRequestId getTaskRequestId() {
            return this.taskRequestId;
        }

        @Nullable
        public final A2uxTaskState getState() {
            return this.state;
        }

        @NotNull
        public final StructuredIdeActivity getIdeActivity() {
            return this.ideActivity;
        }

        public final void recordChanges(@NotNull FileChangesBlockUpdatedEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.fileChangesTracker.recordChanges(event);
        }

        public final void recordChanges(@NotNull ResultBlockUpdatedEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.resultEvent = event;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FileChangeStats> computeStats() {
            void $this$mapTo$iv$iv;
            Object object = this.resultEvent;
            if (object == null || (object = object.getChanges()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object lastMomentChanges = object;
            List<FileChange> changes = this.fileChangesTracker.buildResultChanges((List<FileChange>)lastMomentChanges);
            Iterable $this$map$iv = changes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileChange fileChange = (FileChange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileChangeStatsKt.computeStats((FileChange)it));
            }
            return (List)destination$iv$iv;
        }
    }
}

