/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.qa.ui;

import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.ml.llm.qa.ui.AIChatButtonKt;
import com.intellij.ml.llm.qa.ui.ActionButtonLookWithCustomBackground;
import com.intellij.ml.llm.qa.ui.ShowSettingsOnPageAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0014J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/qa/ui/AIChatButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButtonWithText;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "dataContext", "Lkotlin/Function0;", "Lcom/intellij/openapi/actionSystem/DataContext;", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Lkotlin/jvm/functions/Function0;)V", "getButtonLook", "Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "getMargins", "Ljava/awt/Insets;", "update", "", "getDataContext", "performAction", "e", "Ljava/awt/event/MouseEvent;", "Companion", "intellij.ml.llm.chat"})
public final class AIChatButton
extends ActionButtonWithText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<DataContext> dataContext;
    private static final int BUTTONS_GAP_TOP_BOT = 6;
    private static final int BUTTONS_GAP_LEFT_RIGHT = 15;

    public AIChatButton(@NotNull AnAction action2, @NotNull Presentation presentation, @NotNull Function0<? extends DataContext> dataContext) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter(dataContext, (String)"dataContext");
        super(action2, presentation, "EditorTab", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.dataContext = dataContext;
    }

    @NotNull
    protected ActionButtonLook getButtonLook() {
        Color color = AIAssistantColors.INSTANCE.getInlineCodeBackground(ChatMessageAuthor.Assistant);
        return (ActionButtonLook)new ActionButtonLookWithCustomBackground(color);
    }

    @NotNull
    protected Insets getMargins() {
        JBInsets jBInsets = JBUI.insets((int)6, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    public void update() {
        this.updateToolTipText();
        this.updateIcon();
    }

    @NotNull
    protected DataContext getDataContext() {
        return (DataContext)this.dataContext.invoke();
    }

    protected void performAction(@Nullable MouseEvent e) {
        String actionId;
        super.performAction(e);
        String string = ActionManager.getInstance().getId(this.getAction());
        if (string == null) {
            string = this.getAction() instanceof ShowSettingsOnPageAction ? "ShowSettings" : null;
        }
        if ((actionId = string) == null) {
            return;
        }
        Project project = (Project)this.getDataContext().getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChatSession chatSession2 = FocusedChatSessionHost.Companion.getInstance(project2).getFocusedChatSession();
        if (chatSession2 == null) {
            return;
        }
        ChatSession chatSession3 = chatSession2;
        AIChatButtonKt.access$getLogger$p().info("action button clicked: " + actionId + " " + chatSession3.getUid());
        AIAssistantChatEventLogger.logAiGeneratedButtonClicked(actionId, chatSession3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/qa/ui/AIChatButton$Companion;", "", "<init>", "()V", "BUTTONS_GAP_TOP_BOT", "", "BUTTONS_GAP_LEFT_RIGHT", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

