/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ml.llm.matterhorn.JuniePreconditionChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u000b*\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0\u0012H\u0004R\u001b\u0010\u0014\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/matterhorn/DefaultJuniePreconditionChecker;", "Lcom/intellij/ml/llm/matterhorn/JuniePreconditionChecker;", "<init>", "()V", "checkJunieAvailable", "", "Lcom/intellij/ml/llm/matterhorn/JuniePreconditionChecker$JunieProblem;", "project", "Lcom/intellij/openapi/project/Project;", "canRunJunie", "isPyCharm", "", "isIntelliJ", "isWebStorm", "checkUntestedIde", "allowQuickFix", "hasSdk", "condition", "Lkotlin/Function1;", "Lcom/intellij/openapi/projectRoots/Sdk;", "isInternal", "()Z", "isInternal$delegate", "Lkotlin/Lazy;", "value", "isUntestedIdeAccepted", "setUntestedIdeAccepted", "(Z)V", "ej-core"})
@SourceDebugExtension(value={"SMAP\nJuniePreconditions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JuniePreconditions.kt\ncom/intellij/ml/llm/matterhorn/DefaultJuniePreconditionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1#2:132\n11483#3,9:122\n13409#3:131\n13410#3:133\n11492#3:134\n1755#4,3:135\n*S KotlinDebug\n*F\n+ 1 JuniePreconditions.kt\ncom/intellij/ml/llm/matterhorn/DefaultJuniePreconditionChecker\n*L\n104#1:132\n104#1:122,9\n104#1:131\n104#1:133\n104#1:134\n106#1:135,3\n*E\n"})
public class DefaultJuniePreconditionChecker
implements JuniePreconditionChecker {
    @NotNull
    private final Lazy isInternal$delegate = LazyKt.lazy(DefaultJuniePreconditionChecker::isInternal_delegate$lambda$6);

    @Override
    @NotNull
    public List<JuniePreconditionChecker.JunieProblem> checkJunieAvailable(@NotNull Project project) {
        Object object;
        VirtualFile projectDir;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List problems = new ArrayList();
        if (SystemInfo.isWindows) {
            problems.add(new JuniePreconditionChecker.JunieProblem("Windows is not supported", null, null, 6, null));
        }
        if ((projectDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            problems.add(new JuniePreconditionChecker.JunieProblem("Our current support is limited to projects with a simple structure: all modules must reside under a single project root, and the configuration file must be defined at that root level", null, null, 6, null));
        }
        if (!this.isInternal()) {
            JuniePreconditionChecker.JunieProblem junieProblem = this.checkUntestedIde(false);
            if (junieProblem != null) {
                JuniePreconditionChecker.JunieProblem it = junieProblem;
                boolean bl = false;
                problems.add(it);
            }
        }
        if ((object = projectDir) != null && (object = object.getPath()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)" ", (boolean)false, (int)2, null) : false) {
            problems.add(new JuniePreconditionChecker.JunieProblem("Whitespaces in project path are not supported", null, null, 6, null));
        }
        return problems;
    }

    @Override
    @NotNull
    public List<JuniePreconditionChecker.JunieProblem> canRunJunie(@NotNull Project project) {
        JuniePreconditionChecker.JunieProblem junieProblem;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JuniePreconditionChecker.JunieProblem it = junieProblem = this.checkUntestedIde(this.isInternal());
        boolean bl = false;
        return CollectionsKt.listOfNotNull((Object)(this.isInternal() ? junieProblem : null));
    }

    private final boolean isPyCharm() {
        return PlatformUtils.isPyCharm();
    }

    private final boolean isIntelliJ() {
        return PlatformUtils.isIntelliJ();
    }

    private final boolean isWebStorm() {
        return PlatformUtils.isWebStorm();
    }

    private final JuniePreconditionChecker.JunieProblem checkUntestedIde(boolean allowQuickFix) {
        String string;
        if (this.isPyCharm() || this.isIntelliJ() || this.isWebStorm()) {
            return null;
        }
        if (allowQuickFix && this.isUntestedIdeAccepted()) {
            return null;
        }
        Function1 action2 = (Function1)new Function1<Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultJuniePreconditionChecker this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultJuniePreconditionChecker.access$setUntestedIdeAccepted(this.this$0, true);
                        return Boxing.boxBoolean((boolean)true);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Boolean> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
        String string2 = string = "Accept risk and run";
        String string3 = "Junie is officially supported in PyCharm Professional, WebStorm and IDEA Ultimate";
        boolean bl = false;
        boolean bl2 = allowQuickFix;
        String string4 = bl2 ? string : null;
        String it = string = action2;
        String string5 = string4;
        boolean bl3 = false;
        boolean bl4 = allowQuickFix;
        String string6 = bl4 ? string : null;
        String string7 = string5;
        String string8 = string3;
        return new JuniePreconditionChecker.JunieProblem(string8, string7, (Function1<? super Continuation<? super Boolean>, ? extends Object>)string6);
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean hasSdk(@NotNull Project $this$hasSdk, @NotNull Function1<? super Sdk, Boolean> condition) {
        boolean bl;
        block5: {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$hasSdk, (String)"<this>");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Sdk sdk = ProjectRootManager.getInstance((Project)$this$hasSdk).getProjectSdk();
            boolean bl2 = sdk != null ? ((Boolean)condition.invoke((Object)sdk)).booleanValue() : false;
            if (bl2) {
                return true;
            }
            Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance($this$hasSdk).getModules();
            boolean $i$f$mapNotNull = false;
            Module[] moduleArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Sdk it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl3 = false;
                void it = element$iv$iv;
                boolean bl4 = false;
                if (ModuleRootManager.getInstance((Module)it).getSdk() == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Sdk it = (Sdk)element$iv;
                    boolean bl6 = false;
                    if (!((Boolean)condition.invoke((Object)it)).booleanValue()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isInternal() {
        Lazy lazy = this.isInternal$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean isUntestedIdeAccepted() {
        return PropertiesComponent.getInstance().getBoolean("matterhorn.junie.untestedIdeAccepted", false);
    }

    private final void setUntestedIdeAccepted(boolean value) {
        PropertiesComponent.getInstance().setValue("matterhorn.junie.untestedIdeAccepted", value);
    }

    private static final boolean isInternal_delegate$lambda$6() {
        return ApplicationManager.getApplication().isInternal();
    }

    public static final /* synthetic */ void access$setUntestedIdeAccepted(DefaultJuniePreconditionChecker $this, boolean value) {
        $this.setUntestedIdeAccepted(value);
    }
}

