/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.CacheType;
import com.intellij.ml.llm.matterhorn.MatterhornCaches;
import com.intellij.ml.llm.matterhorn.RootExecutionContextKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.Compressor;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020)H\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010-\u001a\u00020\u001bH\u0016J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/matterhorn/FileMatterhornCaches;", "Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "Ljava/nio/file/Path;", "artifacts", "getArtifacts", "()Ljava/nio/file/Path;", "caches", "getCaches", "logs", "getLogs", "sources", "getSources", "trajectory", "presentations", "getPresentations", "exitStatus", "media", "nonCachedRequests", "issues", "save", "", "type", "Lcom/intellij/ml/llm/matterhorn/CacheType;", "path", "", "content", "contains", "", "load", "loadAllPaths", "", "hasAnyOfType", "remove", "saveBinary", "", "loadBinary", "saveSingle", "loadSingle", "clear", "dumpToZip", "zip", "Lcom/intellij/util/io/Compressor$Zip;", "calculateCachesPath", "getPath", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMatterhornCaches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatterhornCaches.kt\ncom/intellij/ml/llm/matterhorn/FileMatterhornCaches\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,252:1\n1755#2,3:253\n14#3:256\n*S KotlinDebug\n*F\n+ 1 MatterhornCaches.kt\ncom/intellij/ml/llm/matterhorn/FileMatterhornCaches\n*L\n112#1:253,3\n45#1:256\n*E\n"})
public final class FileMatterhornCaches
implements MatterhornCaches {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile projectPath;
    @NotNull
    private final Path root;
    @NotNull
    private final Path artifacts;
    @NotNull
    private final Path caches;
    @NotNull
    private final Path logs;
    @NotNull
    private final Path sources;
    @NotNull
    private final Path trajectory;
    @NotNull
    private final Path presentations;
    @NotNull
    private final Path exitStatus;
    @NotNull
    private final Path media;
    @NotNull
    private final Path nonCachedRequests;
    @NotNull
    private final Path issues;
    @NotNull
    private static final Logger logger;

    public FileMatterhornCaches(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        this.projectPath = virtualFile;
        this.root = this.calculateCachesPath();
        Path path = this.root.resolve(".matterhorn");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.artifacts = path;
        Path path2 = this.root.resolve(".caches");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.caches = path2;
        Path path3 = this.artifacts.resolve("logs");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        this.logs = path3;
        Path path4 = this.artifacts.resolve("sources");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        this.sources = path4;
        Path path5 = this.artifacts.resolve("trajectory");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        this.trajectory = path5;
        Path path6 = this.artifacts.resolve("representations");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this.presentations = path6;
        Path path7 = this.artifacts.resolve("exit.status");
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        this.exitStatus = path7;
        Path path8 = this.artifacts.resolve("media");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
        this.media = path8;
        Path path9 = this.artifacts.resolve("non_cached_requests.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
        this.nonCachedRequests = path9;
        Path path10 = this.artifacts.resolve("issues");
        Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"resolve(...)");
        this.issues = path10;
    }

    @NotNull
    public final Path getArtifacts() {
        return this.artifacts;
    }

    @NotNull
    public final Path getCaches() {
        return this.caches;
    }

    @NotNull
    public final Path getLogs() {
        return this.logs;
    }

    @NotNull
    public final Path getSources() {
        return this.sources;
    }

    @NotNull
    public final Path getPresentations() {
        return this.presentations;
    }

    @Override
    public void save(@NotNull CacheType type, @NotNull String path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path typePath = this.getPath(type);
        Path targetFile = typePath.resolve(path);
        Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)targetFile);
        PathsKt.writeText((Path)targetFile, (CharSequence)content, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
    }

    @Override
    public boolean contains(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path typePath = this.getPath(type);
        Path targetFile = typePath.resolve(path);
        Intrinsics.checkNotNull((Object)targetFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(targetFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @Override
    @Nullable
    public String load(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path typePath = this.getPath(type);
        Path targetFile = typePath.resolve(path);
        Intrinsics.checkNotNull((Object)targetFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(targetFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return PathsKt.readText((Path)targetFile, (Charset)Charsets.UTF_8);
    }

    @Override
    @NotNull
    public Iterable<String> loadAllPaths(@NotNull CacheType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Path cacheTypePath = this.getPath(type);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(cacheTypePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        List<String> list = Files.walk(cacheTypePath, new FileVisitOption[0]).filter(arg_0 -> FileMatterhornCaches.loadAllPaths$lambda$1(FileMatterhornCaches::loadAllPaths$lambda$0, arg_0)).map(arg_0 -> FileMatterhornCaches.loadAllPaths$lambda$3(arg_0 -> FileMatterhornCaches.loadAllPaths$lambda$2(cacheTypePath, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAnyOfType(@NotNull CacheType type) {
        LinkOption[] linkOptionArray;
        Path it;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Path typePath = this.getPath(type);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(typePath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        Iterable $this$any$iv = PathsKt.listDirectoryEntries$default((Path)typePath, null, (int)1, null);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (Path)element$iv;
            boolean bl = false;
            linkOptionArray = new LinkOption[]{};
        } while (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        return true;
    }

    @Override
    public void remove(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path typePath = this.getPath(type);
        Path targetFile = typePath.resolve(path);
        Intrinsics.checkNotNull((Object)targetFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(targetFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(targetFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                PathsKt.deleteRecursively((Path)targetFile);
            } else {
                Files.deleteIfExists(targetFile);
            }
        }
    }

    @Override
    public void saveBinary(@NotNull CacheType type, @NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path typePath = this.getPath(type);
        Path targetFile = typePath.resolve(path);
        Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)targetFile);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(targetFile, content, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    @Override
    @Nullable
    public byte[] loadBinary(@NotNull CacheType type, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path typePath = this.getPath(type);
        Path targetFile = typePath.resolve(path);
        Intrinsics.checkNotNull((Object)targetFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(targetFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        byte[] byArray = Files.readAllBytes(targetFile);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return byArray;
    }

    @Override
    public void saveSingle(@NotNull CacheType type, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path typePath = this.getPath(type);
        Files.createDirectories(typePath.getParent(), new FileAttribute[0]);
        PathsKt.writeText((Path)typePath, (CharSequence)content, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
    }

    @Override
    @Nullable
    public String loadSingle(@NotNull CacheType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Path typePath = this.getPath(type);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(typePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return PathsKt.readText((Path)typePath, (Charset)Charsets.UTF_8);
    }

    @Override
    public void clear() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.artifacts, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.deleteRecursively((Path)this.artifacts);
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(this.caches, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            PathsKt.deleteRecursively((Path)this.caches);
        }
    }

    @Override
    public void dumpToZip(@NotNull Compressor.Zip zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        zip.addDirectory(".matterhorn", this.artifacts);
    }

    private final Path calculateCachesPath() {
        Object object;
        block3: {
            block2: {
                object = System.getenv(RootExecutionContextKt.getMATTERHORN_CACHES_ENV_VAR());
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Path path = Paths.get(this.projectPath.getPath(), new String[0]).resolve(it);
                object = path;
                if (path != null) break block3;
            }
            object = ProjectUtil.getProjectDataPath((Project)this.project, (String)"matterhorn");
        }
        Object result = object;
        logger.info("Matterhorn caches path: " + result.toString());
        return result;
    }

    private final Path getPath(CacheType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.artifacts;
            case 2 -> this.caches;
            case 3 -> this.logs;
            case 4 -> this.sources;
            case 5 -> this.trajectory;
            case 6 -> this.presentations;
            case 7 -> this.exitStatus;
            case 8 -> this.media;
            case 9 -> this.nonCachedRequests;
            case 10 -> this.issues;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean loadAllPaths$lambda$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean loadAllPaths$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String loadAllPaths$lambda$2(Path $cacheTypePath, Path it) {
        Intrinsics.checkNotNull((Object)it);
        return ((Object)PathsKt.relativeTo((Path)it, (Path)$cacheTypePath)).toString();
    }

    private static final String loadAllPaths$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileMatterhornCaches.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FileMatterhornCaches.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/matterhorn/FileMatterhornCaches$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CacheType.values().length];
            try {
                nArray[CacheType.Artifact.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Cache.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Logs.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Sources.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Trajectory.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Presentations.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.ExitStatus.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Media.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.NonCachedRequests.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheType.Issues.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

