/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Util {
    private Util() {
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(JsonNode node) {
        return node == null || node.isEmpty();
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> List<T> nullSafe(T[] array) {
        if (Util.isNullOrEmpty(array)) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> List<T> nullSafe(List<T> list2) {
        if (list2 == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    public static boolean nullSafeEquals(Object one, Object other) {
        if (one == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return one.hashCode() == other.hashCode() && one.equals(other);
    }
}

