/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.git.AddLoadedFile;
import org.jetbrains.settingsRepository.git.DeleteDirectory;
import org.jetbrains.settingsRepository.git.DeleteFile;
import org.jetbrains.settingsRepository.git.DirCacheEditor;
import org.jetbrains.settingsRepository.git.DirCacheTerminator;
import org.jetbrains.settingsRepository.git.PathEdit;
import org.jetbrains.settingsRepository.git.PathEditBase;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\n\u001a\u00020\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u001a&\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\u001a\u0010\u0014\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005\u001a&\u0010\u0016\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u0010\u0012\u001a\u00020\u0013\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"EDIT_CMP", "Ljava/util/Comparator;", "Lorg/jetbrains/settingsRepository/git/PathEdit;", "Lkotlin/Comparator;", "encodePath", "", "path", "", "DeleteFile", "Lorg/jetbrains/settingsRepository/git/DeleteFile;", "edit", "", "Lorg/eclipse/jgit/lib/Repository;", "edits", "", "deleteAllFiles", "deletedSet", "", "fromWorkingTree", "", "writePath", "bytes", "deletePath", "isFile", "intellij.settingsRepository"})
public final class DirCacheEditorKt {
    @NotNull
    private static final Comparator<PathEdit> EDIT_CMP = DirCacheEditorKt::EDIT_CMP$lambda$0;

    private static final byte[] encodePath(String path) {
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(path);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"encode(...)");
        byte[] bytes = IoKt.toByteArray$default((ByteBuffer)byteBuffer, (boolean)false, (int)1, null);
        if (SystemInfo.isWindows) {
            int n = bytes.length;
            for (int i = 0; i < n; ++i) {
                if ((char)bytes[i] != '\\') continue;
                bytes[i] = 47;
            }
        }
        return bytes;
    }

    @NotNull
    public static final DeleteFile DeleteFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new DeleteFile(DirCacheEditorKt.encodePath(path));
    }

    public static final void edit(@NotNull Repository $this$edit, @NotNull PathEdit edit) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        DirCacheEditorKt.edit($this$edit, CollectionsKt.listOf((Object)edit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void edit(@NotNull Repository $this$edit, @NotNull List<? extends PathEdit> edits) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"<this>");
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        if (edits.isEmpty()) {
            return;
        }
        DirCache dirCache = $this$edit.lockDirCache();
        try {
            Intrinsics.checkNotNull((Object)dirCache);
            new DirCacheEditor(edits, $this$edit, dirCache, dirCache.getEntryCount() + 4).commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteAllFiles(@NotNull Repository $this$deleteAllFiles, @Nullable Set<String> deletedSet, boolean fromWorkingTree) {
        File[] files;
        Intrinsics.checkNotNullParameter((Object)$this$deleteAllFiles, (String)"<this>");
        DirCache dirCache = $this$deleteAllFiles.lockDirCache();
        try {
            if (deletedSet != null) {
                int n = dirCache.getEntryCount();
                for (int i = 0; i < n; ++i) {
                    DirCacheEntry entry = dirCache.getEntry(i);
                    if (!Intrinsics.areEqual((Object)entry.getFileMode(), (Object)FileMode.REGULAR_FILE)) continue;
                    String string = entry.getPathString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
                    deletedSet.add(string);
                }
            }
            Intrinsics.checkNotNull((Object)dirCache);
            new DirCacheTerminator(dirCache).commit();
        }
        finally {
            dirCache.unlock();
        }
        if (fromWorkingTree && (files = $this$deleteAllFiles.getWorkTree().listFiles(DirCacheEditorKt::deleteAllFiles$lambda$0)) != null) {
            for (File file : files) {
                FileUtil.delete((File)file);
            }
        }
    }

    public static /* synthetic */ void deleteAllFiles$default(Repository repository, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        DirCacheEditorKt.deleteAllFiles(repository, set, bl);
    }

    public static final void writePath(@NotNull Repository $this$writePath, @NotNull String path, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$writePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        DirCacheEditorKt.edit($this$writePath, new AddLoadedFile(path, bytes, 0L, 4, null));
        FileUtil.writeToFile((File)new File($this$writePath.getWorkTree(), path), (byte[])bytes);
    }

    public static final void deletePath(@NotNull Repository $this$deletePath, @NotNull String path, boolean isFile, boolean fromWorkingTree) {
        Intrinsics.checkNotNullParameter((Object)$this$deletePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirCacheEditorKt.edit($this$deletePath, isFile ? (PathEditBase)DirCacheEditorKt.DeleteFile(path) : (PathEditBase)new DeleteDirectory(path));
        if (fromWorkingTree) {
            Path workTree = $this$deletePath.getWorkTree().toPath();
            Path ioFile = workTree.resolve(path);
            Intrinsics.checkNotNull((Object)ioFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(ioFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Intrinsics.checkNotNull((Object)workTree);
                PathKt.deleteWithParentsIfEmpty((Path)ioFile, (Path)workTree, (boolean)isFile);
            }
        }
    }

    public static /* synthetic */ void deletePath$default(Repository repository, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        DirCacheEditorKt.deletePath(repository, string, bl, bl2);
    }

    private static final int EDIT_CMP$lambda$0(PathEdit o1, PathEdit o2) {
        byte[] a = o1.getPath();
        byte[] b = o2.getPath();
        return DirCache.cmp((byte[])a, (int)a.length, (byte[])b, (int)b.length);
    }

    private static final boolean deleteAllFiles$lambda$0(File file) {
        return !Intrinsics.areEqual((Object)file.getName(), (Object)".git");
    }

    public static final /* synthetic */ Comparator access$getEDIT_CMP$p() {
        return EDIT_CMP;
    }

    public static final /* synthetic */ byte[] access$encodePath(String path) {
        return DirCacheEditorKt.encodePath(path);
    }
}

