#!/bin/bash

set -e  # Exit on any error

echo "SWAI Uninstall Script"
echo "===================="

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${YELLOW}This will remove SWAI from your system.${NC}"
echo ""
read -p "Are you sure you want to continue? (y/N): " -n 1 -r
echo ""

if [[ ! $REPLY =~ ^[Yy]$ ]]; then
    echo -e "${YELLOW}Uninstall cancelled.${NC}"
    exit 0
fi

echo -e "${YELLOW}Removing SWAI installation...${NC}"

# Check if running as root for system uninstallation
if [ "$EUID" -ne 0 ]; then
    echo -e "${RED}System uninstallation requires root privileges.${NC}"
    echo -e "${YELLOW}Attempting to run uninstall commands with sudo...${NC}"
    
    # Remove system files with sudo
    echo "Removing /usr/share/swai..."
    sudo rm -rf /usr/share/swai
    
    echo "Removing /usr/bin/swai..."
    sudo rm -f /usr/bin/swai
else
    # Running as root
    echo "Removing /usr/share/swai..."
    rm -rf /usr/share/swai
    
    echo "Removing /usr/bin/swai..."
    rm -f /usr/bin/swai
fi

echo -e "${GREEN}✓ SWAI uninstalled successfully${NC}"

echo ""
echo -e "${YELLOW}Note: User data in ~/.local/share/swai/ has been preserved.${NC}"
echo -e "${YELLOW}You can manually delete it if desired:${NC}"
echo "  rm -rf ~/.local/share/swai/"
echo ""
echo -e "${GREEN}Uninstall completed!${NC}" 