#!/bin/python3
import subprocess
import os
import gi

gi.require_version("Gtk", "4.0")
gi.require_version("Adw", "1")
from gi.repository import Gio, Gtk, Gdk


if __name__ == "__main__":
    
    import stillCenter.StillCenterApp as App
    import stillCenter.AppStore as AppStore
    import stillCenter.constants as constants

    # Load GResource
    resource_path = os.path.join(constants.DATA_DIR, "io.stillhq.stillCenter.gresource")
    if os.path.exists(resource_path):
        resource = Gio.Resource.load(resource_path)
        Gio.Resource._register(resource)

        # Add icons to the icon theme
        icon_theme = Gtk.IconTheme.get_for_display(Gdk.Display.get_default())
        icon_theme.add_resource_path("/io/stillhq/stillCenter/icons/")
        print("Added icons to the icon theme")
        # icon_theme.add_resource_path("/io/stillhq/stillCenter/icons/16x16/symbolic/")

    AppStore.refresh_app_store()

    app = App.StillCenter()
    app.run()
    