#!/bin/bash
# Generate PNG icons from Assets/Icon.svg at various resolutions

set -e

SOURCE_SVG="Assets/Icon.svg"
RESOLUTIONS=(16x16 22x22 24x24 32x32 36x36 48x48 96x96 256x256)
ICON_NAMES=("fedora-logo-icon" "stillos-logo-icon")

# Check if source SVG exists
if [ ! -f "$SOURCE_SVG" ]; then
    echo "Error: $SOURCE_SVG not found" >&2
    exit 1
fi

# Check if inkscape is available
if ! command -v inkscape &> /dev/null; then
    echo "Error: inkscape is required but not installed" >&2
    exit 1
fi

# Generate icons for each resolution
for resolution in "${RESOLUTIONS[@]}"; do
    # Extract width and height from resolution string (e.g., "16x16" -> 16)
    width="${resolution%%x*}"
    height="${resolution##*x}"
    
    # Create directory if it doesn't exist
    icon_dir="icons/hicolor/${resolution}/apps"
    mkdir -p "$icon_dir"
    
    # Generate each icon name
    for icon_name in "${ICON_NAMES[@]}"; do
        output_file="${icon_dir}/${icon_name}.png"
        
        echo "Generating ${output_file} at ${width}x${height}..."
        inkscape --export-type=png \
                 --export-filename="$output_file" \
                 --export-width="$width" \
                 --export-height="$height" \
                 "$SOURCE_SVG"
    done
done

echo "Icon generation complete!"
