/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.url.factory;

import com.intellij.openapi.components.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import uk.co.ben_gibson.git.link.git.File;
import uk.co.ben_gibson.git.link.ui.LineSelection;
import uk.co.ben_gibson.git.link.url.UrlOptions;
import uk.co.ben_gibson.git.link.url.factory.ChromiumUrlFactoryKt;
import uk.co.ben_gibson.git.link.url.factory.UrlFactory;
import uk.co.ben_gibson.url.Path;
import uk.co.ben_gibson.url.URL;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J*\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Luk/co/ben_gibson/git/link/url/factory/ChromiumUrlFactory;", "Luk/co/ben_gibson/git/link/url/factory/UrlFactory;", "()V", "createChromiumFileSubPath", "Luk/co/ben_gibson/url/Path;", "file", "Luk/co/ben_gibson/git/link/git/File;", "ref", "", "lineSelection", "Luk/co/ben_gibson/git/link/ui/LineSelection;", "createChromiumosFileSubPath", "baseUrl", "Luk/co/ben_gibson/url/URL;", "createLineSelection", "selection", "createPathForChromium", "options", "Luk/co/ben_gibson/git/link/url/UrlOptions;", "createPathForChromiumos", "createUrl", "GitLink"})
@SourceDebugExtension(value={"SMAP\nChromiumUrlFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumUrlFactory.kt\nuk/co/ben_gibson/git/link/url/factory/ChromiumUrlFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n766#2:88\n857#2,2:89\n766#2:91\n857#2,2:92\n766#2:94\n857#2,2:95\n*S KotlinDebug\n*F\n+ 1 ChromiumUrlFactory.kt\nuk/co/ben_gibson/git/link/url/factory/ChromiumUrlFactory\n*L\n43#1:88\n43#1:89,2\n70#1:91\n70#1:92,2\n71#1:94\n71#1:95,2\n*E\n"})
public final class ChromiumUrlFactory
implements UrlFactory {
    @Override
    @NotNull
    public URL createUrl(@NotNull URL baseUrl, @NotNull UrlOptions options) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Path path = StringsKt.contains$default((CharSequence)String.valueOf(baseUrl.getPath()), (CharSequence)"chromiumos", (boolean)false, (int)2, null) ? this.createPathForChromiumos(baseUrl, options) : this.createPathForChromium(baseUrl, options);
        return new URL(baseUrl.getScheme(), ChromiumUrlFactoryKt.access$getHOST$p(), null, null, path, null, null, 108, null);
    }

    private final Path createPathForChromium(URL baseUrl, UrlOptions options) {
        Path path;
        Path path2 = Path.Companion.invoke("chromium").with(Path.Companion.invoke(String.valueOf(baseUrl.getPath()))).with(Path.Companion.invoke("+"));
        UrlOptions urlOptions = options;
        if (urlOptions instanceof UrlOptions.UrlOptionsFileAtBranch) {
            path = path2.with(this.createChromiumFileSubPath(((UrlOptions.UrlOptionsFileAtBranch)options).getFile(), ((UrlOptions.UrlOptionsFileAtBranch)options).getBranch(), ((UrlOptions.UrlOptionsFileAtBranch)options).getLineSelection()));
        } else if (urlOptions instanceof UrlOptions.UrlOptionsFileAtCommit) {
            path = path2.with(this.createChromiumFileSubPath(((UrlOptions.UrlOptionsFileAtCommit)options).getFile(), ((UrlOptions.UrlOptionsFileAtCommit)options).getCommit().toString(), ((UrlOptions.UrlOptionsFileAtCommit)options).getLineSelection()));
        } else if (urlOptions instanceof UrlOptions.UrlOptionsCommit) {
            path = path2.with(Path.Companion.invoke(((UrlOptions.UrlOptionsCommit)options).getCommit().toString()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private final Path createPathForChromiumos(URL baseUrl, UrlOptions options) {
        Path path;
        UrlOptions urlOptions = options;
        if (urlOptions instanceof UrlOptions.UrlOptionsFileAtBranch) {
            path = this.createChromiumosFileSubPath(baseUrl, ((UrlOptions.UrlOptionsFileAtBranch)options).getFile(), ((UrlOptions.UrlOptionsFileAtBranch)options).getBranch(), ((UrlOptions.UrlOptionsFileAtBranch)options).getLineSelection());
        } else if (urlOptions instanceof UrlOptions.UrlOptionsFileAtCommit) {
            path = this.createChromiumosFileSubPath(baseUrl, ((UrlOptions.UrlOptionsFileAtCommit)options).getFile(), ((UrlOptions.UrlOptionsFileAtCommit)options).getCommit().toString(), ((UrlOptions.UrlOptionsFileAtCommit)options).getLineSelection());
        } else if (urlOptions instanceof UrlOptions.UrlOptionsCommit) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object = new char[]{'/'};
            object = StringsKt.split$default((CharSequence)String.valueOf(baseUrl.getPath()), (char[])object, (boolean)false, (int)0, (int)6, null);
            Path path2 = Path.Companion.invoke("chromiumos/_/chromium/chromiumos");
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            path = path2.withSegments(CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1)).with(Path.Companion.invoke("+")).with(Path.Companion.invoke(((UrlOptions.UrlOptionsCommit)options).getCommit().toString()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path;
    }

    private final Path createChromiumFileSubPath(File file, String ref, LineSelection lineSelection) {
        Object[] objectArray = new char[]{'/'};
        CharSequence charSequence = ref + ":" + StringsKt.trim((String)file.getPath(), (char[])objectArray);
        objectArray = new String[1];
        objectArray[0] = (char)"/";
        Path path = Path.Companion.fromSegments(StringsKt.split$default((CharSequence)charSequence, (String[])objectArray, (boolean)false, (int)0, (int)6, null));
        if (!file.isRoot()) {
            path = path.withSegment(file.getName());
        }
        if (file.isDirectory()) {
            return path;
        }
        if (lineSelection == null) {
            return path;
        }
        return Path.Companion.invoke(path + this.createLineSelection(lineSelection));
    }

    private final Path createChromiumosFileSubPath(URL baseUrl, File file, String ref, LineSelection lineSelection) {
        String it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Object object = new char[]{'/'};
        object = StringsKt.split$default((CharSequence)String.valueOf(baseUrl.getPath()), (char[])object, (boolean)false, (int)0, (int)6, null);
        Path path = Path.Companion.invoke("chromiumos/chromiumos/codesearch").with("+").with(ref + ":src");
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = new String[]{"/"};
        $this$filter$iv = StringsKt.split$default((CharSequence)file.getPath(), (String[])$this$filter$iv, (boolean)false, (int)0, (int)6, null);
        path = path.withSegments(CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1));
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)it);
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Path path2 = path.withSegments((List)destination$iv$iv);
        if (!file.isRoot()) {
            path2 = path2.withSegment(file.getName());
        }
        if (file.isDirectory()) {
            return path2;
        }
        if (lineSelection == null) {
            return path2;
        }
        return Path.Companion.invoke(path2 + this.createLineSelection(lineSelection));
    }

    private final String createLineSelection(LineSelection selection) {
        return ";l=" + selection.getStart() + "-" + selection.getEnd();
    }
}

