/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.url.factory;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import uk.co.ben_gibson.git.link.platform.Azure;
import uk.co.ben_gibson.git.link.platform.BitbucketServer;
import uk.co.ben_gibson.git.link.platform.Chromium;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.url.factory.AzureUrlFactory;
import uk.co.ben_gibson.git.link.url.factory.BitbucketServerUrlFactory;
import uk.co.ben_gibson.git.link.url.factory.ChromiumUrlFactory;
import uk.co.ben_gibson.git.link.url.factory.TemplatedUrlFactoryProvider;
import uk.co.ben_gibson.git.link.url.factory.UrlFactory;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Luk/co/ben_gibson/git/link/url/factory/UrlFactoryLocator;", "", "()V", "locate", "Luk/co/ben_gibson/git/link/url/factory/UrlFactory;", "platform", "Luk/co/ben_gibson/git/link/platform/Platform;", "GitLink"})
@SourceDebugExtension(value={"SMAP\nUrlFactoryLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFactoryLocator.kt\nuk/co/ben_gibson/git/link/url/factory/UrlFactoryLocator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,17:1\n43#2,3:18\n43#2,3:21\n43#2,3:24\n43#2,3:27\n*S KotlinDebug\n*F\n+ 1 UrlFactoryLocator.kt\nuk/co/ben_gibson/git/link/url/factory/UrlFactoryLocator\n*L\n11#1:18,3\n12#1:21,3\n13#1:24,3\n14#1:27,3\n*E\n"})
public final class UrlFactoryLocator {
    @NotNull
    public final UrlFactory locate(@NotNull Platform platform) {
        UrlFactory urlFactory;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Platform platform2 = platform;
        if (platform2 instanceof Chromium) {
            boolean $i$f$service = false;
            Class<ChromiumUrlFactory> serviceClass$iv = ChromiumUrlFactory.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            urlFactory = (UrlFactory)object;
        } else if (platform2 instanceof Azure) {
            boolean $i$f$service = false;
            Class<AzureUrlFactory> serviceClass$iv = AzureUrlFactory.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            urlFactory = (UrlFactory)object;
        } else if (platform2 instanceof BitbucketServer) {
            boolean $i$f$service = false;
            Class<BitbucketServerUrlFactory> serviceClass$iv = BitbucketServerUrlFactory.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            urlFactory = (UrlFactory)object;
        } else {
            boolean $i$f$service = false;
            Class<TemplatedUrlFactoryProvider> serviceClass$iv = TemplatedUrlFactoryProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            urlFactory = ((TemplatedUrlFactoryProvider)object).forPlatform(platform);
        }
        return urlFactory;
    }
}

