/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.editor;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.handler.IdeActionHandler;
import com.maddyhome.idea.vim.undo.VimKeyBasedUndoService;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import com.maddyhome.idea.vim.undo.VimUndoRedo;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/action/editor/VimEditorUp;", "Lcom/maddyhome/idea/vim/handler/IdeActionHandler;", "<init>", "()V", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "flags", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/command/CommandFlags;", "getFlags", "()Ljava/util/EnumSet;", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimEditorActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimEditorActions.kt\ncom/maddyhome/idea/vim/action/editor/VimEditorUp\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,98:1\n57#2,2:99\n19#2:101\n59#2,2:102\n61#2:108\n37#3:104\n36#3,3:105\n*S KotlinDebug\n*F\n+ 1 VimEditorActions.kt\ncom/maddyhome/idea/vim/action/editor/VimEditorUp\n*L\n64#1:99,2\n64#1:101\n64#1:102,2\n64#1:108\n64#1:104\n64#1:105,3\n*E\n"})
public final class VimEditorUp
extends IdeActionHandler {
    @NotNull
    private final Command.Type type = Command.Type.MOTION;
    @NotNull
    private final EnumSet<CommandFlags> flags;

    public VimEditorUp() {
        super("EditorUp");
        EnumSet<Object> enumSet;
        CommandFlags[] commandFlagsArray = new CommandFlags[]{CommandFlags.FLAG_CLEAR_STROKES};
        Object[] value$iv = (Enum[])commandFlagsArray;
        boolean $i$f$enumSetOf = false;
        switch (value$iv.length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<CommandFlags> enumSet2 = EnumSet.noneOf(CommandFlags.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<Enum> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Enum[] enumArray = (Enum[])thisCollection$iv$iv.toArray(new CommandFlags[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray, enumArray.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        this.flags = enumSet;
    }

    @NotNull
    public Command.Type getType() {
        return this.type;
    }

    @NotNull
    public EnumSet<CommandFlags> getFlags() {
        return this.flags;
    }

    @Override
    public boolean execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        VimUndoRedo undo;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        VimUndoRedo vimUndoRedo = undo = VimInjectorKt.getInjector().getUndo();
        if (vimUndoRedo instanceof VimKeyBasedUndoService) {
            ((VimKeyBasedUndoService)undo).setMergeUndoKey();
        } else if (vimUndoRedo instanceof VimTimestampBasedUndoService) {
            long nanoTime = System.nanoTime();
            editor.forEachCaret(arg_0 -> VimEditorUp.execute$lambda$0(undo, nanoTime, arg_0));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return super.execute(editor, context, cmd, operatorArguments);
    }

    private static final Unit execute$lambda$0(VimUndoRedo $undo, long $nanoTime, VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((VimTimestampBasedUndoService)$undo).endInsertSequence(it, it.getOffset(), $nanoTime);
        return Unit.INSTANCE;
    }
}

