/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.internal;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.Arrays;
import java.util.Random;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "MyBlockRenderer", "Companion", "IdeaVIM"})
public final class AddBlockInlaysAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Random random = new Random();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Editor editor = this.getEditor(dataContext2);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        InlayModel inlayModel = editor2.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
        InlayModel inlayModel2 = inlayModel;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineCount = document2.getLineCount();
        for (int i = random.nextInt(10); i < lineCount; i += 10 + (random.nextInt(6) - 3)) {
            int offset = document2.getLineStartOffset(i);
            boolean above = random.nextInt(10) > 3;
            int count = random.nextInt(10) > 7 ? random.nextInt(5) : 1;
            for (int j = 0; j < count; ++j) {
                String text;
                float factor = RangesKt.coerceAtLeast((float)(1.75f * random.nextFloat()), (float)0.9f);
                String string = "---------- %s line %d ----------";
                Object[] objectArray = new Object[]{above ? "above" : "below", i + 1};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                inlayModel2.addBlockElement(offset, true, above, 0, (EditorCustomElementRenderer)new MyBlockRenderer(factor, text));
            }
        }
    }

    private final Editor getEditor(DataContext dataContext) {
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$Companion;", "", "<init>", "()V", "random", "Ljava/util/Random;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0014\u0010\f\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J,\u0010\r\u001a\u00020\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00060\u0016R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "factor", "", "text", "", "<init>", "(FLjava/lang/String;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getFontMetrics", "Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer$MyFontMetrics;", "editor", "Lcom/intellij/openapi/editor/Editor;", "doCalcWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "MyFontMetrics", "Companion", "IdeaVIM"})
    private static final class MyBlockRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float factor;
        @NotNull
        private final String text;
        @NotNull
        private static final Key<MyFontMetrics> HINT_FONT_METRICS;

        public MyBlockRenderer(float factor, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.factor = factor;
            this.text = text;
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            FontMetrics fontMetrics = this.getFontMetrics(editor2).getMetrics();
            return this.doCalcWidth(this.text, fontMetrics);
        }

        public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            FontMetrics fontMetrics = this.getFontMetrics(editor2).getMetrics();
            return fontMetrics.getHeight();
        }

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            FontMetrics fontMetrics = this.getFontMetrics(editor2).getMetrics();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(this.text, g);
            g.setColor((Color)JBColor.GRAY);
            g.setFont(fontMetrics.getFont());
            g.drawString(this.text, 0, targetRegion.y + (int)(lineMetrics.getHeight() - lineMetrics.getDescent()));
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.drawRect(targetRegion.x, targetRegion.y, targetRegion.width, targetRegion.height);
        }

        private final MyFontMetrics getFontMetrics(Editor editor) {
            String familyName = UIManager.getFont("Label.font").getFamily();
            int size = (int)((float)Math.max(1, editor.getColorsScheme().getEditorFontSize() - 1) * this.factor);
            MyFontMetrics metrics = (MyFontMetrics)editor.getUserData(HINT_FONT_METRICS);
            if (metrics != null) {
                Intrinsics.checkNotNull((Object)familyName);
                if (!metrics.isActual(editor, familyName, size)) {
                    metrics = null;
                }
            }
            if (metrics == null) {
                metrics = new MyFontMetrics(editor, familyName, size);
                editor.putUserData(HINT_FONT_METRICS, (Object)metrics);
            }
            return metrics;
        }

        private final int doCalcWidth(String text, FontMetrics fontMetrics) {
            String string = text;
            return string == null ? 0 : fontMetrics.stringWidth(string);
        }

        static {
            Key key = Key.create((String)"DummyInlayFontMetrics");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            HINT_FONT_METRICS = key;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R)\u0010\u0004\u001a\u001d\u0012\u0014\u0012\u0012 \b*\b\u0018\u00010\u0006R\u00020\u00070\u0006R\u00020\u00070\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer$Companion;", "", "<init>", "()V", "HINT_FONT_METRICS", "Lcom/intellij/openapi/util/Key;", "Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer$MyFontMetrics;", "Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "IdeaVIM"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer$MyFontMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "familyName", "", "size", "", "<init>", "(Lcom/maddyhome/idea/vim/action/internal/AddBlockInlaysAction$MyBlockRenderer;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;I)V", "metrics", "Ljava/awt/FontMetrics;", "getMetrics", "()Ljava/awt/FontMetrics;", "isActual", "", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "IdeaVIM"})
        private final class MyFontMetrics {
            @NotNull
            private final FontMetrics metrics;

            public MyFontMetrics(@Nullable Editor editor, String familyName, int size) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                FontUIResource fontUIResource = UIUtil.getFontWithFallback((String)familyName, (int)0, (int)size);
                Intrinsics.checkNotNullExpressionValue((Object)fontUIResource, (String)"getFontWithFallback(...)");
                Font font = fontUIResource;
                FontRenderContext context = this.getCurrentContext(editor);
                FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                this.metrics = fontMetrics;
            }

            @NotNull
            public final FontMetrics getMetrics() {
                return this.metrics;
            }

            public final boolean isActual(@NotNull Editor editor, @NotNull String familyName, int size) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
                Font font = this.metrics.getFont();
                if (!Intrinsics.areEqual((Object)familyName, (Object)font.getFamily()) || size != font.getSize()) {
                    return false;
                }
                FontRenderContext currentContext = this.getCurrentContext(editor);
                return currentContext.equals(this.metrics.getFontRenderContext());
            }

            private final FontRenderContext getCurrentContext(Editor editor) {
                FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editor.getContentComponent());
                return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editor instanceof EditorImpl ? UISettings.Companion.getEditorFractionalMetricsHint() : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        }
    }
}

