/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.api.VimOutputPanelBase;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.ui.ExOutputPanel;
import java.lang.ref.WeakReference;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u000fJ\b\u0010#\u001a\u00020\u000fH\u0014J\u0012\u0010$\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\b\u0010$\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0014\u0010!\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\r\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/ex/ExOutputModel;", "Lcom/maddyhome/idea/vim/api/VimOutputPanelBase;", "myEditor", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/lang/ref/WeakReference;)V", "isActiveInTestMode", "", "editor", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "isActive", "()Z", "addText", "", "text", "", "isNewLine", "show", "scrollPage", "scrollHalfPage", "scrollLine", "value", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "label", "getLabel", "setLabel", "output", "clear", "atEnd", "getAtEnd", "onBadKey", "close", "key", "Ljavax/swing/KeyStroke;", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nExOutputModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExOutputModel.kt\ncom/maddyhome/idea/vim/ex/ExOutputModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class ExOutputModel
extends VimOutputPanelBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<Editor> myEditor;
    private boolean isActiveInTestMode;
    @NotNull
    private String text;

    public ExOutputModel(@NotNull WeakReference<Editor> myEditor) {
        Intrinsics.checkNotNullParameter(myEditor, (String)"myEditor");
        this.myEditor = myEditor;
        this.text = "";
    }

    @Nullable
    public final Editor getEditor() {
        return (Editor)this.myEditor.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isActive() {
        boolean bl;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Editor editor = this.getEditor();
            Object object = editor;
            if (editor == null) return false;
            Editor it = object;
            boolean bl2 = false;
            ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(it);
            object = exOutputPanel;
            if (exOutputPanel == null) return false;
            bl = object.myActive;
            return bl;
        } else {
            bl = this.isActiveInTestMode;
        }
        return bl;
    }

    public void addText(@NotNull String text, boolean isNewLine) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)this.getText()).length() > 0 && isNewLine) {
            this.setText(this.getText() + "\n" + text);
        } else {
            this.setText(this.getText() + text);
        }
    }

    public void show() {
        if (this.getEditor() == null) {
            return;
        }
        VimOutputPanel currentPanel = VimInjectorKt.getInjector().getOutputPanel().getCurrentOutputPanel();
        if (currentPanel != null && !Intrinsics.areEqual((Object)currentPanel, (Object)((Object)this))) {
            currentPanel.close();
        }
        Editor editor = this.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        UserDataManager.setVimExOutput(editor, this);
        Editor editor2 = this.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        ExOutputPanel exOutputPanel = ExOutputPanel.getInstance(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)exOutputPanel), (String)"getInstance(...)");
        ExOutputPanel exOutputPanel2 = exOutputPanel;
        if (!exOutputPanel2.myActive) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.isActiveInTestMode = true;
            } else {
                exOutputPanel2.activate();
            }
        }
    }

    public void scrollPage() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return;
        }
        ExOutputPanel panel2 = exOutputPanel;
        panel2.scrollPage();
    }

    public void scrollHalfPage() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return;
        }
        ExOutputPanel panel2 = exOutputPanel;
        panel2.scrollHalfPage();
    }

    public void scrollLine() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return;
        }
        ExOutputPanel panel2 = exOutputPanel;
        panel2.scrollLine();
    }

    @NotNull
    public String getText() {
        String string;
        block4: {
            block2: {
                block3: {
                    if (ApplicationManager.getApplication().isUnitTestMode()) break block2;
                    string = this.getEditor();
                    if (string == null) break block3;
                    String it = string;
                    boolean bl = false;
                    String string2 = ExOutputPanel.getInstance((Editor)it).getText();
                    string = string2;
                    if (string2 != null) break block4;
                }
                string = "";
                break block4;
            }
            string = this.text;
        }
        return string;
    }

    public void setText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String newValue = StringsKt.removeSuffix((String)value, (CharSequence)"\n");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Editor editor = this.getEditor();
            if (editor != null) {
                Editor it = editor;
                boolean bl = false;
                ExOutputPanel.getInstance(it).setText(newValue);
            }
        } else {
            this.text = newValue;
            this.isActiveInTestMode = ((CharSequence)newValue).length() > 0;
        }
    }

    @NotNull
    public String getLabel() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return "";
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return "";
        }
        ExOutputPanel panel2 = exOutputPanel;
        String string = panel2.myLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public void setLabel(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return;
        }
        ExOutputPanel panel2 = exOutputPanel;
        panel2.myLabel.setText(value);
    }

    public final void output(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setText(text);
    }

    public final void clear() {
        this.setText("");
    }

    protected boolean getAtEnd() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return false;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return false;
        }
        ExOutputPanel panel2 = exOutputPanel;
        return panel2.isAtEnd();
    }

    protected void onBadKey() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return;
        }
        ExOutputPanel panel2 = exOutputPanel;
        panel2.onBadKey();
    }

    protected void close(@Nullable KeyStroke key) {
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor notNullEditor = editor;
        ExOutputPanel exOutputPanel = ExOutputPanel.getNullablePanel(notNullEditor);
        if (exOutputPanel == null) {
            return;
        }
        ExOutputPanel panel2 = exOutputPanel;
        panel2.close(key);
    }

    public void close() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Editor editor = this.getEditor();
            if (editor != null) {
                Editor it = editor;
                boolean bl = false;
                ExOutputPanel.getInstance(it).close();
            }
        } else {
            this.isActiveInTestMode = false;
        }
    }

    @JvmStatic
    @NotNull
    public static final ExOutputModel getInstance(@NotNull Editor editor) {
        return Companion.getInstance(editor);
    }

    @JvmStatic
    @Nullable
    public static final ExOutputModel tryGetInstance(@NotNull Editor editor) {
        return Companion.tryGetInstance(editor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/ex/ExOutputModel$Companion;", "", "<init>", "()V", "getInstance", "Lcom/maddyhome/idea/vim/ex/ExOutputModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tryGetInstance", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExOutputModel getInstance(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ExOutputModel model = UserDataManager.getVimExOutput(editor);
            if (model == null) {
                model = new ExOutputModel(new WeakReference<Editor>(editor));
                UserDataManager.setVimExOutput(editor, model);
            }
            return model;
        }

        @JvmStatic
        @Nullable
        public final ExOutputModel tryGetInstance(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return UserDataManager.getVimExOutput(editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

