/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.commentary;

import com.intellij.codeInsight.actions.AsyncActionExecutionService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.common.CommandAliasHandler;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.LineRangeKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.VimExtensionFacadeKt;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.helper.PsiHelper;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.key.OperatorFunction;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0007\b\t\n\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "Util", "Companion", "CommentaryOperatorFunction", "CommentaryOperatorHandler", "CommentaryMappingHandler", "CommentaryTextObjectMotionHandler", "CommentaryCommandAliasHandler", "IdeaVIM"})
public final class CommentaryExtension
implements VimExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OPERATOR_FUNC = "CommentaryOperatorFunc";

    @Override
    @NotNull
    public String getName() {
        return "commentary";
    }

    @Override
    public void init() {
        List plugCommentaryKeys = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>Commentary");
        List plugCommentaryLineKeys = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>CommentaryLine");
        Set set = MappingMode.Companion.getNX();
        MappingOwner mappingOwner = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set, (List<? extends KeyStroke>)plugCommentaryKeys, mappingOwner, new CommentaryOperatorHandler(), false);
        Set set2 = MappingMode.O;
        MappingOwner mappingOwner2 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner2, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set2, (List<? extends KeyStroke>)plugCommentaryKeys, mappingOwner2, new CommentaryMappingHandler(), false);
        Set set3 = MappingMode.N;
        MappingOwner mappingOwner3 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner3, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set3, plugCommentaryLineKeys, mappingOwner3, VimInjectorKt.getInjector().getParser().parseKeys("gc_"), true);
        Set set4 = MappingMode.NXO;
        List list = VimInjectorKt.getInjector().getParser().parseKeys("gc");
        MappingOwner mappingOwner4 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner4, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set4, list, mappingOwner4, plugCommentaryKeys, true);
        Set set5 = MappingMode.N;
        List list2 = VimInjectorKt.getInjector().getParser().parseKeys("gcc");
        MappingOwner mappingOwner5 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner5, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set5, list2, mappingOwner5, plugCommentaryLineKeys, true);
        Set set6 = MappingMode.N;
        List list3 = VimInjectorKt.getInjector().getParser().parseKeys("gcu");
        MappingOwner mappingOwner6 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner6, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set6, list3, mappingOwner6, VimInjectorKt.getInjector().getParser().parseKeys("<Plug>Commentary<Plug>Commentary"), true);
        Set set7 = MappingMode.N;
        List list4 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(CommentMotion)");
        MappingOwner mappingOwner7 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner7, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMapping(set7, list4, mappingOwner7, plugCommentaryKeys, true);
        Set set8 = MappingMode.XO;
        List list5 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(CommentMotionV)");
        MappingOwner mappingOwner8 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner8, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMapping(set8, list5, mappingOwner8, plugCommentaryKeys, true);
        Set set9 = MappingMode.N;
        List list6 = VimInjectorKt.getInjector().getParser().parseKeys("<Plug>(CommentLine)");
        MappingOwner mappingOwner9 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner9, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMapping(set9, list6, mappingOwner9, plugCommentaryLineKeys, true);
        VimExtensionFacade.INSTANCE.addCommand("Commentary", new CommentaryCommandAliasHandler());
        VimExtensionFacadeKt.exportOperatorFunction(VimExtensionFacade.INSTANCE, OPERATOR_FUNC, new CommentaryOperatorFunction());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$CommentaryCommandAliasHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "<init>", "()V", "execute", "", "command", "", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    private static final class CommentaryCommandAliasHandler
    implements CommandAliasHandler {
        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Util.INSTANCE.doCommentary(editor, context, LineRangeKt.toTextRange((LineRange)range.getLineRange(editor, editor.primaryCaret()), (VimEditor)editor), SelectionType.LINE_WISE, false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$CommentaryMappingHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "isRepeatable", "", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class CommentaryMappingHandler
    implements ExtensionHandler {
        private final boolean isRepeatable;

        public CommentaryMappingHandler() {
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            KeyHandlerState keyState = KeyHandler.Companion.getInstance().getKeyHandlerState();
            keyState.getCommandBuilder().addAction((EditorActionHandlerBase)CommentaryTextObjectMotionHandler.INSTANCE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$CommentaryOperatorFunction;", "Lcom/maddyhome/idea/vim/key/OperatorFunction;", "<init>", "()V", "apply", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "selectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "IdeaVIM"})
    private static final class CommentaryOperatorFunction
    implements OperatorFunction {
        public boolean apply(@NotNull VimEditor editor, @NotNull ExecutionContext context, @Nullable SelectionType selectionType) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TextRange textRange = VimInjectorKt.getInjector().getMarkService().getChangeMarks((ImmutableVimCaret)editor.primaryCaret());
            if (textRange == null) {
                return false;
            }
            TextRange range = textRange;
            SelectionType selectionType2 = selectionType;
            if (selectionType2 == null) {
                selectionType2 = SelectionType.CHARACTER_WISE;
            }
            return Util.INSTANCE.doCommentary(editor, context, range, selectionType2, true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$CommentaryOperatorHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "isRepeatable", "", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class CommentaryOperatorHandler
    implements ExtensionHandler {
        private final boolean isRepeatable;

        public CommentaryOperatorHandler() {
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).setOperatorfunc(CommentaryExtension.OPERATOR_FUNC);
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("g@"), IjVimEditorKt.getIj(editor));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$CommentaryTextObjectMotionHandler;", "Lcom/maddyhome/idea/vim/handler/TextObjectActionHandler;", "<init>", "()V", "visualType", "Lcom/maddyhome/idea/vim/command/TextObjectVisualType;", "getVisualType", "()Lcom/maddyhome/idea/vim/command/TextObjectVisualType;", "getRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "count", "", "rawCount", "isCommentLine", "", "file", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/editor/Editor;", "logicalLine", "isComment", "element", "Lcom/intellij/psi/PsiElement;", "IdeaVIM"})
    private static final class CommentaryTextObjectMotionHandler
    extends TextObjectActionHandler {
        @NotNull
        public static final CommentaryTextObjectMotionHandler INSTANCE = new CommentaryTextObjectMotionHandler();
        @NotNull
        private static final TextObjectVisualType visualType = TextObjectVisualType.LINE_WISE;

        private CommentaryTextObjectMotionHandler() {
        }

        @NotNull
        public TextObjectVisualType getVisualType() {
            return visualType;
        }

        @Nullable
        public TextRange getRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, int count, int rawCount) {
            int endLine;
            int startLine;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Editor nativeEditor = ((IjVimEditor)editor).getEditor();
            PsiFile psiFile = PsiHelper.getFile(nativeEditor);
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            int lastLine = editor.lineCount();
            for (startLine = caret.getBufferPosition().getLine(); startLine > 0 && this.isCommentLine(file, nativeEditor, startLine - 1); --startLine) {
            }
            for (endLine = caret.getBufferPosition().getLine() - 1; endLine < lastLine && this.isCommentLine(file, nativeEditor, endLine + 1); ++endLine) {
            }
            if (startLine <= endLine) {
                int startOffset = ((IjVimEditor)editor).getLineStartOffset(startLine);
                int endOffset = ((IjVimEditor)editor).getLineStartOffset(endLine + 1);
                return new TextRange(startOffset, endOffset);
            }
            return null;
        }

        private final boolean isCommentLine(PsiFile file, Editor editor, int logicalLine) {
            PsiElement startElement;
            int startOffset = IjVimEditorKt.getVim(editor).getLineStartOffset(logicalLine);
            int endOffset = EngineEditorHelperKt.getLineEndOffset((VimEditor)IjVimEditorKt.getVim(editor), (int)logicalLine, (boolean)true);
            PsiElement psiElement = file.findElementAt(startOffset);
            if (psiElement == null) {
                return false;
            }
            PsiElement next = startElement = psiElement;
            boolean hasComment = false;
            while (next != null && next.getTextRange().getStartOffset() <= endOffset) {
                if (!(next instanceof PsiWhiteSpace)) {
                    if (this.isComment(next)) {
                        hasComment = true;
                    } else {
                        return false;
                    }
                }
                next = PsiTreeUtil.nextLeaf((PsiElement)next, (boolean)true);
            }
            return hasComment;
        }

        private final boolean isComment(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$Companion;", "", "<init>", "()V", "OPERATOR_FUNC", "", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0005J6\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J(\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$Util;", "", "<init>", "()V", "doCommentary", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "selectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "resetCaret", "executeActionWithCallbackOnSuccess", "action", "", "project", "Lcom/intellij/openapi/project/Project;", "callback", "Lkotlin/Function0;", "", "afterCommenting", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nCommentaryExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentaryExtension.kt\ncom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$Util\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1761#2,3:258\n*S KotlinDebug\n*F\n+ 1 CommentaryExtension.kt\ncom/maddyhome/idea/vim/extension/commentary/CommentaryExtension$Util\n*L\n76#1:258,3\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final boolean doCommentary(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull TextRange range, @NotNull SelectionType selectionType, boolean resetCaret) {
            boolean bl;
            block6: {
                List list;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter((Object)selectionType, (String)"selectionType");
                Mode mode2 = editor.getMode();
                if (!(mode2 instanceof Mode.VISUAL)) {
                    IjVimEditorKt.getIj(editor).getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                }
                if (selectionType == SelectionType.LINE_WISE) {
                    var8_7 = new String[]{"CommentByLineComment", "CommentByBlockComment"};
                    list = CollectionsKt.listOf((Object[])var8_7);
                } else {
                    var8_7 = new String[]{"CommentByBlockComment", "CommentByLineComment"};
                    list = CollectionsKt.listOf((Object[])var8_7);
                }
                List actions = list;
                Project project = IjVimEditorKt.getIj(editor).getProject();
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                Function0 callback = () -> Util.doCommentary$lambda$0(mode2, editor, resetCaret, range);
                Iterable $this$any$iv = actions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.executeActionWithCallbackOnSuccess(editor, it, project2, context, (Function0<Unit>)callback)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public static /* synthetic */ boolean doCommentary$default(Util util, VimEditor vimEditor, ExecutionContext executionContext, TextRange textRange, SelectionType selectionType, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return util.doCommentary(vimEditor, executionContext, textRange, selectionType, bl);
        }

        private final boolean executeActionWithCallbackOnSuccess(VimEditor editor, String action, Project project, ExecutionContext context, Function0<Unit> callback) {
            Ref res = Ref.create((Object)false);
            AsyncActionExecutionService.Companion.getInstance(project).withExecutionAfterAction(action, () -> Util.executeActionWithCallbackOnSuccess$lambda$2(res, editor, action, context), () -> Util.executeActionWithCallbackOnSuccess$lambda$3(res, callback));
            Object object = res.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (Boolean)object;
        }

        private final void afterCommenting(Mode mode2, VimEditor editor, boolean resetCaret, TextRange range) {
            if (!(mode2 instanceof Mode.VISUAL)) {
                editor.removeSelection();
            }
            if (resetCaret) {
                editor.primaryCaret().moveToOffset(range.getStartOffset());
            }
        }

        private static final Unit doCommentary$lambda$0(Mode $mode, VimEditor $editor, boolean $resetCaret, TextRange $range) {
            INSTANCE.afterCommenting($mode, $editor, $resetCaret, $range);
            return Unit.INSTANCE;
        }

        private static final Unit executeActionWithCallbackOnSuccess$lambda$2(Ref $res, VimEditor $editor, String $action, ExecutionContext $context) {
            $res.set((Object)VimInjectorKt.getInjector().getActionExecutor().executeAction($editor, $action, $context));
            return Unit.INSTANCE;
        }

        private static final Unit executeActionWithCallbackOnSuccess$lambda$3(Ref $res, Function0 $callback) {
            if (((Boolean)$res.get()).booleanValue()) {
                $callback.invoke();
            }
            return Unit.INSTANCE;
        }
    }
}

