/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.exchange;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMarkService;
import com.maddyhome.idea.vim.api.VimMarkServiceKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.VimExtensionFacadeKt;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.key.OperatorFunction;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0007\b\t\n\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "Util", "Companion", "ExchangeHandler", "ExchangeClearHandler", "VExchangeHandler", "Operator", "Exchange", "IdeaVIM"})
public final class VimExchangeExtension
implements VimExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private static final String EXCHANGE_CMD = "<Plug>(Exchange)";
    @NonNls
    @NotNull
    private static final String EXCHANGE_CLEAR_CMD = "<Plug>(ExchangeClear)";
    @NonNls
    @NotNull
    private static final String EXCHANGE_LINE_CMD = "<Plug>(ExchangeLine)";
    @NonNls
    @NotNull
    private static final String OPERATOR_FUNC = "ExchangeOperatorFunc";

    @Override
    @NotNull
    public String getName() {
        return "exchange";
    }

    @Override
    public void init() {
        Set set = MappingMode.N;
        List list = VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_CMD);
        MappingOwner mappingOwner = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set, (List<? extends KeyStroke>)list, mappingOwner, new ExchangeHandler(false), false);
        Set set2 = MappingMode.X;
        List list2 = VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_CMD);
        MappingOwner mappingOwner2 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner2, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set2, (List<? extends KeyStroke>)list2, mappingOwner2, new VExchangeHandler(), false);
        Set set3 = MappingMode.N;
        List list3 = VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_CLEAR_CMD);
        MappingOwner mappingOwner3 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner3, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set3, (List<? extends KeyStroke>)list3, mappingOwner3, new ExchangeClearHandler(), false);
        Set set4 = MappingMode.N;
        List list4 = VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_LINE_CMD);
        MappingOwner mappingOwner4 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner4, (String)"getOwner(...)");
        VimExtensionFacade.putExtensionHandlerMapping((Set<? extends MappingMode>)set4, (List<? extends KeyStroke>)list4, mappingOwner4, new ExchangeHandler(true), false);
        Set set5 = MappingMode.N;
        List list5 = VimInjectorKt.getInjector().getParser().parseKeys("cx");
        MappingOwner mappingOwner5 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner5, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set5, list5, mappingOwner5, VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_CMD), true);
        Set set6 = MappingMode.X;
        List list6 = VimInjectorKt.getInjector().getParser().parseKeys("X");
        MappingOwner mappingOwner6 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner6, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set6, list6, mappingOwner6, VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_CMD), true);
        Set set7 = MappingMode.N;
        List list7 = VimInjectorKt.getInjector().getParser().parseKeys("cxc");
        MappingOwner mappingOwner7 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner7, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set7, list7, mappingOwner7, VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_CLEAR_CMD), true);
        Set set8 = MappingMode.N;
        List list8 = VimInjectorKt.getInjector().getParser().parseKeys("cxx");
        MappingOwner mappingOwner8 = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)mappingOwner8, (String)"getOwner(...)");
        VimExtensionFacade.putKeyMappingIfMissing(set8, list8, mappingOwner8, VimInjectorKt.getInjector().getParser().parseKeys(EXCHANGE_LINE_CMD), true);
        VimExtensionFacadeKt.exportOperatorFunction(VimExtensionFacade.INSTANCE, OPERATOR_FUNC, new Operator(false, 1, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Companion;", "", "<init>", "()V", "EXCHANGE_CMD", "", "EXCHANGE_CLEAR_CMD", "EXCHANGE_LINE_CMD", "OPERATOR_FUNC", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Exchange;", "", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "start", "Lcom/maddyhome/idea/vim/mark/Mark;", "end", "text", "", "<init>", "(Lcom/maddyhome/idea/vim/state/mode/SelectionType;Lcom/maddyhome/idea/vim/mark/Mark;Lcom/maddyhome/idea/vim/mark/Mark;Ljava/lang/String;)V", "getType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getStart", "()Lcom/maddyhome/idea/vim/mark/Mark;", "getEnd", "getText", "()Ljava/lang/String;", "myHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setHighlighter", "", "highlighter", "getHighlighter", "IdeaVIM"})
    public static final class Exchange {
        @NotNull
        private final SelectionType type;
        @NotNull
        private final Mark start;
        @NotNull
        private final Mark end;
        @NotNull
        private final String text;
        @Nullable
        private RangeHighlighter myHighlighter;

        public Exchange(@NotNull SelectionType type, @NotNull Mark start2, @NotNull Mark end, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.type = type;
            this.start = start2;
            this.end = end;
            this.text = text;
        }

        @NotNull
        public final SelectionType getType() {
            return this.type;
        }

        @NotNull
        public final Mark getStart() {
            return this.start;
        }

        @NotNull
        public final Mark getEnd() {
            return this.end;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setHighlighter(@NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.myHighlighter = highlighter;
        }

        @Nullable
        public final RangeHighlighter getHighlighter() {
            return this.myHighlighter;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$ExchangeClearHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class ExchangeClearHandler
    implements ExtensionHandler {
        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            Util.INSTANCE.clearExchange(IjVimEditorKt.getIj(editor));
        }

        public boolean isRepeatable() {
            return super.isRepeatable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$ExchangeHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "isLine", "", "<init>", "(Z)V", "isRepeatable", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class ExchangeHandler
    implements ExtensionHandler {
        private final boolean isLine;
        private final boolean isRepeatable;

        public ExchangeHandler(boolean isLine) {
            this.isLine = isLine;
            this.isRepeatable = true;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).setOperatorfunc(VimExchangeExtension.OPERATOR_FUNC);
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys(this.isLine ? "g@_" : "g@"), IjVimEditorKt.getIj(editor));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\n\u0010\u000b\u001a\u00020\f*\u00020\rJ\"\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J \u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Operator;", "Lcom/maddyhome/idea/vim/key/OperatorFunction;", "isVisual", "", "<init>", "(Z)V", "getMarkOffset", "", "Lcom/intellij/openapi/editor/Editor;", "mark", "Lcom/maddyhome/idea/vim/mark/Mark;", "getString", "", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "apply", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "selectionType", "exchange", "", "ex1", "Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Exchange;", "ex2", "reverse", "expand", "compareExchanges", "Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Operator$ExchangeCompareResult;", "x", "y", "getExchange", "ExchangeCompareResult", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimExchangeExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimExchangeExtension.kt\ncom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Operator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n1563#2:355\n1634#2,3:356\n*S KotlinDebug\n*F\n+ 1 VimExchangeExtension.kt\ncom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Operator\n*L\n298#1:355\n298#1:356,3\n*E\n"})
    private static final class Operator
    implements OperatorFunction {
        private final boolean isVisual;

        public Operator(boolean isVisual) {
            this.isVisual = isVisual;
        }

        public /* synthetic */ Operator(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final int getMarkOffset(@NotNull Editor $this$getMarkOffset, @NotNull Mark mark) {
            Intrinsics.checkNotNullParameter((Object)$this$getMarkOffset, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
            return EngineEditorHelperKt.getOffset((VimEditor)((VimEditor)new IjVimEditor($this$getMarkOffset)), (int)mark.getLine(), (int)mark.getCol());
        }

        @NotNull
        public final String getString(@NotNull SelectionType $this$getString) {
            Intrinsics.checkNotNullParameter((Object)$this$getString, (String)"<this>");
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$getString.ordinal()]) {
                case 1 -> "v";
                case 2 -> "V";
                case 3 -> "\\<C-V>";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public boolean apply(@NotNull VimEditor editor, @NotNull ExecutionContext context, @Nullable SelectionType selectionType) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Editor ijEditor = IjVimEditorKt.getIj(editor);
            SelectionType selectionType2 = selectionType;
            if (selectionType2 == null) {
                selectionType2 = SelectionType.CHARACTER_WISE;
            }
            Exchange currentExchange = this.getExchange(ijEditor, this.isVisual, selectionType2);
            Exchange exchange1 = (Exchange)ijEditor.getUserData(Util.INSTANCE.getEXCHANGE_KEY());
            if (exchange1 == null) {
                RangeHighlighter highlighter = Operator.apply$highlightExchange(ijEditor, this, currentExchange);
                currentExchange.setHighlighter(highlighter);
                ijEditor.putUserData(Util.INSTANCE.getEXCHANGE_KEY(), (Object)currentExchange);
                return true;
            }
            ExchangeCompareResult cmp = this.compareExchanges(exchange1, currentExchange);
            boolean reverse = false;
            boolean expand = false;
            switch (WhenMappings.$EnumSwitchMapping$1[cmp.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    reverse = true;
                    expand = true;
                    pair = new Pair((Object)currentExchange, (Object)exchange1);
                    break;
                }
                case 3: {
                    expand = true;
                    pair = new Pair((Object)exchange1, (Object)currentExchange);
                    break;
                }
                case 4: {
                    reverse = true;
                    pair = new Pair((Object)currentExchange, (Object)exchange1);
                    break;
                }
                case 5: {
                    pair = new Pair((Object)exchange1, (Object)currentExchange);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            Exchange ex1 = (Exchange)pair2.component1();
            Exchange ex2 = (Exchange)pair2.component2();
            this.exchange(ijEditor, ex1, ex2, reverse, expand);
            Util.INSTANCE.clearExchange(ijEditor);
            return true;
        }

        private final void exchange(Editor editor, Exchange ex1, Exchange ex2, boolean reverse, boolean expand) {
            List<KeyStroke> zRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), 'z');
            List<KeyStroke> unnRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), '\"');
            List<KeyStroke> startRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), '*');
            List<KeyStroke> plusRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), '+');
            Operator.exchange$pasteExchange(editor, this, ex1, ex2);
            if (!expand) {
                Operator.exchange$pasteExchange(editor, this, ex2, ex1);
            }
            if (!expand) {
                Operator.exchange$fixCursor(editor, this, ex1, ex2, reverse);
            }
            VimExtensionFacade.setRegister('z', zRegText);
            VimExtensionFacade.setRegister('\"', unnRegText);
            VimExtensionFacade.setRegister('*', startRegText);
            VimExtensionFacade.setRegister('+', plusRegText);
        }

        private final ExchangeCompareResult compareExchanges(Exchange x, Exchange y) {
            ExchangeCompareResult exchangeCompareResult;
            if (x.getType() == SelectionType.BLOCK_WISE && y.getType() == SelectionType.BLOCK_WISE) {
                exchangeCompareResult = Operator.compareExchanges$intersects(x, y) ? ExchangeCompareResult.OVERLAP : (x.getStart().getCol() <= y.getStart().getCol() ? ExchangeCompareResult.LT : ExchangeCompareResult.GT);
            } else if (Operator.compareExchanges$comparePos(x.getStart(), y.getStart()) <= 0 && Operator.compareExchanges$comparePos(x.getEnd(), y.getEnd()) >= 0) {
                exchangeCompareResult = ExchangeCompareResult.OUTER;
            } else if (Operator.compareExchanges$comparePos(y.getStart(), x.getStart()) <= 0 && Operator.compareExchanges$comparePos(y.getEnd(), x.getEnd()) >= 0) {
                exchangeCompareResult = ExchangeCompareResult.INNER;
            } else if (Operator.compareExchanges$comparePos(x.getStart(), y.getEnd()) <= 0 && Operator.compareExchanges$comparePos(y.getStart(), x.getEnd()) <= 0 || Operator.compareExchanges$comparePos(y.getStart(), x.getEnd()) <= 0 && Operator.compareExchanges$comparePos(x.getStart(), y.getEnd()) <= 0) {
                exchangeCompareResult = ExchangeCompareResult.OVERLAP;
            } else {
                int cmp = Operator.compareExchanges$comparePos(x.getStart(), y.getStart());
                exchangeCompareResult = cmp == 0 ? ExchangeCompareResult.OVERLAP : (cmp < 0 ? ExchangeCompareResult.LT : ExchangeCompareResult.GT);
            }
            return exchangeCompareResult;
        }

        private final Exchange getExchange(Editor editor, boolean isVisual, SelectionType selectionType) {
            List<KeyStroke> unnRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), '\"');
            List<KeyStroke> starRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), '*');
            List<KeyStroke> plusRegText = VimExtensionFacade.getRegister(IjVimEditorKt.getVim(editor), '+');
            Pair<Mark, Mark> pair = Operator.getExchange$getMarks(editor, isVisual);
            Mark selectionStart = (Mark)pair.component1();
            Mark selectionEnd = (Mark)pair.component2();
            if (isVisual) {
                VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("gvy"), editor);
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[selectionType.ordinal()]) {
                    case 2: {
                        VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().stringToKeys("`[V`]y"), editor);
                        break;
                    }
                    case 3: {
                        VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().stringToKeys("`[<C-V>`]y"), editor);
                        break;
                    }
                    case 1: {
                        VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().stringToKeys("`[v`]y"), editor);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            String text = Operator.getExchange$getRegisterText(editor, '\"');
            VimExtensionFacade.setRegister('\"', unnRegText);
            VimExtensionFacade.setRegister('*', starRegText);
            VimExtensionFacade.setRegister('+', plusRegText);
            return selectionStart.offset(IjVimEditorKt.getVim(editor)) <= selectionEnd.offset(IjVimEditorKt.getVim(editor)) ? new Exchange(selectionType, selectionStart, selectionEnd, text) : new Exchange(selectionType, selectionEnd, selectionStart, text);
        }

        private static final RangeHighlighter apply$highlightExchange(Editor ijEditor, Operator this$0, Exchange ex) {
            TextAttributes attributes = ijEditor.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
            HighlighterTargetArea hlArea = WhenMappings.$EnumSwitchMapping$0[ex.getType().ordinal()] == 2 ? HighlighterTargetArea.LINES_IN_RANGE : HighlighterTargetArea.EXACT_RANGE;
            boolean isVisualLine = ex.getType() == SelectionType.LINE_WISE;
            int endAdj = !isVisualLine && (hlArea == HighlighterTargetArea.EXACT_RANGE || this$0.isVisual) ? 1 : 0;
            RangeHighlighter rangeHighlighter = ijEditor.getMarkupModel().addRangeHighlighter(this$0.getMarkOffset(ijEditor, ex.getStart()), RangesKt.coerceAtMost((int)(this$0.getMarkOffset(ijEditor, ex.getEnd()) + endAdj), (int)EditorHelperRt.getFileSize(ijEditor)), 5999, attributes, hlArea);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            return rangeHighlighter;
        }

        private static final void exchange$pasteExchange(Editor $editor, Operator this$0, Exchange sourceExchange, Exchange targetExchange) {
            VimEditor vimEditor = IjVimEditorKt.getVim($editor);
            VimMarkServiceKt.setChangeMarks((VimMarkService)VimInjectorKt.getInjector().getMarkService(), (ImmutableVimCaret)((ImmutableVimCaret)vimEditor.primaryCaret()), (TextRange)new TextRange(this$0.getMarkOffset($editor, targetExchange.getStart()), this$0.getMarkOffset($editor, targetExchange.getEnd()) + 1));
            VimExtensionFacade.setRegister('z', VimInjectorKt.getInjector().getParser().stringToKeys(sourceExchange.getText()), sourceExchange.getType());
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().stringToKeys("`[" + this$0.getString(targetExchange.getType()) + "`]\"zp"), $editor);
        }

        private static final void exchange$fixCursor(Editor $editor, Operator this$0, Exchange ex1, Exchange ex2, boolean reverse) {
            Caret caret = $editor.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret primaryCaret = caret;
            if (reverse) {
                InlayHelperKt.moveToInlayAwareOffset(primaryCaret, this$0.getMarkOffset($editor, ex1.getStart()));
            } else if (ex1.getStart().getLine() == ex2.getStart().getLine()) {
                int horizontalOffset = ex1.getEnd().getCol() - ex2.getEnd().getCol();
                InlayHelperKt.moveToInlayAwareLogicalPosition(primaryCaret, new LogicalPosition(ex1.getStart().getLine(), ex1.getStart().getCol() - horizontalOffset));
            } else if (ex1.getEnd().getLine() - ex1.getStart().getLine() != ex2.getEnd().getLine() - ex2.getStart().getLine()) {
                int verticalOffset = ex1.getEnd().getLine() - ex2.getEnd().getLine();
                InlayHelperKt.moveToInlayAwareLogicalPosition(primaryCaret, new LogicalPosition(ex1.getStart().getLine() - verticalOffset, ex1.getStart().getCol()));
            }
        }

        private static final boolean compareExchanges$intersects(Exchange x, Exchange y) {
            return x.getEnd().getLine() < y.getStart().getLine() || x.getStart().getLine() > y.getEnd().getLine() || x.getEnd().getCol() < y.getStart().getCol() || x.getStart().getCol() > y.getEnd().getCol();
        }

        private static final int compareExchanges$comparePos(Mark x, Mark y) {
            return x.getLine() == y.getLine() ? x.getCol() - y.getCol() : x.getLine() - y.getLine();
        }

        /*
         * WARNING - void declaration
         */
        private static final String getExchange$getRegisterText(Editor $editor, char reg) {
            Object object;
            block4: {
                block3: {
                    void $this$mapTo$iv$iv;
                    object = VimExtensionFacade.getRegister(IjVimEditorKt.getVim($editor), reg);
                    if (object == null) break block3;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KeyStroke keyStroke = (KeyStroke)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(Character.valueOf(it.getKeyChar()));
                    }
                    object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                    if (object != null) break block4;
                }
                object = "";
            }
            return object;
        }

        private static final Pair<Mark, Mark> getExchange$getMarks(Editor $editor, boolean isVisual) {
            Pair pair = isVisual ? new Pair((Object)Character.valueOf('<'), (Object)Character.valueOf('>')) : new Pair((Object)Character.valueOf('['), (Object)Character.valueOf(']'));
            char startMark = ((Character)pair.component1()).charValue();
            char endMark = ((Character)pair.component2()).charValue();
            VimMarkService marks = VimInjectorKt.getInjector().getMarkService();
            VimEditor vimEditor = IjVimEditorKt.getVim($editor);
            Mark mark = marks.getMark((ImmutableVimCaret)vimEditor.primaryCaret(), startMark);
            Intrinsics.checkNotNull((Object)mark);
            Mark mark2 = marks.getMark((ImmutableVimCaret)vimEditor.primaryCaret(), endMark);
            Intrinsics.checkNotNull((Object)mark2);
            return new Pair((Object)mark, (Object)mark2);
        }

        public Operator() {
            this(false, 1, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Operator$ExchangeCompareResult;", "", "<init>", "(Ljava/lang/String;I)V", "OVERLAP", "OUTER", "INNER", "LT", "GT", "IdeaVIM"})
        public static final class ExchangeCompareResult
        extends Enum<ExchangeCompareResult> {
            public static final /* enum */ ExchangeCompareResult OVERLAP = new ExchangeCompareResult();
            public static final /* enum */ ExchangeCompareResult OUTER = new ExchangeCompareResult();
            public static final /* enum */ ExchangeCompareResult INNER = new ExchangeCompareResult();
            public static final /* enum */ ExchangeCompareResult LT = new ExchangeCompareResult();
            public static final /* enum */ ExchangeCompareResult GT = new ExchangeCompareResult();
            private static final /* synthetic */ ExchangeCompareResult[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ExchangeCompareResult[] values() {
                return (ExchangeCompareResult[])$VALUES.clone();
            }

            public static ExchangeCompareResult valueOf(String value) {
                return Enum.valueOf(ExchangeCompareResult.class, value);
            }

            @NotNull
            public static EnumEntries<ExchangeCompareResult> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = exchangeCompareResultArray = new ExchangeCompareResult[]{ExchangeCompareResult.OVERLAP, ExchangeCompareResult.OUTER, ExchangeCompareResult.INNER, ExchangeCompareResult.LT, ExchangeCompareResult.GT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[SelectionType.values().length];
                try {
                    nArray[SelectionType.CHARACTER_WISE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelectionType.LINE_WISE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelectionType.BLOCK_WISE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ExchangeCompareResult.values().length];
                try {
                    nArray[ExchangeCompareResult.OVERLAP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExchangeCompareResult.OUTER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExchangeCompareResult.INNER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExchangeCompareResult.GT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExchangeCompareResult.LT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Util;", "", "<init>", "()V", "EXCHANGE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$Exchange;", "getEXCHANGE_KEY", "()Lcom/intellij/openapi/util/Key;", "clearExchange", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "IdeaVIM"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @NotNull
        private static final Key<Exchange> EXCHANGE_KEY = new Key("exchange");

        private Util() {
        }

        @NotNull
        public final Key<Exchange> getEXCHANGE_KEY() {
            return EXCHANGE_KEY;
        }

        public final void clearExchange(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Exchange exchange = (Exchange)editor.getUserData(EXCHANGE_KEY);
            if (exchange != null && (exchange = exchange.getHighlighter()) != null) {
                Exchange it = exchange;
                boolean bl = false;
                editor.getMarkupModel().removeHighlighter((RangeHighlighter)it);
            }
            editor.putUserData(EXCHANGE_KEY, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/extension/exchange/VimExchangeExtension$VExchangeHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "<init>", "()V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    private static final class VExchangeHandler
    implements ExtensionHandler {
        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            Mode mode2 = editor.getMode();
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys("<Esc>"), IjVimEditorKt.getIj(editor));
            Operator operator = new Operator(true);
            SelectionType selectionType = ModeExtensionsKt.getSelectionType((Mode)mode2);
            if (selectionType == null) {
                selectionType = SelectionType.CHARACTER_WISE;
            }
            operator.apply(editor, context, selectionType);
        }

        public boolean isRepeatable() {
            return super.isRepeatable();
        }
    }
}

