/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.nerdtree;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.treeStructure.Tree;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.extension.nerdtree.Mappings;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher;", "Lcom/intellij/openapi/project/DumbAwareAction;", "mappings", "Lcom/maddyhome/idea/vim/extension/nerdtree/Mappings;", "<init>", "(Lcom/maddyhome/idea/vim/extension/nerdtree/Mappings;)V", "keys", "", "Ljavax/swing/KeyStroke;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "keyStrokeCache", "Lkotlin/Pair;", "Ljava/awt/event/KeyEvent;", "getKeyStroke", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nAbstractDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDispatcher.kt\ncom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,79:1\n38#2:80\n*S KotlinDebug\n*F\n+ 1 AbstractDispatcher.kt\ncom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher\n*L\n76#1:80\n*E\n"})
public abstract class AbstractDispatcher
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Mappings mappings;
    @NotNull
    private final List<KeyStroke> keys;
    @NotNull
    private Pair<? extends KeyEvent, ? extends KeyStroke> keyStrokeCache;
    @NotNull
    private static final VimLogger LOG;

    public AbstractDispatcher(@NotNull Mappings mappings) {
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        this.mappings = mappings;
        this.keys = new ArrayList();
        this.keyStrokeCache = TuplesKt.to(null, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KeyStroke keyStroke = this.getKeyStroke(e);
        if (keyStroke == null) {
            return;
        }
        KeyStroke keyStroke2 = keyStroke;
        char keyChar = keyStroke2.getKeyChar();
        if (keyChar != '\uffff') {
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(keyChar);
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke3, (String)"getKeyStroke(...)");
            keyStroke2 = keyStroke3;
        }
        this.keys.add(keyStroke2);
        Mappings.Action action = (Mappings.Action)((Function1)this.mappings.getGetAction()).invoke(this.keys);
        if (action != null) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            if (component instanceof Tree) {
                action.getAction().invoke((Object)e, (Object)component);
            } else {
                LOG.error("Component is not a tree: " + component);
            }
            this.keys.clear();
        } else if (!((Boolean)((Function1)this.mappings.isPrefix()).invoke(this.keys)).booleanValue()) {
            LOG.info("Unrecognised key sequence: " + this.keys);
            this.keys.clear();
        }
    }

    private final KeyStroke getKeyStroke(AnActionEvent e) {
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof KeyEvent) {
            KeyStroke defaultKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke((KeyEvent)((KeyEvent)inputEvent));
            Pair<? extends KeyEvent, ? extends KeyStroke> strokeCache = this.keyStrokeCache;
            if (defaultKeyStroke != null) {
                this.keyStrokeCache = TuplesKt.to((Object)inputEvent, (Object)defaultKeyStroke);
                return defaultKeyStroke;
            }
            if (strokeCache.getFirst() == inputEvent) {
                this.keyStrokeCache = TuplesKt.to(null, null);
                return (KeyStroke)strokeCache.getSecond();
            }
            return KeyStroke.getKeyStrokeForEvent((KeyEvent)inputEvent);
        }
        return null;
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(AbstractDispatcher.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLOG", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

