/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.nerdtree;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.Navigatable;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.CommandAliasHandler;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.nerdtree.AbstractDispatcher;
import com.maddyhome.idea.vim.extension.nerdtree.Mappings;
import com.maddyhome.idea.vim.extension.nerdtree.NerdTreeKt;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjNativeActionManagerKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00102\u00020\u0001:\b\t\n\u000b\f\r\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "registerMappings", "IjCommandHandler", "ToggleHandler", "CloseHandler", "ProjectViewListener", "NerdStartupActivity", "NerdDispatcher", "Util", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nNerdTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,390:1\n13472#2,2:391\n3829#2:393\n4344#2,2:394\n3829#2:398\n4344#2,2:399\n3829#2:403\n4344#2,2:404\n3829#2:408\n4344#2,2:409\n1869#3,2:396\n1869#3,2:401\n1869#3,2:406\n1869#3,2:411\n38#4:413\n*S KotlinDebug\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree\n*L\n127#1:391,2\n231#1:393\n231#1:394,2\n248#1:398\n248#1:399,2\n257#1:403\n257#1:404,2\n266#1:408\n266#1:409,2\n240#1:396,2\n249#1:401,2\n258#1:406,2\n267#1:411,2\n372#1:413\n*E\n"})
public final class NerdTree
implements VimExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String pluginName = "NERDTree";
    @NotNull
    private static final VimLogger LOG;

    @Override
    @NotNull
    public String getName() {
        return pluginName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        LOG.info("IdeaVim: Initializing NERDTree extension. Disable this extension if you observe a strange behaviour of the project tree. E.g. moving down on 'j'");
        this.registerMappings();
        NerdTreeKt.access$addCommand("NERDTreeFocus", new IjCommandHandler("ActivateProjectToolWindow"));
        NerdTreeKt.access$addCommand(pluginName, new IjCommandHandler("ActivateProjectToolWindow"));
        NerdTreeKt.access$addCommand("NERDTreeToggle", new ToggleHandler());
        NerdTreeKt.access$addCommand("NERDTreeClose", new CloseHandler());
        NerdTreeKt.access$addCommand("NERDTreeFind", new IjCommandHandler("SelectInProjectView"));
        NerdTreeKt.access$addCommand("NERDTreeRefreshRoot", new IjCommandHandler("Synchronize"));
        Object object = Util.INSTANCE.getMonitor$IdeaVIM();
        synchronized (object) {
            boolean bl = false;
            Util.INSTANCE.setCommandsRegistered$IdeaVIM(true);
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Project project = (Project)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)project);
                NerdTreeKt.access$installDispatcher(project);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerMappings() {
        NerdTreeKt.access$getMappings$p().registerNavigationMappings();
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapActivateNode", "o", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$4)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapPreview", "go", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$7)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapOpenInTab", "t", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$10)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapOpenInTabSilent", "T", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$13)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapOpenVSplit", "s", Mappings.Action.Companion.ij("OpenInRightSplit"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapOpenSplit", "i", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$14)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapPreviewVSplit", "gs", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$15)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapPreviewSplit", "gi", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$16)));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapRefresh", "r", Mappings.Action.Companion.ij("SynchronizeCurrentFile"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapToggleHidden", "I", Mappings.Action.Companion.ij("ProjectView.ShowExcludedFiles"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapNewFile", "n", Mappings.Action.Companion.ij("NewFile"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapNewDir", "N", Mappings.Action.Companion.ij("NewDir"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapDelete", "d", Mappings.Action.Companion.ij("$Delete"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapCopy", "y", Mappings.Action.Companion.ij("$Copy"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapPaste", "v", Mappings.Action.Companion.ij("$Paste"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapRename", "<C-r>", Mappings.Action.Companion.ij("RenameElement"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapRefreshRoot", "R", Mappings.Action.Companion.ij("Synchronize"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapMenu", "m", Mappings.Action.Companion.ij("ShowPopupMenu"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapQuit", "q", Mappings.Action.Companion.ij("HideActiveWindow"));
        NerdTreeKt.access$getMappings$p().register("NERDTreeMapToggleZoom", "A", Mappings.Action.Companion.ij("MaximizeToolWindow"));
        NerdTreeKt.access$getMappings$p().register("/", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$17)));
        NerdTreeKt.access$getMappings$p().register("<ESC>", new Mappings.Action((Function2<? super AnActionEvent, ? super Tree, Unit>)((Function2)NerdTree::registerMappings$lambda$18)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit registerMappings$lambda$4(AnActionEvent event, Tree tree) {
        block12: {
            List array;
            block9: {
                Object object;
                block11: {
                    block10: {
                        List list;
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                        DataContext dataContext = event.getDataContext();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                        Navigatable[] navigatableArray = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
                        if (navigatableArray != null) {
                            void $this$filterTo$iv$iv;
                            Navigatable[] $this$filter$iv = navigatableArray;
                            boolean $i$f$filter = false;
                            Navigatable[] navigatableArray2 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            int n = ((void)$this$filterTo$iv$iv).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv$iv;
                                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                                boolean bl = false;
                                if (!it.canNavigateToSource()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            list = (List)destination$iv$iv;
                        } else {
                            list = null;
                        }
                        array = list;
                        Collection collection = array;
                        if (!(collection == null || collection.isEmpty())) break block9;
                        object = tree.getSelectionRows();
                        if ((int[])object == null) break block10;
                        Integer n = ArraysKt.getOrNull((int[])object, (int)0);
                        object = n;
                        if (n != null) break block11;
                    }
                    return Unit.INSTANCE;
                }
                int row = object.intValue();
                if (tree.isExpanded(row)) {
                    tree.collapseRow(row);
                } else {
                    tree.expandRow(row);
                }
                break block12;
            }
            Iterable $this$forEach$iv = array;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Navigatable it = (Navigatable)element$iv;
                boolean bl = false;
                it.navigate(true);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit registerMappings$lambda$7(AnActionEvent event, Tree tree) {
        block2: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Navigatable[] navigatableArray = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
            if (navigatableArray == null) break block2;
            Navigatable[] $this$filter$iv = navigatableArray;
            boolean $i$f$filter = false;
            Navigatable[] navigatableArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.canNavigateToSource()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Navigatable it = (Navigatable)element$iv;
                boolean bl = false;
                it.navigate(false);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit registerMappings$lambda$10(AnActionEvent event, Tree tree) {
        block2: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Navigatable[] navigatableArray = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
            if (navigatableArray == null) break block2;
            Navigatable[] $this$filter$iv = navigatableArray;
            boolean $i$f$filter = false;
            Navigatable[] navigatableArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.canNavigateToSource()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Navigatable it = (Navigatable)element$iv;
                boolean bl = false;
                it.navigate(true);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit registerMappings$lambda$13(AnActionEvent event, Tree tree) {
        block2: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Navigatable[] navigatableArray = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
            if (navigatableArray == null) break block2;
            Navigatable[] $this$filter$iv = navigatableArray;
            boolean $i$f$filter = false;
            Navigatable[] navigatableArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.canNavigateToSource()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Navigatable it = (Navigatable)element$iv;
                boolean bl = false;
                it.navigate(true);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerMappings$lambda$14(AnActionEvent event, Tree tree) {
        block2: {
            EditorWindow currentWindow;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
            VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile == null) {
                return Unit.INSTANCE;
            }
            VirtualFile file = virtualFile;
            if (file.isDirectory()) {
                return Unit.INSTANCE;
            }
            EditorWindow editorWindow = currentWindow = Util.INSTANCE.getSplittersCurrentWindow(event);
            if (editorWindow == null) break block2;
            EditorWindow.split$default((EditorWindow)editorWindow, (int)0, (boolean)true, (VirtualFile)file, (boolean)true, (boolean)false, (int)16, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerMappings$lambda$15(AnActionEvent event, Tree tree) {
        EditorWindow currentWindow;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
        VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile file = virtualFile;
        EditorWindow editorWindow = currentWindow = Util.INSTANCE.getSplittersCurrentWindow(event);
        if (editorWindow != null) {
            EditorWindow.split$default((EditorWindow)editorWindow, (int)1, (boolean)true, (VirtualFile)file, (boolean)true, (boolean)false, (int)16, null);
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Util.INSTANCE.callAction(null, "ActivateProjectToolWindow", IjEditorExecutionContextKt.getVim(dataContext));
        return Unit.INSTANCE;
    }

    private static final Unit registerMappings$lambda$16(AnActionEvent event, Tree tree) {
        EditorWindow currentWindow;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
        VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile file = virtualFile;
        EditorWindow editorWindow = currentWindow = Util.INSTANCE.getSplittersCurrentWindow(event);
        if (editorWindow != null) {
            EditorWindow.split$default((EditorWindow)editorWindow, (int)0, (boolean)true, (VirtualFile)file, (boolean)true, (boolean)false, (int)16, null);
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Util.INSTANCE.callAction(null, "ActivateProjectToolWindow", IjEditorExecutionContextKt.getVim(dataContext));
        return Unit.INSTANCE;
    }

    private static final Unit registerMappings$lambda$17(AnActionEvent event, Tree tree) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
        Project project = event.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        NerdDispatcher.Companion.getInstance(project).setWaitForSearch$IdeaVIM(true);
        return Unit.INSTANCE;
    }

    private static final Unit registerMappings$lambda$18(AnActionEvent event, Tree tree) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"<unused var>");
        Project project = event.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        NerdDispatcher instance = NerdDispatcher.Companion.getInstance(project);
        if (instance.getWaitForSearch$IdeaVIM()) {
            instance.setWaitForSearch$IdeaVIM(false);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(NerdTree.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$CloseHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "<init>", "()V", "execute", "", "command", "", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    public static final class CloseHandler
    implements CommandAliasHandler {
        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Project project = IjVimEditorKt.getIj(editor).getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ToolWindow toolWindow = ToolWindowManagerEx.Companion.getInstanceEx(project2).getToolWindow("Project");
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2.isVisible()) {
                toolWindow2.hide();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$Companion;", "", "<init>", "()V", "pluginName", "", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$IjCommandHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "actionId", "", "<init>", "(Ljava/lang/String;)V", "execute", "", "command", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    public static final class IjCommandHandler
    implements CommandAliasHandler {
        @NotNull
        private final String actionId;

        public IjCommandHandler(@NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            this.actionId = actionId;
        }

        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Util.INSTANCE.callAction(editor, this.actionId, context);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher;", "Lcom/maddyhome/idea/vim/extension/nerdtree/AbstractDispatcher;", "<init>", "()V", "waitForSearch", "", "getWaitForSearch$IdeaVIM", "()Z", "setWaitForSearch$IdeaVIM", "(Z)V", "speedSearchListenerInstalled", "getSpeedSearchListenerInstalled$IdeaVIM", "setSpeedSearchListenerInstalled$IdeaVIM", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "speedSearchIsHere", "Companion", "IdeaVIM"})
    public static final class NerdDispatcher
    extends AbstractDispatcher {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean waitForSearch;
        private boolean speedSearchListenerInstalled;
        private static final int ESCAPE_KEY_CODE = 27;

        public NerdDispatcher() {
            super(NerdTreeKt.access$getMappings$p());
        }

        public final boolean getWaitForSearch$IdeaVIM() {
            return this.waitForSearch;
        }

        public final void setWaitForSearch$IdeaVIM(boolean bl) {
            this.waitForSearch = bl;
        }

        public final boolean getSpeedSearchListenerInstalled$IdeaVIM() {
            return this.speedSearchListenerInstalled;
        }

        public final void setSpeedSearchListenerInstalled$IdeaVIM(boolean bl) {
            this.speedSearchListenerInstalled = bl;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            InputEvent inputEvent = e.getInputEvent();
            KeyEvent keyEvent = inputEvent instanceof KeyEvent ? (KeyEvent)inputEvent : null;
            boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 27 : false;
            if (bl) {
                e.getPresentation().setEnabled(this.waitForSearch);
                return;
            }
            if (this.waitForSearch) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabled(!this.speedSearchIsHere(e));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private final boolean speedSearchIsHere(AnActionEvent e) {
            String searchText = (String)e.getData(PlatformDataKeys.SPEED_SEARCH_TEXT);
            CharSequence charSequence = searchText;
            return !(charSequence == null || charSequence.length() == 0);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher;", "project", "Lcom/intellij/openapi/project/Project;", "ESCAPE_KEY_CODE", "", "IdeaVIM"})
        @SourceDebugExtension(value={"SMAP\nNerdTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,390:1\n31#2,2:391\n*S KotlinDebug\n*F\n+ 1 NerdTree.kt\ncom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdDispatcher$Companion\n*L\n217#1:391,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NerdDispatcher getInstance(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<NerdDispatcher> serviceClass$iv = NerdDispatcher.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (NerdDispatcher)((Object)object);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$NerdStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "IdeaVIM"})
    public static final class NerdStartupActivity
    implements ProjectActivity {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Object object = Util.INSTANCE.getMonitor$IdeaVIM();
            synchronized (object) {
                block4: {
                    boolean bl = false;
                    if (Util.INSTANCE.getCommandsRegistered$IdeaVIM()) break block4;
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                NerdTreeKt.access$installDispatcher(project);
                Unit unit = Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$ProjectViewListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "toolWindowShown", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "IdeaVIM"})
    public static final class ProjectViewListener
    implements ToolWindowManagerListener {
        @NotNull
        private final Project project;

        public ProjectViewListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void toolWindowShown(@NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            if (!Intrinsics.areEqual((Object)"Project", (Object)toolWindow.getId())) {
                return;
            }
            NerdDispatcher dispatcher = NerdDispatcher.Companion.getInstance(this.project);
            if (dispatcher.getSpeedSearchListenerInstalled$IdeaVIM()) {
                return;
            }
            AbstractProjectViewPane currentProjectViewPane = ProjectView.getInstance((Project)this.project).getCurrentProjectViewPane();
            Object object = currentProjectViewPane;
            if (object == null || (object = object.getTree()) == null) {
                return;
            }
            Object tree = object;
            SpeedSearchSupply speedSearchSupply = SpeedSearchSupply.getSupply((JComponent)((JComponent)tree), (boolean)true);
            if (speedSearchSupply == null) {
                return;
            }
            SpeedSearchSupply supply = speedSearchSupply;
            dispatcher.setSpeedSearchListenerInstalled$IdeaVIM(true);
            supply.addChangeListener(arg_0 -> ProjectViewListener.toolWindowShown$lambda$0(dispatcher, arg_0));
        }

        private static final void toolWindowShown$lambda$0(NerdDispatcher $dispatcher, PropertyChangeEvent it) {
            $dispatcher.setWaitForSearch$IdeaVIM(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$ToggleHandler;", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "<init>", "()V", "execute", "", "command", "", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "IdeaVIM"})
    public static final class ToggleHandler
    implements CommandAliasHandler {
        public void execute(@NotNull String command, @NotNull Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Project project = IjVimEditorKt.getIj(editor).getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ToolWindow toolWindow = ToolWindowManagerEx.Companion.getInstanceEx(project2).getToolWindow("Project");
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2.isVisible()) {
                toolWindow2.hide();
            } else {
                Util.INSTANCE.callAction(editor, "ActivateProjectToolWindow", context);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/extension/nerdtree/NerdTree$Util;", "", "<init>", "()V", "monitor", "getMonitor$IdeaVIM", "()Ljava/lang/Object;", "commandsRegistered", "", "getCommandsRegistered$IdeaVIM", "()Z", "setCommandsRegistered$IdeaVIM", "(Z)V", "callAction", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "name", "", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "getSplittersCurrentWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "IdeaVIM"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @NotNull
        private static final Object monitor = new Object();
        private static boolean commandsRegistered;

        private Util() {
        }

        @NotNull
        public final Object getMonitor$IdeaVIM() {
            return monitor;
        }

        public final boolean getCommandsRegistered$IdeaVIM() {
            return commandsRegistered;
        }

        public final void setCommandsRegistered$IdeaVIM(boolean bl) {
            commandsRegistered = bl;
        }

        public final void callAction(@Nullable VimEditor editor, @NotNull String name, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AnAction anAction = ActionManager.getInstance().getAction(name);
            if (anAction == null) {
                Util $this$callAction_u24lambda_u240 = this;
                boolean bl = false;
                Object[] objectArray = new Object[]{name};
                VimPlugin.showMessage(MessageHelper.message("action.not.found.0", objectArray));
                return;
            }
            AnAction action = anAction;
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, (NativeAction)IjNativeActionManagerKt.getVim(action), context);
            } else {
                UiHelper.runAfterGotFocus(() -> Util.callAction$lambda$1(editor, action, context));
            }
        }

        @Nullable
        public final EditorWindow getSplittersCurrentWindow(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project = event.getProject();
            if (project == null) {
                return null;
            }
            EditorsSplitters splitters = FileEditorManagerEx.Companion.getInstanceEx(project).getSplitters();
            return splitters.getCurrentWindow();
        }

        private static final void callAction$lambda$1(VimEditor $editor, AnAction $action, ExecutionContext $context) {
            VimInjectorKt.getInjector().getActionExecutor().executeAction($editor, (NativeAction)IjNativeActionManagerKt.getVim($action), $context);
        }
    }
}

