/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.sneak;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.maddyhome.idea.vim.VimProjectService;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.VimExtensionHandler;
import com.maddyhome.idea.vim.extension.sneak.IdeaVimSneakExtensionKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \b2\u00020\u0001:\b\b\t\n\u000b\f\r\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "<init>", "()V", "getName", "", "init", "", "Companion", "SneakHandler", "SneakMemoryHandler", "SneakRepeatHandler", "Util", "Direction", "RepeatDirection", "HighlightHandler", "IdeaVIM"})
public final class IdeaVimSneakExtension
implements VimExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static HighlightHandler highlightHandler;

    @Override
    @NotNull
    public String getName() {
        return "sneak";
    }

    @Override
    public void init() {
        HighlightHandler _highlightHandler = new HighlightHandler();
        highlightHandler = _highlightHandler;
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "s", new SneakHandler(_highlightHandler, Direction.FORWARD), MappingMode.NXO);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "S", new SneakHandler(_highlightHandler, Direction.BACKWARD), MappingMode.Companion.getNO());
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "Z", new SneakHandler(_highlightHandler, Direction.BACKWARD), MappingMode.X);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "f", new SneakMemoryHandler("f"), MappingMode.NXO);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "F", new SneakMemoryHandler("F"), MappingMode.NXO);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "t", new SneakMemoryHandler("t"), MappingMode.NXO);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, "T", new SneakMemoryHandler("T"), MappingMode.NXO);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, ";", new SneakRepeatHandler(_highlightHandler, RepeatDirection.IDENTICAL), MappingMode.NXO);
        IdeaVimSneakExtensionKt.access$mapToFunctionAndProvideKeys(this, ",", new SneakRepeatHandler(_highlightHandler, RepeatDirection.REVERSE), MappingMode.NXO);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Companion;", "", "<init>", "()V", "highlightHandler", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler;", "stopTimer", "", "stopTimer$IdeaVIM", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void stopTimer$IdeaVIM() {
            block0: {
                HighlightHandler highlightHandler = highlightHandler;
                if (highlightHandler == null) break block0;
                highlightHandler.stopExistingTimer();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0013J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "", "offset", "", "<init>", "(Ljava/lang/String;II)V", "getOffset", "()I", "FORWARD", "BACKWARD", "findBiChar", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "charSequence", "", "position", "charone", "", "chartwo", "(Lcom/maddyhome/idea/vim/api/VimEditor;Ljava/lang/CharSequence;ICC)Ljava/lang/Integer;", "matches", "", "charPosition", "charOne", "charTwo", "IdeaVIM"})
    private static final abstract class Direction
    extends Enum<Direction> {
        private final int offset;
        public static final /* enum */ Direction FORWARD = new FORWARD("FORWARD", 0);
        public static final /* enum */ Direction BACKWARD = new BACKWARD("BACKWARD", 1);
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Direction(int offset) {
            this.offset = offset;
        }

        public final int getOffset() {
            return this.offset;
        }

        @Nullable
        public abstract Integer findBiChar(@NotNull VimEditor var1, @NotNull CharSequence var2, int var3, char var4, char var5);

        public final boolean matches(@NotNull VimEditor editor, @NotNull CharSequence charSequence, int charPosition, char charOne, char charTwo) {
            boolean match;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
            boolean bl = match = CharsKt.equals((char)charSequence.charAt(charPosition), (char)charOne, (boolean)VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).getIgnorecase()) && CharsKt.equals((char)charSequence.charAt(charPosition + 1), (char)charTwo, (boolean)VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).getIgnorecase());
            if (VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).getIgnorecase() && VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).getSmartcase() && (Character.isUpperCase(charOne) || Character.isUpperCase(charTwo))) {
                match = CharsKt.equals((char)charSequence.charAt(charPosition), (char)charOne, (boolean)false) && CharsKt.equals((char)charSequence.charAt(charPosition + 1), (char)charTwo, (boolean)false);
            }
            return match;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Direction(String $enum$name, int $enum$ordinal, int offset, DefaultConstructorMarker $constructor_marker) {
            this(offset);
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.FORWARD, Direction.BACKWARD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J7\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"com/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension.Direction.BACKWARD", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "findBiChar", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "charSequence", "", "position", "charone", "", "chartwo", "(Lcom/maddyhome/idea/vim/api/VimEditor;Ljava/lang/CharSequence;ICC)Ljava/lang/Integer;", "IdeaVIM"})
        static final class BACKWARD
        extends Direction {
            /*
             * WARNING - void declaration
             */
            BACKWARD() {
                void var1_1;
            }

            @Override
            @Nullable
            public Integer findBiChar(@NotNull VimEditor editor, @NotNull CharSequence charSequence, int position, char charone, char chartwo) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
                for (int i = position + this.getOffset(); -1 < i; --i) {
                    if (!this.matches(editor, charSequence, i, charone, chartwo)) continue;
                    return i;
                }
                return null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J7\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"com/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension.Direction.FORWARD", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "findBiChar", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "charSequence", "", "position", "charone", "", "chartwo", "(Lcom/maddyhome/idea/vim/api/VimEditor;Ljava/lang/CharSequence;ICC)Ljava/lang/Integer;", "IdeaVIM"})
        static final class FORWARD
        extends Direction {
            /*
             * WARNING - void declaration
             */
            FORWARD() {
                void var1_1;
            }

            @Override
            @Nullable
            public Integer findBiChar(@NotNull VimEditor editor, @NotNull CharSequence charSequence, int position, char charone, char chartwo) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
                int n = charSequence.length() - 1;
                for (int i = position + this.getOffset(); i < n; ++i) {
                    if (!this.matches(editor, charSequence, i, charone, chartwo)) continue;
                    return i;
                }
                return null;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0006\u0010\u0015\u001a\u00020\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler;", "", "<init>", "()V", "editor", "Lcom/intellij/openapi/editor/Editor;", "sneakHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "timer", "Ljavax/swing/Timer;", "highlightSneakRange", "", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "clearAllSneakHighlighters", "highlightSingleRange", "Lkotlin/ranges/ClosedRange;", "", "setClearHighlightRangeTimer", "highlighter", "stopExistingTimer", "getHighlightTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nIdeaVimSneakExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaVimSneakExtension.kt\ncom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,347:1\n1869#2,2:348\n13472#3,2:350\n*S KotlinDebug\n*F\n+ 1 IdeaVimSneakExtension.kt\ncom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler\n*L\n248#1:348,2\n282#1:350,2\n*E\n"})
    private static final class HighlightHandler {
        @Nullable
        private Editor editor;
        @NotNull
        private final Set<RangeHighlighter> sneakHighlighters = new LinkedHashSet();
        @Nullable
        private Timer timer;

        public final void highlightSneakRange(@NotNull Editor editor, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.clearAllSneakHighlighters();
            this.editor = editor;
            Project project = editor.getProject();
            if (project != null) {
                Disposer.register((Disposable)VimProjectService.Companion.getInstance(project), () -> HighlightHandler.highlightSneakRange$lambda$0(this));
            }
            if (range.isMultiple()) {
                int n = range.size();
                for (int i = 0; i < n; ++i) {
                    this.highlightSingleRange(editor, (ClosedRange<Integer>)((ClosedRange)new IntRange(range.getStartOffsets()[i], range.getEndOffsets()[i])));
                }
            } else {
                this.highlightSingleRange(editor, (ClosedRange<Integer>)((ClosedRange)new IntRange(range.getStartOffset(), range.getEndOffset())));
            }
        }

        public final void clearAllSneakHighlighters() {
            Iterable $this$forEach$iv = this.sneakHighlighters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter highlighter = (RangeHighlighter)element$iv;
                boolean bl = false;
                Editor editor = this.editor;
                if (editor != null && (editor = editor.getMarkupModel()) != null) {
                    editor.removeHighlighter(highlighter);
                    continue;
                }
                StrictMode.INSTANCE.fail("Highlighters without an editor");
            }
            this.sneakHighlighters.clear();
        }

        private final void highlightSingleRange(Editor editor, ClosedRange<Integer> range) {
            RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(((Number)((Object)range.getStart())).intValue(), ((Number)((Object)range.getEndInclusive())).intValue(), 6000, this.getHighlightTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter highlighter = rangeHighlighter;
            this.sneakHighlighters.add(highlighter);
            this.setClearHighlightRangeTimer(highlighter);
        }

        private final void setClearHighlightRangeTimer(RangeHighlighter highlighter) {
            block1: {
                this.stopExistingTimer();
                Timer timer2 = this.timer = new Timer(300, arg_0 -> HighlightHandler.setClearHighlightRangeTimer$lambda$2(this, highlighter, arg_0));
                if (timer2 != null) {
                    timer2.setRepeats(false);
                }
                Timer timer3 = this.timer;
                if (timer3 == null) break block1;
                timer3.start();
            }
        }

        public final void stopExistingTimer() {
            block2: {
                Timer timer2 = this.timer;
                if (timer2 != null) {
                    timer2.stop();
                }
                ActionListener[] actionListenerArray = this.timer;
                if (this.timer == null || (actionListenerArray = actionListenerArray.getActionListeners()) == null) break block2;
                ActionListener[] $this$forEach$iv = actionListenerArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    ActionListener element$iv;
                    ActionListener it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    it.actionPerformed(null);
                }
            }
        }

        private final TextAttributes getHighlightTextAttributes() {
            Editor editor;
            return new TextAttributes(null, EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getDefaultAttributes().getBackgroundColor(), (editor = this.editor) != null && (editor = editor.getColorsScheme()) != null ? editor.getColor(EditorColors.CARET_COLOR) : null, EffectType.SEARCH_MATCH, 0);
        }

        private static final void highlightSneakRange$lambda$0(HighlightHandler this$0) {
            this$0.editor = null;
            this$0.sneakHighlighters.clear();
        }

        private static final void setClearHighlightRangeTimer$lambda$2(HighlightHandler this$0, RangeHighlighter $highlighter, ActionEvent it) {
            block0: {
                Editor editor;
                Editor editor2 = this$0.editor;
                if ((editor2 != null ? editor2.isDisposed() : false) || (editor = this$0.editor) == null || (editor = editor.getMarkupModel()) == null) break block0;
                editor.removeHighlighter($highlighter);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$RepeatDirection;", "", "symb", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSymb", "()Ljava/lang/String;", "IDENTICAL", "REVERSE", "map", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "direction", "IdeaVIM"})
    private static final abstract class RepeatDirection
    extends Enum<RepeatDirection> {
        @NotNull
        private final String symb;
        public static final /* enum */ RepeatDirection IDENTICAL = new IDENTICAL("IDENTICAL", 0);
        public static final /* enum */ RepeatDirection REVERSE = new REVERSE("REVERSE", 1);
        private static final /* synthetic */ RepeatDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RepeatDirection(String symb) {
            this.symb = symb;
        }

        @NotNull
        public final String getSymb() {
            return this.symb;
        }

        @NotNull
        public abstract Direction map(@NotNull Direction var1);

        public static RepeatDirection[] values() {
            return (RepeatDirection[])$VALUES.clone();
        }

        public static RepeatDirection valueOf(String value) {
            return Enum.valueOf(RepeatDirection.class, value);
        }

        @NotNull
        public static EnumEntries<RepeatDirection> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ RepeatDirection(String $enum$name, int $enum$ordinal, String symb, DefaultConstructorMarker $constructor_marker) {
            this(symb);
        }

        static {
            $VALUES = repeatDirectionArray = new RepeatDirection[]{RepeatDirection.IDENTICAL, RepeatDirection.REVERSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension.RepeatDirection.IDENTICAL", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$RepeatDirection;", "map", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "direction", "IdeaVIM"})
        static final class IDENTICAL
        extends RepeatDirection {
            /*
             * WARNING - void declaration
             */
            IDENTICAL() {
                void var1_1;
            }

            @Override
            @NotNull
            public Direction map(@NotNull Direction direction) {
                Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
                return direction;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension.RepeatDirection.REVERSE", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$RepeatDirection;", "map", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "direction", "IdeaVIM"})
        static final class REVERSE
        extends RepeatDirection {
            /*
             * WARNING - void declaration
             */
            REVERSE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Direction map(@NotNull Direction direction) {
                Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
                return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 1 -> Direction.BACKWARD;
                    case 2 -> Direction.FORWARD;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Direction.values().length];
                    try {
                        nArray[Direction.FORWARD.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Direction.BACKWARD.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$SneakHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "highlightHandler", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler;", "direction", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "<init>", "(Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler;Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;)V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "getChar", "", "(Lcom/maddyhome/idea/vim/api/VimEditor;)Ljava/lang/Character;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nIdeaVimSneakExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaVimSneakExtension.kt\ncom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$SneakHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
    private static final class SneakHandler
    implements ExtensionHandler {
        @NotNull
        private final HighlightHandler highlightHandler;
        @NotNull
        private final Direction direction;

        public SneakHandler(@NotNull HighlightHandler highlightHandler, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)highlightHandler, (String)"highlightHandler");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            this.highlightHandler = highlightHandler;
            this.direction = direction;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            TextRange range;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            Character c = this.getChar(editor);
            if (c == null) {
                return;
            }
            char charone = c.charValue();
            Character c2 = this.getChar(editor);
            if (c2 == null) {
                return;
            }
            char chartwo = c2.charValue();
            TextRange textRange = range = Util.INSTANCE.jumpTo(editor, charone, chartwo, this.direction);
            if (textRange != null) {
                TextRange it = textRange;
                boolean bl = false;
                this.highlightHandler.highlightSneakRange(IjVimEditorKt.getIj(editor), range);
            }
            Util.INSTANCE.setLastSymbols("" + charone + chartwo);
            Util.INSTANCE.setLastSDirection(this.direction);
        }

        private final Character getChar(VimEditor editor) {
            KeyStroke key = VimExtensionFacade.inputKeyStroke(IjVimEditorKt.getIj(editor));
            return key.getKeyChar() == '\uffff' || key.getKeyCode() == 27 ? null : Character.valueOf(key.getKeyChar());
        }

        public boolean isRepeatable() {
            return super.isRepeatable();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$SneakMemoryHandler;", "Lcom/maddyhome/idea/vim/extension/VimExtensionHandler;", "char", "", "<init>", "(Ljava/lang/String;)V", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "IdeaVIM"})
    private static final class SneakMemoryHandler
    implements VimExtensionHandler {
        @NotNull
        private final String char;

        public SneakMemoryHandler(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"char");
            this.char = string;
        }

        @Override
        public void execute(@NotNull Editor editor, @NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Util.INSTANCE.setLastSDirection(null);
            VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys(this.char), editor);
        }

        @Override
        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            VimExtensionHandler.super.execute(editor, context, operatorArguments);
        }

        public boolean isRepeatable() {
            return VimExtensionHandler.super.isRepeatable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$SneakRepeatHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "highlightHandler", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler;", "direction", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$RepeatDirection;", "<init>", "(Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$HighlightHandler;Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$RepeatDirection;)V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nIdeaVimSneakExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaVimSneakExtension.kt\ncom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$SneakRepeatHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
    private static final class SneakRepeatHandler
    implements ExtensionHandler {
        @NotNull
        private final HighlightHandler highlightHandler;
        @NotNull
        private final RepeatDirection direction;

        public SneakRepeatHandler(@NotNull HighlightHandler highlightHandler, @NotNull RepeatDirection direction) {
            Intrinsics.checkNotNullParameter((Object)highlightHandler, (String)"highlightHandler");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            this.highlightHandler = highlightHandler;
            this.direction = direction;
        }

        public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            Direction lastSDirection = Util.INSTANCE.getLastSDirection();
            if (lastSDirection != null) {
                TextRange jumpRange;
                List list = StringsKt.toList((CharSequence)Util.INSTANCE.getLastSymbols());
                char charone = ((Character)list.get(0)).charValue();
                char chartwo = ((Character)list.get(1)).charValue();
                TextRange textRange = jumpRange = Util.INSTANCE.jumpTo(editor, charone, chartwo, this.direction.map(lastSDirection));
                if (textRange != null) {
                    TextRange it = textRange;
                    boolean bl = false;
                    this.highlightHandler.highlightSneakRange(IjVimEditorKt.getIj(editor), jumpRange);
                }
            } else {
                VimExtensionFacade.executeNormalWithoutMapping(VimInjectorKt.getInjector().getParser().parseKeys(this.direction.getSymb()), IjVimEditorKt.getIj(editor));
            }
        }

        public boolean isRepeatable() {
            return super.isRepeatable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Util;", "", "<init>", "()V", "lastSDirection", "Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "getLastSDirection", "()Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;", "setLastSDirection", "(Lcom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Direction;)V", "lastSymbols", "", "getLastSymbols", "()Ljava/lang/String;", "setLastSymbols", "(Ljava/lang/String;)V", "jumpTo", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "charone", "", "chartwo", "sneakDirection", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nIdeaVimSneakExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaVimSneakExtension.kt\ncom/maddyhome/idea/vim/extension/sneak/IdeaVimSneakExtension$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
    private static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @Nullable
        private static Direction lastSDirection;
        @NotNull
        private static String lastSymbols;

        private Util() {
        }

        @Nullable
        public final Direction getLastSDirection() {
            return lastSDirection;
        }

        public final void setLastSDirection(@Nullable Direction direction) {
            lastSDirection = direction;
        }

        @NotNull
        public final String getLastSymbols() {
            return lastSymbols;
        }

        public final void setLastSymbols(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            lastSymbols = string;
        }

        @Nullable
        public final TextRange jumpTo(@NotNull VimEditor editor, char charone, char chartwo, @NotNull Direction sneakDirection) {
            TextRange textRange;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)sneakDirection), (String)"sneakDirection");
            VimCaret caret = editor.primaryCaret();
            int position = caret.getOffset();
            CharSequence chars = editor.text();
            Integer foundPosition = sneakDirection.findBiChar(editor, chars, position, charone, chartwo);
            if (foundPosition != null) {
                editor.primaryCaret().moveToOffset(foundPosition.intValue());
            }
            IjVimEditorKt.getIj(editor).getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            Integer n = foundPosition;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                textRange = new TextRange(foundPosition.intValue(), foundPosition + 2);
            } else {
                textRange = null;
            }
            return textRange;
        }

        static {
            lastSymbols = "";
        }
    }
}

