/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CharSequenceReader;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimProcessGroupBase;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/group/ProcessGroup;", "Lcom/maddyhome/idea/vim/api/VimProcessGroupBase;", "<init>", "()V", "executeCommand", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "command", "input", "", "currentDirectoryPath", "doEscape", "original", "charsToEscape", "escapeChar", "copy", "", "from", "Ljava/io/Reader;", "to", "Ljava/io/Writer;", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nProcessGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessGroup.kt\ncom/maddyhome/idea/vim/group/ProcessGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n1#2:138\n15#3:139\n*S KotlinDebug\n*F\n+ 1 ProcessGroup.kt\ncom/maddyhome/idea/vim/group/ProcessGroup\n*L\n134#1:139\n*E\n"})
public final class ProcessGroup
extends VimProcessGroupBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Nullable
    public String executeCommand(@NotNull VimEditor editor, @NotNull String command, @Nullable CharSequence input, @Nullable String currentDirectoryPath) throws ExecutionException, ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ProcessGroup.executeCommand$lambda$0(this, command, currentDirectoryPath, input), "IdeaVim - !" + command, true, IjVimEditorKt.getIj(editor).getProject());
    }

    private final String doEscape(String original, String charsToEscape, String escapeChar) {
        String result = original;
        char[] cArray = charsToEscape.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            result = StringsKt.replace$default((String)result, (String)("" + c), (String)(escapeChar + c), (boolean)false, (int)4, null);
        }
        return result;
    }

    private final void copy(Reader from, Writer to) throws IOException {
        char[] buf = new char[2048];
        int cnt = 0;
        while (true) {
            int n;
            int it = n = from.read(buf);
            boolean bl = false;
            cnt = it;
            if (n == -1) break;
            to.write(buf, 0, cnt);
        }
    }

    private static final String executeCommand$lambda$0(ProcessGroup this$0, String $command, String $currentDirectoryPath, CharSequence $input) {
        String escapedCommand;
        String shell = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getShell();
        String shellcmdflag = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getShellcmdflag();
        String shellxescape = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getShellxescape();
        String shellxquote = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getShellxquote();
        String string = escapedCommand = Intrinsics.areEqual((Object)shellxquote, (Object)"(") ? this$0.doEscape($command, shellxescape, "^") : $command;
        String quotedCommand = Intrinsics.areEqual((Object)shellxquote, (Object)"(") ? "(" + escapedCommand + ")" : (Intrinsics.areEqual((Object)shellxquote, (Object)"\"(") ? "\"(" + escapedCommand + ")\"" : shellxquote + escapedCommand + shellxquote);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(shell);
        if (((CharSequence)shellcmdflag).length() > 0) {
            commands.addAll(ParametersListUtil.parse((String)shellcmdflag));
        }
        commands.add(quotedCommand);
        if (logger.isDebugEnabled()) {
            String string2 = "shell=%s shellcmdflag=%s command=%s";
            Object[] objectArray = new Object[]{shell, shellcmdflag, quotedCommand};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            logger.debug(string3);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine((List)commands);
        if ($currentDirectoryPath != null) {
            commandLine.setWorkDirectory($currentDirectoryPath);
        }
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        if ($input != null) {
            handler.addProcessListener((ProcessListener)new ProcessAdapter($input, handler, this$0){
                final /* synthetic */ CharSequence $input;
                final /* synthetic */ CapturingProcessHandler $handler;
                final /* synthetic */ ProcessGroup this$0;
                {
                    this.$input = $input;
                    this.$handler = $handler;
                    this.this$0 = $receiver;
                }

                public void startNotified(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    try {
                        CharSequenceReader charSequenceReader = new CharSequenceReader(this.$input);
                        BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter(this.$handler.getProcessInput()));
                        ProcessGroup.access$copy(this.this$0, (Reader)charSequenceReader, outputStreamWriter);
                        outputStreamWriter.close();
                    }
                    catch (IOException e) {
                        ProcessGroup.access$getLogger$cp().error((Throwable)e);
                    }
                }
            });
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getInstance().getProgressIndicator();
        ProcessOutput processOutput = handler.runProcessWithProgressIndicator(progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcessWithProgressIndicator(...)");
        ProcessOutput output = processOutput;
        if (output.isCancelled()) {
            throw new ProcessCanceledException();
        }
        Integer exitCode = handler.getExitCode();
        if (exitCode != null && exitCode != 0) {
            VimPlugin.showMessage("shell returned " + exitCode);
            VimPlugin.indicateError();
        }
        CharSequence charSequence = output.getStderr() + output.getStdout();
        Regex regex = new Regex("\u001b\\[[;\\d]*m");
        String string4 = "";
        return regex.replace(charSequence, string4);
    }

    public static final /* synthetic */ void access$copy(ProcessGroup $this, Reader from, Writer to) {
        $this.copy(from, to);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessGroup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProcessGroup.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/group/ProcessGroup$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

