/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.group.TabService;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/group/TabServiceImpl;", "Lcom/maddyhome/idea/vim/group/TabService;", "<init>", "()V", "removeTabAt", "", "indexToDelete", "", "indexToSelect", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "getTabCount", "getCurrentTabIndex", "moveCurrentTabToIndex", "index", "closeAllExceptCurrentTab", "getCurrentTab", "Lcom/intellij/ui/tabs/TabInfo;", "getCurrentWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getTabbedPane", "Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainer;", "getTabs", "Lcom/intellij/ui/tabs/JBTabs;", "IdeaVIM"})
public final class TabServiceImpl
implements TabService {
    public void removeTabAt(int indexToDelete, int indexToSelect, @NotNull ExecutionContext context) {
        EditorTabbedContainer tabbedPane;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EditorTabbedContainer editorTabbedContainer = tabbedPane = this.getTabbedPane(context);
        if (editorTabbedContainer != null) {
            editorTabbedContainer.removeTabAt(indexToDelete, indexToDelete);
        }
        TabInfo tabInfo = this.getCurrentTab(context);
        if (tabInfo == null) {
            return;
        }
        TabInfo currentTab = tabInfo;
        IdeFocusManager.findInstance().requestFocus((Component)currentTab.getComponent(), true);
    }

    public int getTabCount(@NotNull ExecutionContext context) {
        JBTabs tabs;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JBTabs jBTabs = tabs = this.getTabs(context);
        return jBTabs != null ? jBTabs.getTabCount() : 0;
    }

    public int getCurrentTabIndex(@NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TabInfo tabInfo = this.getCurrentTab(context);
        if (tabInfo == null) {
            throw new ExException("There is no tab selected");
        }
        TabInfo currentTab = tabInfo;
        JBTabs jBTabs = this.getTabs(context);
        if (jBTabs == null) {
            throw new ExException("There are no tabs open");
        }
        return jBTabs.getIndexOf(currentTab);
    }

    public void moveCurrentTabToIndex(int index, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TabInfo tabInfo = this.getCurrentTab(context);
        if (tabInfo == null) {
            throw new ExException("There is no tab selected");
        }
        TabInfo tab = tabInfo;
        JBTabs jBTabs = this.getTabs(context);
        if (jBTabs == null) {
            throw new ExException("There are no tabs open");
        }
        JBTabs tabs = jBTabs;
        tabs.removeTab(tab);
        tabs.addTab(tab, index);
        tabs.select(tab, true);
    }

    public void closeAllExceptCurrentTab(@NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EditorWindow editorWindow = this.getCurrentWindow(context);
        if (editorWindow == null) {
            throw new ExException("There is no tab selected");
        }
        EditorWindow currentWindow = editorWindow;
        currentWindow.closeAllExcept(currentWindow.getSelectedFile());
    }

    private final TabInfo getCurrentTab(ExecutionContext context) {
        JBTabs jBTabs = this.getTabs(context);
        return jBTabs != null ? jBTabs.getSelectedInfo() : null;
    }

    private final EditorWindow getCurrentWindow(ExecutionContext context) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(IjEditorExecutionContextKt.getIj(context));
        if (project == null) {
            throw new ExException("Could not get current tab list");
        }
        Project project2 = project;
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx(project2);
        return fileEditorManager.getCurrentWindow();
    }

    private final EditorTabbedContainer getTabbedPane(ExecutionContext context) {
        EditorWindow currentWindow;
        EditorWindow editorWindow = currentWindow = this.getCurrentWindow(context);
        return editorWindow != null ? editorWindow.getTabbedPane() : null;
    }

    private final JBTabs getTabs(ExecutionContext context) {
        EditorTabbedContainer tabbedPane;
        EditorTabbedContainer editorTabbedContainer = tabbedPane = this.getTabbedPane(context);
        return editorTabbedContainer != null ? editorTabbedContainer.getTabs() : null;
    }
}

