/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.group.WindowGroupBase;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.helper.VimLockLabel;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContext;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowGroup
extends WindowGroupBase {
    public void closeCurrentWindow(@NotNull ExecutionContext context) {
        FileEditorManagerEx fileEditorManager;
        EditorWindow window;
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(0);
        }
        if ((window = (fileEditorManager = WindowGroup.getFileEditorManager((DataContext)context.getContext())).getSplitters().getCurrentWindow()) != null) {
            window.closeAllExcept(null);
        }
    }

    public void closeAllExceptCurrent(@NotNull ExecutionContext context) {
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(1);
        }
        FileEditorManagerEx fileEditorManager = WindowGroup.getFileEditorManager((DataContext)context.getContext());
        EditorWindow current = fileEditorManager.getCurrentWindow();
        for (EditorWindow window : fileEditorManager.getWindows()) {
            if (window == current) continue;
            window.closeAllExcept(null);
        }
    }

    public void closeAll(@NotNull ExecutionContext context) {
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(2);
        }
        WindowGroup.getFileEditorManager(((IjEditorExecutionContext)context).getContext()).closeAllFiles();
    }

    public void selectNextWindow(@NotNull ExecutionContext context) {
        EditorWindow nextWindow;
        FileEditorManagerEx fileEditorManager;
        EditorWindow current;
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(3);
        }
        if ((current = (fileEditorManager = WindowGroup.getFileEditorManager((DataContext)context.getContext())).getCurrentWindow()) != null && (nextWindow = fileEditorManager.getNextWindow(current)) != null) {
            nextWindow.setAsCurrentWindow(true);
        }
    }

    public void selectPreviousWindow(@NotNull ExecutionContext context) {
        EditorWindow prevWindow;
        FileEditorManagerEx fileEditorManager;
        EditorWindow current;
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(4);
        }
        if ((current = (fileEditorManager = WindowGroup.getFileEditorManager((DataContext)context.getContext())).getCurrentWindow()) != null && (prevWindow = fileEditorManager.getPrevWindow(current)) != null) {
            prevWindow.setAsCurrentWindow(true);
        }
    }

    public void selectWindow(@NotNull ExecutionContext context, int index) {
        FileEditorManagerEx fileEditorManager;
        EditorWindow[] windows;
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(5);
        }
        if (index - 1 < (windows = (fileEditorManager = WindowGroup.getFileEditorManager((DataContext)context.getContext())).getWindows()).length) {
            windows[index - 1].setAsCurrentWindow(true);
        }
    }

    public void splitWindowHorizontal(@NotNull ExecutionContext context, @NotNull String filename) {
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(6);
        }
        if (filename == null) {
            WindowGroup.$$$reportNull$$$0(7);
        }
        this.splitWindow(0, (DataContext)context.getContext(), filename);
    }

    public void splitWindowVertical(@NotNull ExecutionContext context, @NotNull String filename) {
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(8);
        }
        if (filename == null) {
            WindowGroup.$$$reportNull$$$0(9);
        }
        this.splitWindow(1, (DataContext)context.getContext(), filename);
    }

    @VimLockLabel.RequiresReadLock
    @RequiresReadLock
    public void selectWindowInRow(@NotNull VimCaret caret, @NotNull ExecutionContext context, int relativePosition, boolean vertical) {
        if (caret == null) {
            WindowGroup.$$$reportNull$$$0(10);
        }
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(11);
        }
        Caret ijCaret = ((IjVimCaret)caret).getCaret();
        FileEditorManagerEx fileEditorManager = WindowGroup.getFileEditorManager((DataContext)context.getContext());
        EditorWindow currentWindow = fileEditorManager.getCurrentWindow();
        if (currentWindow != null) {
            EditorWindow[] windows = fileEditorManager.getWindows();
            List<EditorWindow> row = WindowGroup.findWindowsInRow(ijCaret, currentWindow, Arrays.asList(windows), vertical);
            this.selectWindow(currentWindow, row, relativePosition);
        }
    }

    private void selectWindow(@NotNull EditorWindow currentWindow, @NotNull List<EditorWindow> windows, int relativePosition) {
        if (currentWindow == null) {
            WindowGroup.$$$reportNull$$$0(12);
        }
        if (windows == null) {
            WindowGroup.$$$reportNull$$$0(13);
        }
        int pos = windows.indexOf(currentWindow);
        int selected = pos + relativePosition;
        int normalized = Math.max(0, Math.min(selected, windows.size() - 1));
        windows.get(normalized).setAsCurrentWindow(true);
    }

    @NotNull
    private static List<EditorWindow> findWindowsInRow(@NotNull Caret caret, @NotNull EditorWindow editorWindow, @NotNull List<EditorWindow> windows, boolean vertical) {
        Point anchorPoint;
        if (caret == null) {
            WindowGroup.$$$reportNull$$$0(14);
        }
        if (editorWindow == null) {
            WindowGroup.$$$reportNull$$$0(15);
        }
        if (windows == null) {
            WindowGroup.$$$reportNull$$$0(16);
        }
        if ((anchorPoint = WindowGroup.getCaretPoint(caret)) != null) {
            ArrayList<EditorWindow> result = new ArrayList<EditorWindow>();
            double coord = vertical ? anchorPoint.getX() : anchorPoint.getY();
            for (EditorWindow window : windows) {
                Rectangle rect = WindowGroup.getSplitRectangle(window);
                if (rect == null) continue;
                double min = vertical ? rect.getX() : rect.getY();
                double max = min + (vertical ? rect.getWidth() : rect.getHeight());
                if (!(coord >= min) || !(coord <= max)) continue;
                result.add(window);
            }
            result.sort((window1, window2) -> {
                Rectangle rect1 = WindowGroup.getSplitRectangle(window1);
                Rectangle rect2 = WindowGroup.getSplitRectangle(window2);
                if (rect1 != null && rect2 != null) {
                    double diff;
                    double d = diff = vertical ? rect1.getY() - rect2.getY() : rect1.getX() - rect2.getX();
                    return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
                }
                return 0;
            });
            ArrayList<EditorWindow> arrayList = result;
            if (arrayList == null) {
                WindowGroup.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        List<EditorWindow> list = Collections.singletonList(editorWindow);
        if (list == null) {
            WindowGroup.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static FileEditorManagerEx getFileEditorManager(@NotNull DataContext context) {
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(19);
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)Objects.requireNonNull(project));
        if (fileEditorManagerEx == null) {
            WindowGroup.$$$reportNull$$$0(20);
        }
        return fileEditorManagerEx;
    }

    private void splitWindow(int orientation, @NotNull DataContext context, @NotNull String filename) {
        Project project;
        if (context == null) {
            WindowGroup.$$$reportNull$$$0(21);
        }
        if (filename == null) {
            WindowGroup.$$$reportNull$$$0(22);
        }
        if ((project = (Project)PlatformDataKeys.PROJECT.getData(context)) == null) {
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)project);
        VirtualFile virtualFile = null;
        if (filename.length() > 0 && (virtualFile = VimPlugin.getFile().findFile(filename, project)) == null) {
            VimPlugin.showMessage(MessageHelper.message("could.not.find.file.0", filename));
            return;
        }
        EditorWindow editorWindow = fileEditorManager.getSplitters().getCurrentWindow();
        if (editorWindow != null) {
            editorWindow.split(orientation, true, virtualFile, true);
        }
    }

    @NotNull
    private static Point getCaretPoint(@NotNull Caret caret) {
        if (caret == null) {
            WindowGroup.$$$reportNull$$$0(23);
        }
        Editor editor = caret.getEditor();
        Point caretLocation = editor.logicalPositionToXY(caret.getLogicalPosition());
        Point caretScreenLocation = editor.getContentComponent().getLocationOnScreen();
        caretScreenLocation.translate(caretLocation.x, caretLocation.y);
        Point point = caretScreenLocation;
        if (point == null) {
            WindowGroup.$$$reportNull$$$0(24);
        }
        return point;
    }

    @Nullable
    private static Rectangle getSplitRectangle(@NotNull EditorWindow window) {
        EditorComposite editorComposite;
        if (window == null) {
            WindowGroup.$$$reportNull$$$0(25);
        }
        if ((editorComposite = window.getSelectedComposite()) != null) {
            EditorTabbedContainer split = window.getTabbedPane();
            Point point = split.getComponent().getLocationOnScreen();
            Dimension dimension = split.getComponent().getSize();
            return new Rectangle(point, dimension);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 20, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 10: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentWindow";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windows";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorWindow";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/group/WindowGroup";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/group/WindowGroup";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findWindowsInRow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorManager";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "closeCurrentWindow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "closeAllExceptCurrent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "closeAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectNextWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectPreviousWindow";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectWindow";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitWindowHorizontal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "splitWindowVertical";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectWindowInRow";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findWindowsInRow";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 24: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileEditorManager";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "splitWindow";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCaretPoint";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSplitRectangle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 20, 24 -> new IllegalStateException(string);
        };
    }
}

