/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.formatting.LineWrappingUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimActionExecutor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.handler.StartNewLineDetectorBase;
import com.maddyhome.idea.vim.handler.VimEnterHandlerKt;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.IjActionExecutor;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH&J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0012\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/handler/OctopusHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "nextHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "executeHandler", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isHandlerEnabled", "", "doExecute", "executeInInvokeLater", "isThisHandlerEnabled", "isNotActualKeyPress", "isEnabledForCaret", "IdeaVIM"})
public abstract class OctopusHandler
extends EditorActionHandler {
    @Nullable
    private final EditorActionHandler nextHandler;

    public OctopusHandler(@Nullable EditorActionHandler nextHandler) {
        this.nextHandler = nextHandler;
    }

    public abstract void executeHandler(@NotNull Editor var1, @Nullable Caret var2, @Nullable DataContext var3);

    public boolean isHandlerEnabled(@NotNull Editor editor, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return true;
    }

    protected final void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        block2: {
            block0: {
                Function0 executionHandler;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    if (!this.isThisHandlerEnabled(editor, caret, dataContext)) break block0;
                    boolean executeInInvokeLater = this.executeInInvokeLater(editor);
                    executionHandler = () -> OctopusHandler.doExecute$lambda$0(dataContext, this, editor, caret);
                    if (!executeInInvokeLater) break block1;
                    if (caret != null && !Intrinsics.areEqual((Object)caret, (Object)editor.getCaretModel().getPrimaryCaret())) break block2;
                    ApplicationManager.getApplication().invokeLater(() -> OctopusHandler.doExecute$lambda$1(executionHandler));
                    break block2;
                }
                executionHandler.invoke();
                break block2;
            }
            EditorActionHandler editorActionHandler = this.nextHandler;
            if (editorActionHandler == null) break block2;
            editorActionHandler.execute(editor, caret, dataContext);
        }
    }

    private final boolean executeInInvokeLater(Editor editor) {
        String fileName;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        String string = fileName = virtualFile != null ? virtualFile.getName() : null;
        if (Intrinsics.areEqual((Object)fileName, (Object)"Python Console.py") || Intrinsics.areEqual((Object)fileName, (Object)"Python Console")) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        CaretModelImpl caretModelImpl = caretModel instanceof CaretModelImpl ? (CaretModelImpl)caretModel : null;
        return caretModelImpl != null ? caretModelImpl.isIteratingOverCarets() : true;
    }

    private final boolean isThisHandlerEnabled(Editor editor, Caret caret, DataContext dataContext) {
        if (VimPlugin.isNotEnabled()) {
            return false;
        }
        if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
            return false;
        }
        if (!this.isHandlerEnabled(editor, dataContext)) {
            return false;
        }
        if (this.isNotActualKeyPress(dataContext)) {
            return false;
        }
        return VimEnterHandlerKt.getEnableOctopus();
    }

    private final boolean isNotActualKeyPress(DataContext dataContext) {
        if (dataContext != null) {
            DataManager dataManager = DataManager.getInstance();
            if (Intrinsics.areEqual((Object)dataManager.loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY), (Object)true)) {
                return true;
            }
            Boolean wrapLongLineDuringFormattingInProgress = (Boolean)dataManager.loadFromDataContext(dataContext, LineWrappingUtil.WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY);
            if (Intrinsics.areEqual((Object)wrapLongLineDuringFormattingInProgress, (Object)true)) {
                return true;
            }
            Boolean splitLineInProgress = (Boolean)dataManager.loadFromDataContext(dataContext, SplitLineAction.SPLIT_LINE_KEY);
            if (Intrinsics.areEqual((Object)splitLineInProgress, (Object)true)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)dataManager.loadFromDataContext(dataContext, StartNewLineDetectorBase.Util.INSTANCE.getKey()), (Object)true)) {
                return true;
            }
        }
        DataContext dataContext2 = dataContext;
        boolean bl = dataContext2 != null ? IjEditorExecutionContextKt.getActionStartedFromVim(dataContext2) : false;
        if (bl) {
            return true;
        }
        VimActionExecutor vimActionExecutor = VimInjectorKt.getInjector().getActionExecutor();
        IjActionExecutor ijActionExecutor = vimActionExecutor instanceof IjActionExecutor ? (IjActionExecutor)vimActionExecutor : null;
        return ijActionExecutor != null ? ijActionExecutor.isRunningActionFromVim() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (this.isThisHandlerEnabled(editor, caret, dataContext)) return true;
        EditorActionHandler editorActionHandler = this.nextHandler;
        if (editorActionHandler == null) return false;
        if (!editorActionHandler.isEnabled(editor, caret, dataContext)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit doExecute$lambda$0(DataContext $dataContext, OctopusHandler this$0, Editor $editor, Caret $caret) {
        try {
            UserDataHolder userDataHolder = $dataContext instanceof UserDataHolder ? (UserDataHolder)$dataContext : null;
            if (userDataHolder != null) {
                userDataHolder.putUserData(VimEnterHandlerKt.getCommandContinuation(), (Object)this$0.nextHandler);
            }
            this$0.executeHandler($editor, $caret, $dataContext);
        }
        catch (Throwable throwable) {
            UserDataHolder userDataHolder = $dataContext instanceof UserDataHolder ? (UserDataHolder)$dataContext : null;
            if (userDataHolder != null) {
                EditorActionHandler cfr_ignored_0 = (EditorActionHandler)RemoveUserDataKt.removeUserData((UserDataHolder)userDataHolder, VimEnterHandlerKt.getCommandContinuation());
            }
            throw throwable;
        }
        UserDataHolder userDataHolder = $dataContext instanceof UserDataHolder ? (UserDataHolder)$dataContext : null;
        if (userDataHolder != null) {
            EditorActionHandler cfr_ignored_1 = (EditorActionHandler)RemoveUserDataKt.removeUserData((UserDataHolder)userDataHolder, VimEnterHandlerKt.getCommandContinuation());
        }
        return Unit.INSTANCE;
    }

    private static final void doExecute$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

