/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.SpellCheckerSeveritiesProvider;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"shouldIgnoreCase", "", "pattern", "", "ignoreSmartCaseOption", "containsUpperCase", "findMisspelledWords", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "endOffset", "skipCount", "offsetOrdering", "Lit/unimi/dsi/fastutil/ints/IntComparator;", "skip", "", "iterator", "Lit/unimi/dsi/fastutil/ints/IntIterator;", "n", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nSearchHelperKt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchHelperKt.kt\ncom/maddyhome/idea/vim/helper/SearchHelperKtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class SearchHelperKtKt {
    public static final boolean shouldIgnoreCase(@NotNull String pattern, boolean ignoreSmartCaseOption) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        boolean sc = VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getSmartcase() && !ignoreSmartCaseOption;
        return VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getIgnorecase() && (!sc || !SearchHelperKtKt.containsUpperCase(pattern));
    }

    private static final boolean containsUpperCase(String pattern) {
        int n = ((CharSequence)pattern).length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isUpperCase(pattern.charAt(i)) || i != 0 && pattern.charAt(i - 1) == '\\') continue;
            return true;
        }
        return false;
    }

    public static final int findMisspelledWords(@NotNull Editor editor, int startOffset, int endOffset, int skipCount, @Nullable IntComparator offsetOrdering) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return -1;
        }
        Project project2 = project;
        IntSortedSet offsets = (IntSortedSet)new IntRBTreeSet((Comparator)offsetOrdering);
        DaemonCodeAnalyzerEx.processHighlights((Document)editor.getDocument(), (Project)project2, (HighlightSeverity)SpellCheckerSeveritiesProvider.TYPO, (int)startOffset, (int)endOffset, arg_0 -> SearchHelperKtKt.findMisspelledWords$lambda$1(arg_0 -> SearchHelperKtKt.findMisspelledWords$lambda$0(startOffset, endOffset, offsets, arg_0), arg_0));
        if (offsets.isEmpty()) {
            return -1;
        }
        if (skipCount >= offsets.size()) {
            return offsets.lastInt();
        }
        IntBidirectionalIterator intBidirectionalIterator = offsets.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intBidirectionalIterator, (String)"iterator(...)");
        IntIterator offsetIterator = (IntIterator)intBidirectionalIterator;
        SearchHelperKtKt.skip(offsetIterator, skipCount);
        return offsetIterator.nextInt();
    }

    private static final void skip(IntIterator iterator, int n) {
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Argument must be nonnegative: " + n;
            throw new IllegalArgumentException(string.toString());
        }
        int i = n;
        while (i-- != 0 && iterator.hasNext()) {
            iterator.nextInt();
        }
    }

    private static final boolean findMisspelledWords$lambda$0(int $startOffset, int $endOffset, IntSortedSet $offsets, HighlightInfo highlight) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
        if (highlight.getSeverity() == SpellCheckerSeveritiesProvider.TYPO && (offset = highlight.getStartOffset()) >= $startOffset && offset <= $endOffset) {
            $offsets.add(offset);
        }
        return true;
    }

    private static final boolean findMisspelledWords$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

