/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.Alias;
import com.maddyhome.idea.vim.extension.ExtensionBeanClass;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.commands.SetCommand;
import com.maddyhome.idea.vim.vimscript.parser.VimscriptParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/inspections/UsePlugSyntaxInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getGroupDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "buildPlugins", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nUsePlugSyntaxInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsePlugSyntaxInspection.kt\ncom/maddyhome/idea/vim/inspections/UsePlugSyntaxInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,85:1\n13472#2:86\n13473#2:92\n230#3:87\n231#3:91\n1104#4,3:88\n*S KotlinDebug\n*F\n+ 1 UsePlugSyntaxInspection.kt\ncom/maddyhome/idea/vim/inspections/UsePlugSyntaxInspection\n*L\n74#1:86\n74#1:92\n75#1:87\n75#1:91\n75#1:88,3\n*E\n"})
public final class UsePlugSyntaxInspection
extends LocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        return "Vim";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!Intrinsics.areEqual((Object)file.getName(), (Object)".ideavimrc") && !Intrinsics.areEqual((Object)file.getName(), (Object)"_ideavimrc")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        HashMap<String, String> plugins = this.buildPlugins();
        return new PsiElementVisitor(plugins, holder, file){
            final /* synthetic */ HashMap<String, String> $plugins;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PsiFile $file;
            {
                this.$plugins = $plugins;
                this.$holder = $holder;
                this.$file = $file;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof LeafPsiElement)) {
                    return;
                }
                String string = ((LeafPsiElement)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Script myScript = VimscriptParser.INSTANCE.parse(string);
                Iterable iterable = myScript.getUnits();
                HashMap<String, String> hashMap = this.$plugins;
                ProblemsHolder problemsHolder = this.$holder;
                PsiFile psiFile = this.$file;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void it;
                    String argument;
                    String alias;
                    Executable unit = (Executable)element$iv;
                    boolean bl = false;
                    if (!(unit instanceof SetCommand) || (alias = hashMap.get(argument = ((SetCommand)unit).getArgument())) == null) continue;
                    TextRange textRange = ((SetCommand)unit).getRangeInScript();
                    PsiElement psiElement = element;
                    ProblemsHolder problemsHolder2 = problemsHolder;
                    boolean bl2 = false;
                    com.intellij.openapi.util.TextRange textRange2 = new com.intellij.openapi.util.TextRange(it.getStartOffset(), it.getEndOffset() - 1);
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new LocalQuickFix(psiFile, unit, alias){
                        final /* synthetic */ PsiFile $file;
                        final /* synthetic */ Executable $unit;
                        final /* synthetic */ String $alias;
                        {
                            this.$file = $file;
                            this.$unit = $unit;
                            this.$alias = $alias;
                        }

                        public String getFamilyName() {
                            return "Use Plug syntax";
                        }

                        public void applyFix(Project p0, ProblemDescriptor p1) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                Editor editor = PsiEditorUtil.findEditor((PsiElement)((PsiElement)this.$file));
                                Editor editor2 = editor;
                                if (editor2 == null || (editor2 = editor2.getDocument()) == null) break block0;
                                editor2.replaceString(((SetCommand)this.$unit).getRangeInScript().getStartOffset(), ((SetCommand)this.$unit).getRangeInScript().getEndOffset() - 1, (CharSequence)("Plug '" + this.$alias + "'"));
                            }
                        }
                    }};
                    problemsHolder2.registerProblem(psiElement, textRange2, "Use `Plug` syntax for defining extensions", localQuickFixArray);
                }
            }
        };
    }

    private final HashMap<String, String> buildPlugins() {
        HashMap<String, String> res = new HashMap<String, String>();
        Object[] $this$forEach$iv = VimExtension.EP_NAME.getExtensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ExtensionBeanClass extension;
            block10: {
                Object object2;
                block9: {
                    Object element$iv22;
                    block8: {
                        extension = (ExtensionBeanClass)((Object)element$iv);
                        boolean bl = false;
                        object = extension.getAliases();
                        if (object == null) break block9;
                        Iterable $this$first$iv = (Iterable)object;
                        boolean $i$f$first = false;
                        for (Object element$iv22 : $this$first$iv) {
                            boolean bl2;
                            Alias it = (Alias)element$iv22;
                            boolean bl3 = false;
                            String string = it.getName();
                            if (string != null) {
                                CharSequence $this$count$iv = string;
                                boolean $i$f$count = false;
                                int count$iv = 0;
                                for (int i = 0; i < $this$count$iv.length(); ++i) {
                                    char element$iv3;
                                    char it2 = element$iv3 = $this$count$iv.charAt(i);
                                    boolean bl4 = false;
                                    if (!(it2 == '/')) continue;
                                    ++count$iv;
                                }
                                bl2 = count$iv == 1;
                            } else {
                                bl2 = false;
                            }
                            if (!bl2) continue;
                            break block8;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    object = (Alias)element$iv22;
                    if (object != null && (object = ((Alias)object).getName()) != null) break block10;
                }
                object = (object2 = extension.getAliases()) != null && (object2 = (Alias)CollectionsKt.firstOrNull(object2)) != null ? ((Alias)object2).getName() : null;
            }
            List<Alias> alias = object;
            String name = extension.getName();
            if (alias == null || name == null) continue;
            ((Map)res).put(name, alias);
        }
        return res;
    }
}

