/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.mark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.mark.Mark;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/mark/IntellijMark;", "Lcom/maddyhome/idea/vim/mark/Mark;", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "col", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/ide/bookmark/LineBookmark;ILcom/intellij/openapi/project/Project;)V", "getCol", "()I", "Ljava/lang/ref/WeakReference;", "key", "", "getKey", "()C", "line", "getLine", "filepath", "", "getFilepath", "()Ljava/lang/String;", "protocol", "getProtocol", "clear", "", "getMark", "getProject", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nIntellijMark.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijMark.kt\ncom/maddyhome/idea/vim/mark/IntellijMark\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class IntellijMark
implements Mark {
    private final int col;
    @NotNull
    private final WeakReference<Project> project;
    private final char key;

    public IntellijMark(@NotNull LineBookmark bookmark, int col, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.col = col;
        this.project = new WeakReference<Project>(project);
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)project);
        this.key = (char)(bookmarksManager != null && (bookmarksManager = bookmarksManager.getType((Bookmark)bookmark)) != null ? (int)bookmarksManager.getMnemonic() : 32);
    }

    public int getCol() {
        return this.col;
    }

    public char getKey() {
        return this.key;
    }

    public int getLine() {
        LineBookmark lineBookmark = this.getMark();
        return lineBookmark != null ? lineBookmark.getLine() : 0;
    }

    @NotNull
    public String getFilepath() {
        Object object = this.getMark();
        if (object == null || (object = object.getFile()) == null || (object = object.getPath()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public String getProtocol() {
        Object object = this.getMark();
        if (object == null || (object = object.getFile()) == null || (object = object.getFileSystem()) == null || (object = object.getProtocol()) == null) {
            object = "";
        }
        return object;
    }

    public final void clear() {
        block2: {
            LineBookmark lineBookmark = this.getMark();
            if (lineBookmark == null) {
                return;
            }
            LineBookmark mark = lineBookmark;
            Project project = this.getProject();
            if (project == null) break block2;
            Project project2 = project;
            boolean bl = false;
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)project2);
            if (bookmarksManager != null) {
                bookmarksManager.remove((Bookmark)mark);
            }
        }
    }

    private final LineBookmark getMark() {
        LineBookmark lineBookmark;
        Project project = this.getProject();
        if (project != null) {
            Bookmark bookmark;
            Project project2 = project;
            boolean bl = false;
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)project2);
            Bookmark bookmark2 = bookmark = bookmarksManager != null ? bookmarksManager.getBookmark(BookmarkType.Companion.get(this.getKey())) : null;
            lineBookmark = bookmark instanceof LineBookmark ? (LineBookmark)bookmark : null;
        } else {
            lineBookmark = null;
        }
        return lineBookmark;
    }

    private final Project getProject() {
        Project project = (Project)this.project.get();
        if (project == null) {
            return null;
        }
        Project proj = project;
        if (proj.isDisposed()) {
            return null;
        }
        return proj;
    }

    public int offset(@NotNull VimEditor editor) {
        return super.offset(editor);
    }
}

