/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.CaretRegisterStorage;
import com.maddyhome.idea.vim.api.CaretRegisterStorageBase;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LocalMarkStorage;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretBase;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.InsertSequence;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.newapi.IjLiveRangeKt;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010#\u001a\u00020$H\u0016J\b\u0010,\u001a\u00020$H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u001cH\u0016J\b\u0010=\u001a\u000206H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001cH\u0016J\b\u0010B\u001a\u00020;H\u0016J\b\u0010C\u001a\u00020DH\u0016J\u0010\u0010M\u001a\u00020$2\u0006\u0010:\u001a\u00020DH\u0016J\u0010\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020\u001cH\u0016J\u0018\u0010P\u001a\u00020$2\u0006\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020\u001cH\u0016J\b\u0010S\u001a\u00020$H\u0016J\u0017\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020WH\u0000\u00a2\u0006\u0002\bXJ\u001d\u0010Y\u001a\u00020$2\u0006\u0010Z\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020WH\u0000\u00a2\u0006\u0002\b\\J\u001d\u0010]\u001a\u00020$2\u0006\u0010^\u001a\u00020\u001c2\u0006\u0010_\u001a\u00020WH\u0000\u00a2\u0006\u0002\b`J\r\u0010a\u001a\u00020$H\u0000\u00a2\u0006\u0002\bbJ\u0013\u0010c\u001a\u0002062\b\u0010d\u001a\u0004\u0018\u00010eH\u0096\u0002J\b\u0010f\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"R\u0014\u0010%\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u0014\u0010'\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001eR$\u0010)\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u001e\"\u0004\b+\u0010\"R(\u0010.\u001a\u0004\u0018\u00010-2\b\u0010\u0010\u001a\u0004\u0018\u00010-8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001eR\u0014\u00105\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00107R\u0014\u0010>\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u00107R\u0014\u0010E\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001eR$\u0010H\u001a\u00020G2\u0006\u0010\u0010\u001a\u00020G8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010J\"\u0004\bK\u0010L\u00a8\u0006g"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimCaret;", "Lcom/maddyhome/idea/vim/api/VimCaretBase;", "caret", "Lcom/intellij/openapi/editor/Caret;", "<init>", "(Lcom/intellij/openapi/editor/Caret;)V", "getCaret", "()Lcom/intellij/openapi/editor/Caret;", "registerStorage", "Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "getRegisterStorage", "()Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "markStorage", "Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "getMarkStorage", "()Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "value", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "lastSelectionInfo", "getLastSelectionInfo", "()Lcom/maddyhome/idea/vim/api/SelectionInfo;", "setLastSelectionInfo", "(Lcom/maddyhome/idea/vim/api/SelectionInfo;)V", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "offset", "", "getOffset", "()I", "vimLastColumn", "getVimLastColumn", "setVimLastColumn", "(I)V", "resetLastColumn", "", "selectionStart", "getSelectionStart", "selectionEnd", "getSelectionEnd", "vimSelectionStart", "getVimSelectionStart", "setVimSelectionStart", "vimSelectionStartClear", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "vimLastVisualOperatorRange", "getVimLastVisualOperatorRange", "()Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "setVimLastVisualOperatorRange", "(Lcom/maddyhome/idea/vim/group/visual/VisualChange;)V", "vimLine", "getVimLine", "isPrimary", "", "()Z", "moveToOffsetNative", "moveToBufferPosition", "position", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "getLine", "hasSelection", "isValid", "moveToInlayAwareOffset", "Lcom/maddyhome/idea/vim/api/VimCaret;", "newOffset", "getBufferPosition", "getVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "visualLineStart", "getVisualLineStart", "Lcom/maddyhome/idea/vim/common/LiveRange;", "vimInsertStart", "getVimInsertStart", "()Lcom/maddyhome/idea/vim/common/LiveRange;", "setVimInsertStart", "(Lcom/maddyhome/idea/vim/common/LiveRange;)V", "moveToVisualPosition", "setVimLastColumnAndGetCaret", "col", "setSelection", "start", "end", "removeSelection", "getInsertSequenceForTime", "Lcom/maddyhome/idea/vim/common/InsertSequence;", "time", "", "getInsertSequenceForTime$IdeaVIM", "startInsertSequence", "startOffset", "startNanoTime", "startInsertSequence$IdeaVIM", "endInsertSequence", "endInsert", "endNanoTime", "endInsertSequence$IdeaVIM", "abandonCurrentInsertSequece", "abandonCurrentInsertSequece$IdeaVIM", "equals", "other", "", "hashCode", "IdeaVIM"})
public final class IjVimCaret
extends VimCaretBase {
    @NotNull
    private final Caret caret;

    public IjVimCaret(@NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.caret = caret;
    }

    @NotNull
    public final Caret getCaret() {
        return this.caret;
    }

    @NotNull
    public CaretRegisterStorage getRegisterStorage() {
        CaretRegisterStorageBase storage = UserDataManager.getRegisterStorage(this.caret);
        if (storage == null) {
            IjVimInjectorKt.initInjector();
            storage = new CaretRegisterStorageBase((ImmutableVimCaret)this);
            UserDataManager.setRegisterStorage(this.caret, storage);
        } else if (!Intrinsics.areEqual((Object)storage.getCaret(), (Object)((Object)this))) {
            storage.setCaret((ImmutableVimCaret)this);
        }
        return (CaretRegisterStorage)storage;
    }

    @NotNull
    public LocalMarkStorage getMarkStorage() {
        LocalMarkStorage storage = UserDataManager.getMarkStorage(this.caret);
        if (storage == null) {
            storage = new LocalMarkStorage((ImmutableVimCaret)this);
            UserDataManager.setMarkStorage(this.caret, storage);
        } else if (!Intrinsics.areEqual((Object)storage.getCaret(), (Object)((Object)this))) {
            storage.setCaret((ImmutableVimCaret)this);
        }
        return storage;
    }

    @NotNull
    public SelectionInfo getLastSelectionInfo() {
        SelectionInfo lastSelection = UserDataManager.getLastSelectionInfo(this.caret);
        if (lastSelection == null) {
            SelectionInfo defaultValue = new SelectionInfo(null, null, SelectionType.CHARACTER_WISE);
            UserDataManager.setLastSelectionInfo(this.caret, defaultValue);
            return defaultValue;
        }
        return lastSelection;
    }

    public void setLastSelectionInfo(@NotNull SelectionInfo value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        UserDataManager.setLastSelectionInfo(this.caret, value);
    }

    @NotNull
    public VimEditor getEditor() {
        Editor editor = this.caret.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        return (VimEditor)new IjVimEditor(editor);
    }

    public int getOffset() {
        return this.caret.getOffset();
    }

    public int getVimLastColumn() {
        return UserDataManager.getVimLastColumn(this.caret);
    }

    public void setVimLastColumn(int value) {
        UserDataManager.setVimLastColumn(this.caret, value);
    }

    public void resetLastColumn() {
        UserDataManager.resetVimLastColumn(this.caret);
    }

    public int getSelectionStart() {
        return this.caret.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.caret.getSelectionEnd();
    }

    public int getVimSelectionStart() {
        return UserDataManager.getVimSelectionStart(this.caret);
    }

    public void setVimSelectionStart(int value) {
        UserDataManager.setVimSelectionStart(this.caret, value);
    }

    public void vimSelectionStartClear() {
        UserDataManager.vimSelectionStartClear(this.caret);
    }

    @Nullable
    public VisualChange getVimLastVisualOperatorRange() {
        return UserDataManager.getVimLastVisualOperatorRange(this.caret);
    }

    public void setVimLastVisualOperatorRange(@Nullable VisualChange value) {
        UserDataManager.setVimLastVisualOperatorRange(this.caret, value);
    }

    public int getVimLine() {
        return EditorHelperRt.getVimLine(this.caret);
    }

    public boolean isPrimary() {
        return Intrinsics.areEqual((Object)IjVimCaretKt.getIj(this.getEditor().primaryCaret()), (Object)this.caret);
    }

    public void moveToOffsetNative(int offset) {
        this.caret.moveToOffset(offset);
    }

    public void moveToBufferPosition(@NotNull BufferPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.caret.moveToLogicalPosition(new LogicalPosition(position.getLine(), position.getColumn(), position.getLeansForward()));
    }

    public int getLine() {
        return this.caret.getLogicalPosition().line;
    }

    public boolean hasSelection() {
        return this.caret.hasSelection();
    }

    public boolean isValid() {
        return this.caret.isValid();
    }

    @NotNull
    public VimCaret moveToInlayAwareOffset(int newOffset) {
        InlayHelperKt.moveToInlayAwareOffset(this.caret, newOffset);
        return (VimCaret)this;
    }

    @NotNull
    public BufferPosition getBufferPosition() {
        LogicalPosition logicalPosition = this.caret.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        return new BufferPosition(logicalPosition2.line, logicalPosition2.column, logicalPosition2.leansForward);
    }

    @NotNull
    public VimVisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.caret.getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition visualPosition2 = visualPosition;
        return new VimVisualPosition(visualPosition2.line, visualPosition2.column, visualPosition2.leansRight);
    }

    public int getVisualLineStart() {
        return this.caret.getVisualLineStart();
    }

    @NotNull
    public LiveRange getVimInsertStart() {
        return IjLiveRangeKt.getVim(UserDataManager.getVimInsertStart(this.caret));
    }

    public void setVimInsertStart(@NotNull LiveRange value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        UserDataManager.setVimInsertStart(this.caret, IjLiveRangeKt.getIj(value));
    }

    public void moveToVisualPosition(@NotNull VimVisualPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.caret.moveToVisualPosition(new VisualPosition(position.getLine(), position.getColumn(), position.getLeansRight()));
    }

    @NotNull
    public VimCaret setVimLastColumnAndGetCaret(int col) {
        UserDataManager.setVimLastColumn(this.caret, col);
        return (VimCaret)this;
    }

    public void setSelection(int start2, int end) {
        this.caret.setSelection(start2, end);
    }

    public void removeSelection() {
        this.caret.removeSelection();
    }

    @Nullable
    public final InsertSequence getInsertSequenceForTime$IdeaVIM(long time) {
        List<InsertSequence> insertHistory = UserDataManager.getInsertHistory(this.caret);
        for (int i = CollectionsKt.getLastIndex(insertHistory); -1 < i; --i) {
            InsertSequence insertInfo = insertHistory.get(i);
            if (time > insertInfo.getEndNanoTime()) {
                return null;
            }
            if (time < insertInfo.getStartNanoTime()) continue;
            return insertInfo;
        }
        return null;
    }

    public final void startInsertSequence$IdeaVIM(int startOffset, long startNanoTime) {
        if (UserDataManager.getCurrentInsert(this.caret) != null) {
            return;
        }
        UserDataManager.setCurrentInsert(this.caret, new InsertSequence(startOffset, startNanoTime));
    }

    public final void endInsertSequence$IdeaVIM(int endInsert, long endNanoTime) {
        InsertSequence insertSequence = UserDataManager.getCurrentInsert(this.caret);
        if (insertSequence == null) {
            return;
        }
        InsertSequence currentInsert = insertSequence;
        currentInsert.setEndNanoTime(endNanoTime);
        currentInsert.setEndOffset(endInsert);
        UserDataManager.getInsertHistory(this.caret).add(currentInsert);
        UserDataManager.setCurrentInsert(this.caret, null);
    }

    public final void abandonCurrentInsertSequece$IdeaVIM() {
        UserDataManager.setCurrentInsert(this.caret, null);
    }

    public boolean equals(@Nullable Object other) {
        IjVimCaret ijVimCaret = other instanceof IjVimCaret ? (IjVimCaret)((Object)other) : null;
        return Intrinsics.areEqual((Object)this.caret, (Object)(ijVimCaret != null ? ijVimCaret.caret : null));
    }

    public int hashCode() {
        return this.caret.hashCode();
    }
}

