/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IJSwingUtilities;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.ui.ExPanelBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExOutputPanel
extends JBPanel<ExOutputPanel> {
    @NotNull
    private final Editor myEditor;
    @NotNull
    public final JLabel myLabel;
    @NotNull
    private final JTextArea myText;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final ComponentAdapter myAdapter;
    private int myLineHeight;
    @Nullable
    private JComponent myOldGlass;
    @Nullable
    private LayoutManager myOldLayout;
    private boolean myWasOpaque;
    public boolean myActive;
    private static final VimLogger LOG = VimInjectorKt.injector.getLogger(ExOutputPanel.class);

    private ExOutputPanel(@NotNull Editor editor) {
        if (editor == null) {
            ExOutputPanel.$$$reportNull$$$0(0);
        }
        this.myLabel = new JLabel("more");
        this.myText = new JTextArea();
        this.myScrollPane = new JBScrollPane((Component)this.myText, 20, 31);
        this.myLineHeight = 0;
        this.myOldGlass = null;
        this.myOldLayout = null;
        this.myWasOpaque = false;
        this.myActive = false;
        this.myEditor = editor;
        BorderLayout layout = new BorderLayout(0, 0);
        this.setLayout(layout);
        this.add(this.myScrollPane, "Center");
        this.add(this.myLabel, "South");
        this.myText.setEditable(false);
        this.myText.setLineWrap(true);
        this.myAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ExOutputPanel.this.positionPanel();
            }
        };
        MoreKeyListener moreKeyListener = new MoreKeyListener(this);
        this.addKeyListener(moreKeyListener);
        this.myText.addKeyListener(moreKeyListener);
        ClientProperty.putRecursive((JComponent)((Object)this), (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
        this.updateUI();
    }

    @Nullable
    public static ExOutputPanel getNullablePanel(@NotNull Editor editor) {
        if (editor == null) {
            ExOutputPanel.$$$reportNull$$$0(1);
        }
        return UserDataManager.getVimMorePanel(editor);
    }

    public static boolean isPanelActive(@NotNull Editor editor) {
        if (editor == null) {
            ExOutputPanel.$$$reportNull$$$0(2);
        }
        return ExOutputPanel.getNullablePanel(editor) != null;
    }

    @NotNull
    public static ExOutputPanel getInstance(@NotNull Editor editor) {
        ExOutputPanel panel2;
        if (editor == null) {
            ExOutputPanel.$$$reportNull$$$0(3);
        }
        if ((panel2 = ExOutputPanel.getNullablePanel(editor)) == null) {
            panel2 = new ExOutputPanel(editor);
            UserDataManager.setVimMorePanel(editor, panel2);
        }
        ExOutputPanel exOutputPanel = panel2;
        if (exOutputPanel == null) {
            ExOutputPanel.$$$reportNull$$$0(4);
        }
        return exOutputPanel;
    }

    private static int countLines(@NotNull String text) {
        if (text == null) {
            ExOutputPanel.$$$reportNull$$$0(5);
        }
        if (text.isEmpty()) {
            return 0;
        }
        int count = 0;
        int pos = -1;
        while ((pos = text.indexOf(10, pos + 1)) != -1) {
            ++count;
        }
        if (text.charAt(text.length() - 1) != '\n') {
            ++count;
        }
        return count;
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)((Object)new ExPanelBorder()));
        if (this.myText != null && this.myLabel != null && this.myScrollPane != null) {
            this.setFontForElements();
            this.myText.setBorder(null);
            this.myScrollPane.setBorder(null);
            this.myLabel.setForeground(this.myText.getForeground());
            this.positionPanel();
        }
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String data) {
        if (data == null) {
            ExOutputPanel.$$$reportNull$$$0(6);
        }
        if (!data.isEmpty() && data.charAt(data.length() - 1) == '\n') {
            data = data.substring(0, data.length() - 1);
        }
        this.myText.setText(data);
        this.myText.setFont(UiHelper.selectEditorFont(this.myEditor, data));
        this.myText.setCaretPosition(0);
        if (!data.isEmpty()) {
            this.activate();
        }
    }

    public String getText() {
        return this.myText.getText();
    }

    public Color getForeground() {
        return this.myText != null ? this.myText.getForeground() : super.getForeground();
    }

    public Color getBackground() {
        return this.myText != null ? this.myText.getBackground() : super.getBackground();
    }

    public void deactivate(boolean refocusOwningEditor) {
        if (!this.myActive) {
            return;
        }
        this.myActive = false;
        this.myText.setText("");
        if (refocusOwningEditor) {
            UiHelper.requestFocus(this.myEditor.getContentComponent());
        }
        if (this.myOldGlass != null) {
            this.myOldGlass.removeComponentListener(this.myAdapter);
            this.myOldGlass.setVisible(false);
            this.myOldGlass.remove((Component)((Object)this));
            this.myOldGlass.setOpaque(this.myWasOpaque);
            this.myOldGlass.setLayout(this.myOldLayout);
        }
    }

    public void activate() {
        JRootPane root = SwingUtilities.getRootPane(this.myEditor.getContentComponent());
        this.myOldGlass = (JComponent)root.getGlassPane();
        if (this.myOldGlass != null) {
            this.myOldLayout = this.myOldGlass.getLayout();
            this.myWasOpaque = this.myOldGlass.isOpaque();
            this.myOldGlass.setLayout(null);
            this.myOldGlass.setOpaque(false);
            this.myOldGlass.add((Component)((Object)this));
            this.myOldGlass.addComponentListener(this.myAdapter);
        }
        this.setFontForElements();
        this.positionPanel();
        if (this.myOldGlass != null) {
            this.myOldGlass.setVisible(true);
        }
        this.myActive = true;
        UiHelper.requestFocus(this.myText);
    }

    private void setFontForElements() {
        this.myText.setFont(UiHelper.selectEditorFont(this.myEditor, this.myText.getText()));
        this.myLabel.setFont(UiHelper.selectEditorFont(this.myEditor, this.myLabel.getText()));
    }

    public void scrollLine() {
        this.scrollOffset(this.myLineHeight);
    }

    public void scrollPage() {
        this.scrollOffset(this.myScrollPane.getVerticalScrollBar().getVisibleAmount());
    }

    public void scrollHalfPage() {
        double sa = (double)this.myScrollPane.getVerticalScrollBar().getVisibleAmount() / 2.0;
        double offset = Math.ceil(sa / (double)this.myLineHeight) * (double)this.myLineHeight;
        this.scrollOffset((int)offset);
    }

    public void onBadKey() {
        this.myLabel.setText(MessageHelper.message("more.ret.line.space.page.d.half.page.q.quit"));
        this.myLabel.setFont(UiHelper.selectEditorFont(this.myEditor, this.myLabel.getText()));
    }

    private void scrollOffset(int more) {
        int val = this.myScrollPane.getVerticalScrollBar().getValue();
        this.myScrollPane.getVerticalScrollBar().setValue(val + more);
        this.myScrollPane.getHorizontalScrollBar().setValue(0);
        if (val + more >= this.myScrollPane.getVerticalScrollBar().getMaximum() - this.myScrollPane.getVerticalScrollBar().getVisibleAmount()) {
            this.myLabel.setText(MessageHelper.message("hit.enter.or.type.command.to.continue"));
        } else {
            this.myLabel.setText(MessageHelper.message("ex.output.panel.more"));
        }
        this.myLabel.setFont(UiHelper.selectEditorFont(this.myEditor, this.myLabel.getText()));
    }

    public boolean isAtEnd() {
        int val = this.myScrollPane.getVerticalScrollBar().getValue();
        return val >= this.myScrollPane.getVerticalScrollBar().getMaximum() - this.myScrollPane.getVerticalScrollBar().getVisibleAmount();
    }

    private void positionPanel() {
        JComponent contentComponent = this.myEditor.getContentComponent();
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, contentComponent);
        JRootPane rootPane = SwingUtilities.getRootPane(contentComponent);
        if (scroll == null || rootPane == null) {
            return;
        }
        this.setSize(scroll.getSize());
        this.myLineHeight = this.myText.getFontMetrics(this.myText.getFont()).getHeight();
        int count = ExOutputPanel.countLines(this.myText.getText());
        int visLines = this.getSize().height / this.myLineHeight - 1;
        int lines = Math.min(count, visLines);
        this.setSize(this.getSize().width, lines * this.myLineHeight + this.myLabel.getPreferredSize().height + this.getBorder().getBorderInsets((Component)((Object)this)).top * 2);
        int height = this.getSize().height;
        Rectangle bounds = scroll.getBounds();
        bounds.translate(0, scroll.getHeight() - height);
        bounds.height = height;
        Point pos = SwingUtilities.convertPoint(scroll.getParent(), bounds.getLocation(), rootPane.getGlassPane());
        bounds.setLocation(pos);
        this.setBounds(bounds);
        this.myScrollPane.getVerticalScrollBar().setValue(0);
        if (!VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.injector).getMore()) {
            this.scrollOffset(100000);
        } else {
            this.scrollOffset(0);
        }
    }

    public void close() {
        this.close(null);
    }

    public void close(@Nullable KeyStroke key) {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.deactivate(true);
            Project project = this.myEditor.getProject();
            if (project != null && key != null && key.getKeyChar() != '\n') {
                ArrayList<KeyStroke> keys = new ArrayList<KeyStroke>(1);
                keys.add(key);
                if (LOG.isTrace()) {
                    LOG.trace("Adding new keys to keyStack as part of playback. State before adding keys: " + KeyHandler.getInstance().getKeyStack().dump());
                }
                KeyHandler.getInstance().getKeyStack().addKeys(keys);
                ExecutionContext context = VimInjectorKt.injector.getExecutionContextManager().getEditorExecutionContext((VimEditor)new IjVimEditor(this.myEditor));
                VimPlugin.getMacro().playbackKeys((VimEditor)new IjVimEditor(this.myEditor), context, 1);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/ui/ExOutputPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/ui/ExOutputPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNullablePanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPanelActive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "countLines";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class MoreKeyListener
    extends KeyAdapter {
        private final ExOutputPanel myExOutputPanel;

        public MoreKeyListener(ExOutputPanel panel2) {
            this.myExOutputPanel = panel2;
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            VimOutputPanel currentPanel;
            if (e == null) {
                MoreKeyListener.$$$reportNull$$$0(0);
            }
            if ((currentPanel = VimInjectorKt.injector.getOutputPanel().getCurrentOutputPanel()) == null) {
                return;
            }
            int keyCode = e.getKeyCode();
            Character keyChar = Character.valueOf(e.getKeyChar());
            int modifiers = e.getModifiersEx();
            KeyStroke keyStroke = keyChar.charValue() == '\uffff' ? KeyStroke.getKeyStroke(keyCode, modifiers) : KeyStroke.getKeyStroke(keyChar, modifiers);
            currentPanel.handleKey(keyStroke);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/vim/ui/ExOutputPanel$MoreKeyListener", "keyTyped"));
        }
    }

    public static class LafListener
    implements LafManagerListener {
        public void lookAndFeelChanged(@NotNull LafManager source) {
            if (source == null) {
                LafListener.$$$reportNull$$$0(0);
            }
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            for (VimEditor vimEditor : VimInjectorKt.injector.getEditorGroup().getEditors()) {
                Editor editor = ((IjVimEditor)vimEditor).getEditor();
                if (!ExOutputPanel.isPanelActive(editor)) continue;
                IJSwingUtilities.updateComponentTreeUI((Component)((Object)ExOutputPanel.getInstance(editor)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/maddyhome/idea/vim/ui/ExOutputPanel$LafListener", "lookAndFeelChanged"));
        }
    }
}

