/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.key.ShortcutOwner;
import com.maddyhome.idea.vim.key.ShortcutOwnerInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0005\u0015\u0016\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "<init>", "()V", "settingsPanel", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimSettingsPanel;", "getSettingsPanel", "()Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimSettingsPanel;", "settingsPanel$delegate", "Lkotlin/Lazy;", "getDisplayName", "", "getHelpTopic", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "reset", "disposeUIResources", "VimSettingsPanel", "VimShortcutConflictsTable", "CopyForRcAction", "ToggleAllHandlersAction", "ResetHandlersAction", "IdeaVIM"})
public final class VimEmulationConfigurable
implements Configurable {
    @NotNull
    private final Lazy settingsPanel$delegate = LazyKt.lazy(VimEmulationConfigurable::settingsPanel_delegate$lambda$0);

    private final VimSettingsPanel getSettingsPanel() {
        Lazy lazy = this.settingsPanel$delegate;
        return (VimSettingsPanel)lazy.getValue();
    }

    @NotNull
    public String getDisplayName() {
        return MessageHelper.message("configurable.name.vim.emulation");
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        return this.getSettingsPanel();
    }

    public boolean isModified() {
        return this.getSettingsPanel().getModel().isModified();
    }

    public void apply() {
        this.getSettingsPanel().getModel().apply();
    }

    public void reset() {
        this.getSettingsPanel().getModel().reset();
    }

    public void disposeUIResources() {
    }

    private static final VimSettingsPanel settingsPanel_delegate$lambda$0() {
        return new VimSettingsPanel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$CopyForRcAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myModel", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "<init>", "(Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "IdeaVIM"})
    private static final class CopyForRcAction
    extends DumbAwareAction {
        @NotNull
        private final VimShortcutConflictsTable.Model myModel;

        public CopyForRcAction(@NotNull VimShortcutConflictsTable.Model myModel) {
            Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
            super("Copy Config for .ideavimrc", "Copy config for .ideavimrc in sethandler format", AllIcons.Actions.Copy);
            this.myModel = myModel;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean enabled = this.myModel.getRows().stream().anyMatch(arg_0 -> CopyForRcAction.update$lambda$1(CopyForRcAction::update$lambda$0, arg_0));
            e.getPresentation().setEnabled(enabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            StringBuilder stringBuilder = new StringBuilder();
            for (VimShortcutConflictsTable.Row row : this.myModel.getRows()) {
                ShortcutOwnerInfo ownerInfo;
                ShortcutOwner owner;
                ShortcutOwnerInfo shortcutOwnerInfo = row.getOwner();
                ShortcutOwnerInfo.AllModes allModes = shortcutOwnerInfo instanceof ShortcutOwnerInfo.AllModes ? (ShortcutOwnerInfo.AllModes)shortcutOwnerInfo : null;
                if (allModes == null || (owner = ((ShortcutOwnerInfo.AllModes)(ownerInfo = (ShortcutOwnerInfo)allModes)).getOwner()) == ShortcutOwner.UNDEFINED) continue;
                stringBuilder.append("sethandler ");
                stringBuilder.append(VimInjectorKt.getInjector().getParser().toKeyNotation(row.getKeyStroke()));
                stringBuilder.append(" ");
                stringBuilder.append("a:");
                stringBuilder.append(owner.getOwnerName());
                stringBuilder.append("\n");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String data = string;
            VimInjectorKt.getInjector().getClipboardManager().setClipboardText(data, data, CollectionsKt.emptyList());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean update$lambda$0(VimShortcutConflictsTable.Row it) {
            if (!(it.getOwner() instanceof ShortcutOwnerInfo.AllModes)) return false;
            ShortcutOwnerInfo shortcutOwnerInfo = it.getOwner();
            Intrinsics.checkNotNull((Object)shortcutOwnerInfo, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.key.ShortcutOwnerInfo.AllModes");
            if (((ShortcutOwnerInfo.AllModes)shortcutOwnerInfo).getOwner() == ShortcutOwner.UNDEFINED) return false;
            return true;
        }

        private static final boolean update$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$ResetHandlersAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myModel", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "myTable", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable;", "<init>", "(Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "IdeaVIM"})
    public static final class ResetHandlersAction
    extends DumbAwareAction {
        @NotNull
        private final VimShortcutConflictsTable.Model myModel;
        @NotNull
        private final VimShortcutConflictsTable myTable;

        public ResetHandlersAction(@NotNull VimShortcutConflictsTable.Model myModel, @NotNull VimShortcutConflictsTable myTable) {
            Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
            Intrinsics.checkNotNullParameter((Object)((Object)myTable), (String)"myTable");
            super("Reset Handlers", "Reset handlers", AllIcons.General.Reset);
            this.myModel = myModel;
            this.myTable = myTable;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean enabled = this.myModel.getRows().stream().anyMatch(arg_0 -> ResetHandlersAction.update$lambda$1(ResetHandlersAction::update$lambda$0, arg_0));
            e.getPresentation().setEnabled(enabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TableUtil.stopEditing((JTable)((JTable)((Object)this.myTable)));
            for (VimShortcutConflictsTable.Row row : this.myModel.getRows()) {
                ShortcutOwnerInfo owner = row.getOwner();
                if (!(owner instanceof ShortcutOwnerInfo.AllModes) || ((ShortcutOwnerInfo.AllModes)owner).getOwner() == ShortcutOwner.UNDEFINED) continue;
                row.setOwner((ShortcutOwnerInfo)ShortcutOwnerInfo.allUndefined);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> ResetHandlersAction.actionPerformed$lambda$2(this));
            TableUtil.updateScroller((JTable)((JTable)((Object)this.myTable)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean update$lambda$0(VimShortcutConflictsTable.Row it) {
            if (!(it.getOwner() instanceof ShortcutOwnerInfo.AllModes)) return false;
            ShortcutOwnerInfo shortcutOwnerInfo = it.getOwner();
            Intrinsics.checkNotNull((Object)shortcutOwnerInfo, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.key.ShortcutOwnerInfo.AllModes");
            if (((ShortcutOwnerInfo.AllModes)shortcutOwnerInfo).getOwner() == ShortcutOwner.UNDEFINED) return false;
            return true;
        }

        private static final boolean update$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void actionPerformed$lambda$2(ResetHandlersAction this$0) {
            IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this$0.myTable), true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$ToggleAllHandlersAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myModel", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "myTable", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable;", "rowsToBeChangedOnToggleAllHandlers", "", "", "<init>", "(Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable;Ljava/util/List;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "IdeaVIM"})
    private static final class ToggleAllHandlersAction
    extends DumbAwareAction {
        @NotNull
        private final VimShortcutConflictsTable.Model myModel;
        @NotNull
        private final VimShortcutConflictsTable myTable;
        @NotNull
        private final List<Integer> rowsToBeChangedOnToggleAllHandlers;

        public ToggleAllHandlersAction(@NotNull VimShortcutConflictsTable.Model myModel, @NotNull VimShortcutConflictsTable myTable, @NotNull List<Integer> rowsToBeChangedOnToggleAllHandlers) {
            Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
            Intrinsics.checkNotNullParameter((Object)((Object)myTable), (String)"myTable");
            Intrinsics.checkNotNullParameter(rowsToBeChangedOnToggleAllHandlers, (String)"rowsToBeChangedOnToggleAllHandlers");
            super("Toggle all unset Handlers", "Toggle all action handlers to use either IDE or Vim shortcuts", AllIcons.Actions.ChangeView);
            this.myModel = myModel;
            this.myTable = myTable;
            this.rowsToBeChangedOnToggleAllHandlers = rowsToBeChangedOnToggleAllHandlers;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TableUtil.stopEditing((JTable)((JTable)((Object)this.myTable)));
            Iterator<Integer> iterator = this.rowsToBeChangedOnToggleAllHandlers.iterator();
            while (iterator.hasNext()) {
                VimShortcutConflictsTable.Row row;
                int rowIndex = ((Number)iterator.next()).intValue();
                ShortcutOwnerInfo shortcutOwnerInfo = (row = this.myModel.getRows().get(rowIndex)).getOwner();
                row.setOwner((ShortcutOwnerInfo)(Intrinsics.areEqual((Object)shortcutOwnerInfo, (Object)ShortcutOwnerInfo.allUndefined) ? ShortcutOwnerInfo.Companion.getAllVim() : (Intrinsics.areEqual((Object)shortcutOwnerInfo, (Object)ShortcutOwnerInfo.Companion.getAllVim()) ? ShortcutOwnerInfo.Companion.getAllIde() : ShortcutOwnerInfo.allUndefined)));
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> ToggleAllHandlersAction.actionPerformed$lambda$0(this));
            TableUtil.updateScroller((JTable)((JTable)((Object)this.myTable)));
        }

        private static final void actionPerformed$lambda$0(ToggleAllHandlersAction this$0) {
            IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this$0.myTable), true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimSettingsPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "model", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "getModel", "()Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "getRowsToBeToggled", "", "", "addHelpLine", "", "IdeaVIM"})
    private static final class VimSettingsPanel
    extends JPanel {
        @NotNull
        private final VimShortcutConflictsTable.Model model = new VimShortcutConflictsTable.Model();

        public VimSettingsPanel() {
            VimShortcutConflictsTable shortcutConflictsTable = new VimShortcutConflictsTable(this.model);
            List<Integer> rowsToBeChangedOnToggleAllHandlers = this.getRowsToBeToggled();
            this.setLayout(new BorderLayout());
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)((JTable)((Object)shortcutConflictsTable)));
            Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"createDecorator(...)");
            ToolbarDecorator decorator = toolbarDecorator;
            decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
            decorator.addExtraAction((AnAction)new CopyForRcAction(this.model));
            decorator.addExtraAction((AnAction)new ResetHandlersAction(this.model, shortcutConflictsTable));
            decorator.addExtraAction((AnAction)new ToggleAllHandlersAction(this.model, shortcutConflictsTable, rowsToBeChangedOnToggleAllHandlers));
            JPanel jPanel = decorator.createPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
            JPanel scrollPane = jPanel;
            scrollPane.setBorder(new LineBorder(JBColor.border()));
            JPanel conflictsPanel = new JPanel(new BorderLayout());
            String title = MessageHelper.message("border.title.shortcut.conflicts.for.active.keymap");
            conflictsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
            conflictsPanel.add(scrollPane);
            this.add((Component)conflictsPanel, "Center");
            this.addHelpLine(this.model);
        }

        @NotNull
        public final VimShortcutConflictsTable.Model getModel() {
            return this.model;
        }

        private final List<Integer> getRowsToBeToggled() {
            List rowsToChange = new ArrayList();
            int n = this.model.getRows().size();
            for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                VimShortcutConflictsTable.Row row = this.model.getRows().get(rowIndex);
                if (!(row.getOwner() instanceof ShortcutOwnerInfo.AllModes) || !Intrinsics.areEqual((Object)row.getOwner(), (Object)ShortcutOwnerInfo.allUndefined)) continue;
                rowsToChange.add(rowIndex);
            }
            return rowsToChange;
        }

        public final void addHelpLine(@NotNull VimShortcutConflictsTable.Model model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            VimShortcutConflictsTable.Row firstPerMode = (VimShortcutConflictsTable.Row)ContainerUtil.find((Iterable)model.getRows(), arg_0 -> VimSettingsPanel.addHelpLine$lambda$1(VimSettingsPanel::addHelpLine$lambda$0, arg_0));
            if (firstPerMode == null) {
                HyperlinkLabel label = new HyperlinkLabel();
                label.setHtmlText(MessageHelper.message("configurable.keyhandler.link"));
                label.setHyperlinkTarget("https://jb.gg/vim-sethandler");
                label.setForeground(UIUtil.getInactiveTextColor());
                this.add((Component)label, "South");
            } else {
                JBLabel helpLine = new JBLabel();
                Object[] objectArray = new Object[2];
                ShortcutOwnerInfo shortcutOwnerInfo = firstPerMode.getOwner();
                Intrinsics.checkNotNull((Object)shortcutOwnerInfo, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.key.ShortcutOwnerInfo.PerMode");
                objectArray[0] = ((ShortcutOwnerInfo.PerMode)shortcutOwnerInfo).toNotation();
                Intrinsics.checkNotNullExpressionValue((Object)KeymapUtil.getShortcutText((Shortcut)((Shortcut)new KeyboardShortcut(firstPerMode.getKeyStroke(), null))), (String)"getShortcutText(...)");
                helpLine.setText(MessageHelper.message("configurable.noneditablehandler.helper.text.with.example", objectArray));
                helpLine.setForeground(UIUtil.getInactiveTextColor());
                this.add((Component)helpLine, "South");
            }
        }

        private static final boolean addHelpLine$lambda$0(VimShortcutConflictsTable.Row row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            ShortcutOwnerInfo owner = row.getOwner();
            return owner instanceof ShortcutOwnerInfo.PerMode;
        }

        private static final boolean addHelpLine$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable;", "Lcom/intellij/openapi/ui/StripeTable;", "model", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "<init>", "(Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;)V", "renderer", "Lcom/intellij/openapi/ui/ComboBoxTableRenderer;", "Lcom/maddyhome/idea/vim/key/ShortcutOwner;", "getCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "row", "", "column", "getCellEditor", "Ljavax/swing/table/TableCellEditor;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "calcSize", "dimension", "getTableColumn", "Ljavax/swing/table/TableColumn;", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Column;", "ShortcutOwnerRenderer", "Column", "Row", "Model", "IdeaVIM"})
    public static final class VimShortcutConflictsTable
    extends StripeTable {
        @NotNull
        private final ComboBoxTableRenderer<ShortcutOwner> renderer;

        public VimShortcutConflictsTable(@NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            super((TableModel)model);
            this.renderer = new ShortcutOwnerRenderer();
            this.getTableColumn(Column.KEYSTROKE).setPreferredWidth(100);
            this.getTableColumn(Column.IDE_ACTION).setPreferredWidth(400);
            TableColumn ownerColumn = this.getTableColumn(Column.OWNER);
            ownerColumn.setPreferredWidth(150);
        }

        @NotNull
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer tableCellRenderer;
            if (column != Column.OWNER.getIndex()) {
                TableCellRenderer tableCellRenderer2 = super.getCellRenderer(row, column);
                Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer2, (String)"getCellRenderer(...)");
                return tableCellRenderer2;
            }
            TableModel tableModel = this.getModel();
            Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ui.VimEmulationConfigurable.VimShortcutConflictsTable.Model");
            Model model = (Model)tableModel;
            ShortcutOwnerInfo owner = model.getRows().get(row).getOwner();
            if (owner instanceof ShortcutOwnerInfo.PerMode) {
                TableCellRenderer tableCellRenderer3 = super.getCellRenderer(row, column);
                tableCellRenderer = tableCellRenderer3;
                Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer3, (String)"getCellRenderer(...)");
            } else {
                tableCellRenderer = (TableCellRenderer)this.renderer;
            }
            return tableCellRenderer;
        }

        @NotNull
        public TableCellEditor getCellEditor(int row, int column) {
            TableCellEditor tableCellEditor;
            if (column != Column.OWNER.getIndex()) {
                TableCellEditor tableCellEditor2 = super.getCellEditor(row, column);
                Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor2, (String)"getCellEditor(...)");
                return tableCellEditor2;
            }
            TableModel tableModel = this.getModel();
            Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ui.VimEmulationConfigurable.VimShortcutConflictsTable.Model");
            Model model = (Model)tableModel;
            ShortcutOwnerInfo owner = model.getRows().get(row).getOwner();
            if (owner instanceof ShortcutOwnerInfo.PerMode) {
                TableCellEditor tableCellEditor3 = super.getCellEditor(row, column);
                tableCellEditor = tableCellEditor3;
                Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor3, (String)"getCellEditor(...)");
            } else {
                tableCellEditor = (TableCellEditor)this.renderer;
            }
            return tableCellEditor;
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
            return this.calcSize(dimension);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            return this.calcSize(dimension);
        }

        private final Dimension calcSize(Dimension dimension) {
            Container container = this.getParent();
            if (container != null) {
                Dimension size = container.getSize();
                return new Dimension(size.width, dimension.height);
            }
            return dimension;
        }

        private final TableColumn getTableColumn(Column column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column.getIndex());
            Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"getColumn(...)");
            return tableColumn;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B*\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u00130\u0005\u00a2\u0006\u000e\b\u0006\u0012\n\b\u0007\u0012\u0006\b\n0\b8\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0004\u001a\u00130\u0005\u00a2\u0006\u000e\b\u0006\u0012\n\b\u0007\u0012\u0006\b\n0\b8\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Column;", "", "index", "", "title", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getIndex", "()I", "getTitle", "()Ljava/lang/String;", "KEYSTROKE", "IDE_ACTION", "OWNER", "Companion", "IdeaVIM"})
        private static final class Column
        extends Enum<Column> {
            @NotNull
            public static final Companion Companion;
            private final int index;
            @NotNull
            private final String title;
            @NotNull
            private static final Map<Integer, Column> ourMembers;
            public static final /* enum */ Column KEYSTROKE;
            public static final /* enum */ Column IDE_ACTION;
            public static final /* enum */ Column OWNER;
            private static final /* synthetic */ Column[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Column(int index, String title) {
                this.index = index;
                this.title = title;
            }

            public final int getIndex() {
                return this.index;
            }

            @NotNull
            public final String getTitle() {
                return this.title;
            }

            public static Column[] values() {
                return (Column[])$VALUES.clone();
            }

            public static Column valueOf(String value) {
                return Enum.valueOf(Column.class, value);
            }

            @NotNull
            public static EnumEntries<Column> getEntries() {
                return $ENTRIES;
            }

            static {
                KEYSTROKE = new Column(0, "Shortcut");
                IDE_ACTION = new Column(1, "IDE Action");
                OWNER = new Column(2, "Handler");
                $VALUES = columnArray = new Column[]{Column.KEYSTROKE, Column.IDE_ACTION, Column.OWNER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                ourMembers = new HashMap();
                for (Column column : Column.getEntries()) {
                    ourMembers.put(column.index, column);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Column$Companion;", "", "<init>", "()V", "ourMembers", "", "", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Column;", "fromIndex", "index", "IdeaVIM"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final Column fromIndex(int index) {
                    return (Column)((Object)ourMembers.get(index));
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Model;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "()V", "rows", "", "Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Row;", "getRows", "()Ljava/util/List;", "getRowCount", "", "getColumnCount", "getValueAt", "", "rowIndex", "columnIndex", "setValueAt", "", "object", "isCellEditable", "", "getColumnName", "", "index", "isModified", "()Z", "apply", "reset", "currentData", "", "Ljavax/swing/KeyStroke;", "Lcom/maddyhome/idea/vim/key/ShortcutOwnerInfo;", "getCurrentData", "()Ljava/util/Map;", "IdeaVIM"})
        public static final class Model
        extends AbstractTableModel {
            @NotNull
            private final List<Row> rows = new ArrayList();

            public Model() {
                this.reset();
            }

            @NotNull
            public final List<Row> getRows() {
                return this.rows;
            }

            @Override
            public int getRowCount() {
                return this.rows.size();
            }

            @Override
            public int getColumnCount() {
                return Column.getEntries().size();
            }

            @Override
            @Nullable
            public Object getValueAt(int rowIndex, int columnIndex) {
                Column column = Column.Companion.fromIndex(columnIndex);
                if (column != null && rowIndex >= 0 && rowIndex < this.rows.size()) {
                    Row row = this.rows.get(rowIndex);
                    Column column2 = column;
                    switch (WhenMappings.$EnumSwitchMapping$0[column2.ordinal()]) {
                        case 1: {
                            return KeymapUtil.getShortcutText((Shortcut)((Shortcut)new KeyboardShortcut(row.getKeyStroke(), null)));
                        }
                        case 2: {
                            return row.getAction().getTemplatePresentation().getText();
                        }
                        case 3: {
                            ShortcutOwnerInfo owner = row.getOwner();
                            if (owner instanceof ShortcutOwnerInfo.AllModes) {
                                return ((ShortcutOwnerInfo.AllModes)owner).getOwner();
                            }
                            if (!(owner instanceof ShortcutOwnerInfo.PerMode)) break;
                            return ((ShortcutOwnerInfo.PerMode)owner).toNotation();
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(@NotNull Object object, int rowIndex, int columnIndex) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                Column column = Column.Companion.fromIndex(columnIndex);
                if (column != null && rowIndex >= 0 && rowIndex < this.rows.size() && object instanceof ShortcutOwner) {
                    Row row = this.rows.get(rowIndex);
                    row.setOwner((ShortcutOwnerInfo)new ShortcutOwnerInfo.AllModes((ShortcutOwner)object));
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.rows.get(rowIndex).getOwner() instanceof ShortcutOwnerInfo.PerMode ? false : Column.Companion.fromIndex(columnIndex) == Column.OWNER;
            }

            @Override
            @Nullable
            public String getColumnName(int index) {
                Column column = Column.Companion.fromIndex(index);
                return column != null ? column.getTitle() : null;
            }

            public final boolean isModified() {
                return !Intrinsics.areEqual(VimPlugin.getKey().getShortcutConflicts(), this.getCurrentData());
            }

            public final void apply() {
                VimPlugin.getKey().getSavedShortcutConflicts().putAll(this.getCurrentData());
            }

            public final void reset() {
                this.rows.clear();
                Map<KeyStroke, ShortcutOwnerInfo> map = VimPlugin.getKey().getShortcutConflicts();
                Intrinsics.checkNotNullExpressionValue(map, (String)"<get-shortcutConflicts>(...)");
                for (Map.Entry<KeyStroke, ShortcutOwnerInfo> entry : map.entrySet()) {
                    ShortcutOwnerInfo value;
                    List<NativeAction> actions;
                    KeyStroke keyStroke;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"component1(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getValue(), (String)"component2(...)");
                    Intrinsics.checkNotNullExpressionValue(VimPlugin.getKey().getKeymapConflicts(keyStroke), (String)"getKeymapConflicts(...)");
                    if (!(!((Collection)actions).isEmpty())) continue;
                    Object object = actions.get(0).getAction();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.AnAction");
                    this.rows.add(new Row(keyStroke, (AnAction)object, value));
                }
                CollectionsKt.sort(this.rows);
            }

            private final Map<KeyStroke, ShortcutOwnerInfo> getCurrentData() {
                Map result = new HashMap();
                for (Row row : this.rows) {
                    result.put(row.getKeyStroke(), row.getOwner());
                }
                return result;
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Column.values().length];
                    try {
                        nArray[Column.KEYSTROKE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Column.IDE_ACTION.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Column.OWNER.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$Row;", "", "keyStroke", "Ljavax/swing/KeyStroke;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "owner", "Lcom/maddyhome/idea/vim/key/ShortcutOwnerInfo;", "<init>", "(Ljavax/swing/KeyStroke;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/maddyhome/idea/vim/key/ShortcutOwnerInfo;)V", "getKeyStroke", "()Ljavax/swing/KeyStroke;", "getAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "getOwner", "()Lcom/maddyhome/idea/vim/key/ShortcutOwnerInfo;", "setOwner", "(Lcom/maddyhome/idea/vim/key/ShortcutOwnerInfo;)V", "compareTo", "", "other", "IdeaVIM"})
        public static final class Row
        implements Comparable<Row> {
            @NotNull
            private final KeyStroke keyStroke;
            @NotNull
            private final AnAction action;
            @NotNull
            private ShortcutOwnerInfo owner;

            public Row(@NotNull KeyStroke keyStroke, @NotNull AnAction action, @NotNull ShortcutOwnerInfo owner) {
                Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                this.keyStroke = keyStroke;
                this.action = action;
                this.owner = owner;
            }

            @NotNull
            public final KeyStroke getKeyStroke() {
                return this.keyStroke;
            }

            @NotNull
            public final AnAction getAction() {
                return this.action;
            }

            @NotNull
            public final ShortcutOwnerInfo getOwner() {
                return this.owner;
            }

            public final void setOwner(@NotNull ShortcutOwnerInfo shortcutOwnerInfo) {
                Intrinsics.checkNotNullParameter((Object)shortcutOwnerInfo, (String)"<set-?>");
                this.owner = shortcutOwnerInfo;
            }

            @Override
            public int compareTo(@NotNull Row other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                KeyStroke otherKeyStroke = other.keyStroke;
                int keyCodeDiff = this.keyStroke.getKeyCode() - otherKeyStroke.getKeyCode();
                return keyCodeDiff != 0 ? keyCodeDiff : this.keyStroke.getModifiers() - otherKeyStroke.getModifiers();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$ShortcutOwnerRenderer;", "Lcom/intellij/openapi/ui/ComboBoxTableRenderer;", "Lcom/maddyhome/idea/vim/key/ShortcutOwner;", "<init>", "()V", "customizeComponent", "", "owner", "table", "Ljavax/swing/JTable;", "isSelected", "", "isCellEditable", "event", "Ljava/util/EventObject;", "IdeaVIM"})
        @SourceDebugExtension(value={"SMAP\nVimEmulationConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimEmulationConfigurable.kt\ncom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$ShortcutOwnerRenderer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,416:1\n37#2:417\n36#2,3:418\n*S KotlinDebug\n*F\n+ 1 VimEmulationConfigurable.kt\ncom/maddyhome/idea/vim/ui/VimEmulationConfigurable$VimShortcutConflictsTable$ShortcutOwnerRenderer\n*L\n195#1:417\n195#1:418,3\n*E\n"})
        private static final class ShortcutOwnerRenderer
        extends ComboBoxTableRenderer<ShortcutOwner> {
            public ShortcutOwnerRenderer() {
                Collection $this$toTypedArray$iv = (Collection)ShortcutOwner.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                super((Object[])thisCollection$iv.toArray(new ShortcutOwner[0]));
            }

            protected void customizeComponent(@NotNull ShortcutOwner owner, @NotNull JTable table, boolean isSelected) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                super.customizeComponent((Object)owner, table, isSelected);
                if (owner == ShortcutOwner.UNDEFINED) {
                    this.setForeground(UIUtil.getComboBoxDisabledForeground());
                }
            }

            public boolean isCellEditable(@NotNull EventObject event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return true;
            }
        }
    }
}

