/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.intellij.openapi.util.SystemInfo;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.ui.ex.ExEntryPanel;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.jetbrains.annotations.NotNull;

public class ExDocument
extends DefaultStyledDocument {
    public static final String SpecialKeyStyleName = "SpecialKey";
    public static final String NonPrintableElementName = "non-printable";
    private boolean overwrite = false;

    public ExDocument() {
        this.setDocumentFilter(new ExDocumentFilter());
        Style specialStyle = this.addStyle(SpecialKeyStyleName, null);
        Style nonPrintableStyle = this.addStyle(NonPrintableElementName, specialStyle);
        nonPrintableStyle.addAttribute("$ename", NonPrintableElementName);
    }

    void setSpecialKeyForeground(@NotNull Color fg) {
        Style style;
        if (fg == null) {
            ExDocument.$$$reportNull$$$0(0);
        }
        if ((style = this.getStyle(SpecialKeyStyleName)) != null) {
            StyleConstants.setForeground(style, fg);
        }
    }

    void toggleInsertReplace() {
        VimCommandLine commandLine = VimInjectorKt.injector.getCommandLine().getActiveCommandLine();
        if (commandLine != null) {
            ((ExEntryPanel)commandLine).isReplaceMode = !((ExEntryPanel)commandLine).isReplaceMode;
        }
        this.overwrite = !this.overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public void insertString(int offs, @NotNull String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            ExDocument.$$$reportNull$$$0(1);
        }
        this.addInputMethodAttributes(a);
        super.insertString(offs, str, a);
    }

    private void addInputMethodAttributes(AttributeSet attributeSet) {
        Object composedTextAttribute;
        if (!SystemInfo.isMac) {
            return;
        }
        Object object = composedTextAttribute = attributeSet != null ? attributeSet.getAttribute(StyleConstants.ComposedTextAttribute) : null;
        if (composedTextAttribute instanceof AttributedString) {
            AttributedString attributedString = (AttributedString)composedTextAttribute;
            AttributedCharacterIterator iterator = attributedString.getIterator();
            while (iterator.current() != '\uffff') {
                Map<AttributedCharacterIterator.Attribute, Object> currentCharAttributes = iterator.getAttributes();
                if (!currentCharAttributes.containsKey(TextAttribute.INPUT_METHOD_HIGHLIGHT) && !currentCharAttributes.containsKey(TextAttribute.INPUT_METHOD_UNDERLINE)) {
                    attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, iterator.getIndex(), iterator.getIndex() + 1);
                }
                iterator.next();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/vim/ui/ex/ExDocument";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSpecialKeyForeground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "insertString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExDocumentFilter
    extends DocumentFilter {
        private ExDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            int rest;
            ExDocument exDocument;
            Object a;
            int originalOffset = offset;
            string = this.filterNewLines(fb.getDocument(), string);
            int start2 = 0;
            int pos = 0;
            while (pos < string.length()) {
                boolean isPrintable = ExDocumentFilter.isPrintableCharacter(string.charAt(pos));
                while (pos < string.length() && ExDocumentFilter.isPrintableCharacter(string.charAt(pos)) == isPrintable) {
                    ++pos;
                }
                a = isPrintable ? attr : ExDocumentFilter.getNonPrintableAttributes(fb.getDocument(), attr);
                String s = string.substring(start2, pos);
                fb.insertString(offset, s, (AttributeSet)a);
                offset += s.length();
                start2 = pos;
            }
            a = fb.getDocument();
            if (a instanceof ExDocument && (exDocument = (ExDocument)a).isOverwrite() && (rest = originalOffset + string.length()) < exDocument.getLength()) {
                int len = Math.min(string.length(), exDocument.getLength() - rest);
                fb.remove(rest, len);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            ExDocument exDocument;
            if (text.isEmpty()) {
                fb.replace(offset, length, text, attrs);
                return;
            }
            text = this.filterNewLines(fb.getDocument(), text);
            Document document = fb.getDocument();
            if (document instanceof ExDocument && (exDocument = (ExDocument)document).isOverwrite()) {
                length = offset + text.length() > exDocument.getLength() ? exDocument.getLength() - offset : Math.max(length, text.length());
            }
            int start2 = 0;
            int pos = 0;
            while (pos < text.length()) {
                boolean isPrintable = ExDocumentFilter.isPrintableCharacter(text.charAt(pos));
                while (pos < text.length() && ExDocumentFilter.isPrintableCharacter(text.charAt(pos)) == isPrintable) {
                    ++pos;
                }
                AttributeSet a = isPrintable ? attrs : ExDocumentFilter.getNonPrintableAttributes(fb.getDocument(), attrs);
                String s = text.substring(start2, pos);
                if (start2 == 0) {
                    fb.replace(offset, length, s, a);
                } else {
                    fb.insertString(offset, s, a);
                }
                offset += s.length();
                start2 = pos;
            }
        }

        private String filterNewLines(Document document, String string) {
            Object filterNewlines = document.getProperty("filterNewlines");
            if (filterNewlines instanceof Boolean && filterNewlines.equals(Boolean.TRUE)) {
                return string.replaceAll("\n", " ");
            }
            return string;
        }

        private static boolean isPrintableCharacter(char c) {
            return EngineStringHelper.INSTANCE.isPrintableCharacter(c);
        }

        @NotNull
        private static AttributeSet getNonPrintableAttributes(Document document, AttributeSet attrs) {
            if (document instanceof ExDocument) {
                ExDocument exDocument = (ExDocument)document;
                Style style = exDocument.getStyle(ExDocument.NonPrintableElementName);
                if (style == null) {
                    ExDocumentFilter.$$$reportNull$$$0(0);
                }
                return style;
            }
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            if (attrs != null) {
                attributeSet.addAttributes(attrs);
            }
            attributeSet.addAttribute("$ename", ExDocument.NonPrintableElementName);
            SimpleAttributeSet simpleAttributeSet = attributeSet;
            if (simpleAttributeSet == null) {
                ExDocumentFilter.$$$reportNull$$$0(1);
            }
            return simpleAttributeSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/vim/ui/ex/ExDocument$ExDocumentFilter", "getNonPrintableAttributes"));
        }
    }
}

