/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IJSwingUtilities;
import com.maddyhome.idea.vim.EventFacade;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.VimShortcutKeyAction;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimCommandLineCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimKeyGroupBase;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.group.KeyGroup;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.SearchHighlightsHelper;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.key.interceptors.VimInputInterceptor;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.ui.ExPanelBorder;
import com.maddyhome.idea.vim.ui.ex.ExTextField;
import com.maddyhome.idea.vim.ui.ex.ExTextFieldUI;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.GlobalCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.SubstituteCommand;
import com.maddyhome.idea.vim.vimscript.parser.VimscriptParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.GlyphView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExEntryPanel
extends JPanel
implements VimCommandLine {
    @Nullable
    public static ExEntryPanel instance;
    public boolean isReplaceMode = false;
    public Function1<String, Unit> inputProcessing = null;
    public Character finishOn = null;
    private VimInputInterceptor myInputInterceptor = null;
    private WeakReference<Editor> weakEditor = null;
    private DataContext context = null;
    private int histIndex = 0;
    private String lastEntry;
    @NotNull
    private final DocumentListener fontListener = new DocumentAdapter(){

        protected void textChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            String text = ExEntryPanel.this.entry.getText();
            Font newFont = UiHelper.selectEditorFont(ExEntryPanel.this.getIjEditor(), text);
            if (newFont != ExEntryPanel.this.entry.getFont()) {
                ExEntryPanel.this.entry.setFont(newFont);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/vim/ui/ex/ExEntryPanel$1", "textChanged"));
        }
    };
    @NotNull
    private final DocumentListener incSearchDocumentListener = new DocumentAdapter(){

        protected void textChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            try {
                Editor editor = ExEntryPanel.this.getIjEditor();
                if (editor == null) {
                    return;
                }
                String labelText = ExEntryPanel.this.label.getText();
                boolean searchCommand = false;
                LineRange searchRange = null;
                char separator = labelText.charAt(0);
                String searchText = ExEntryPanel.this.getText();
                if (labelText.equals(":")) {
                    if (searchText.isEmpty()) {
                        return;
                    }
                    Command command = this.getIncsearchCommand(searchText);
                    if (command == null) {
                        return;
                    }
                    searchCommand = true;
                    searchText = "";
                    String argument = command.getCommandArgument();
                    if (argument.length() > 1) {
                        separator = argument.charAt(0);
                        searchText = argument.substring(1);
                    }
                    if (!searchText.isEmpty()) {
                        searchRange = command.getLineRangeSafe((VimEditor)new IjVimEditor(editor));
                    }
                    if (searchText.isEmpty() || searchRange == null) {
                        VimPlugin.getSearch().resetIncsearchHighlights();
                        ExEntryPanel.this.resetCaretOffset(editor);
                        return;
                    }
                }
                int count1 = Math.max(1, KeyHandler.getInstance().getKeyHandlerState().getEditorCommandBuilder().calculateCount0Snapshot());
                if (labelText.equals("/") || labelText.equals("?") || searchCommand) {
                    boolean forwards = !labelText.equals("?");
                    int patternEnd = VimInjectorKt.injector.getSearchGroup().findEndOfPattern(searchText, separator, 0);
                    String pattern = searchText.substring(0, patternEnd);
                    VimPlugin.getEditor().closeEditorSearchSession(editor);
                    int matchOffset = SearchHighlightsHelper.updateIncsearchHighlights(editor, pattern, count1, forwards, ExEntryPanel.this.caretOffset, searchRange);
                    if (matchOffset != -1) {
                        if (searchCommand) {
                            EngineModeExtensionsKt.exitVisualMode((VimEditor)new IjVimEditor(editor));
                        }
                        new IjVimCaret(editor.getCaretModel().getPrimaryCaret()).moveToOffset(matchOffset);
                    } else {
                        ExEntryPanel.this.resetCaretOffset(editor);
                    }
                }
            }
            catch (Throwable ex) {
                logger.error("Error while trying to show incsearch highlights", ex);
            }
        }

        @Contract(value="null -> null")
        @Nullable
        private Command getIncsearchCommand(@Nullable String commandText) {
            if (commandText == null) {
                return null;
            }
            try {
                Command exCommand = VimscriptParser.INSTANCE.parseCommand(commandText);
                if (exCommand instanceof SubstituteCommand || exCommand instanceof GlobalCommand) {
                    return exCommand;
                }
            }
            catch (Exception e) {
                logger.error("Cannot parse command for incsearch", (Throwable)e);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/vim/ui/ex/ExEntryPanel$2", "textChanged"));
        }
    };
    private boolean active;
    @Nullable
    private JComponent parent;
    @NotNull
    private final JLabel label;
    @NotNull
    private final ExTextField entry;
    private JComponent oldGlass;
    private LayoutManager oldLayout;
    private boolean wasOpaque;
    private int verticalOffset;
    private int horizontalOffset;
    private int caretOffset;
    @NotNull
    private final ComponentListener resizePanelListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            ExEntryPanel.this.positionPanel();
        }
    };
    private static final Logger logger;

    private ExEntryPanel() {
        this.label = new JLabel(" ");
        this.entry = new ExTextField(this);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(layout);
        gbc.gridx = 0;
        layout.setConstraints(this.label, gbc);
        this.add(this.label);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        layout.setConstraints(this.entry, gbc);
        this.add(this.entry);
        EventFacade.getInstance().registerCustomShortcutSet(VimShortcutKeyAction.getInstance(), KeyGroup.toShortcutSet(((VimKeyGroupBase)VimInjectorKt.injector.getKeyGroup()).getRequiredShortcutKeys()), this.entry);
        this.updateUI();
    }

    public static ExEntryPanel getOrCreateInstance() {
        if (instance == null) {
            instance = new ExEntryPanel();
        }
        return instance;
    }

    public static void fullReset() {
        if (instance != null) {
            instance.reset();
            instance = null;
        }
    }

    @Nullable
    public Editor getIjEditor() {
        return this.weakEditor != null ? (Editor)this.weakEditor.get() : null;
    }

    @NotNull
    public VimEditor getEditor() {
        Editor editor = this.getIjEditor();
        if (editor == null) {
            throw new RuntimeException("Editor was disposed for active command line");
        }
        return new IjVimEditor(editor);
    }

    public void setEditor(@Nullable Editor editor) {
        this.weakEditor = editor == null ? null : new WeakReference<Editor>(editor);
    }

    public DataContext getContext() {
        return this.context;
    }

    public void setContext(DataContext context) {
        this.context = context;
    }

    @Deprecated(forRemoval=true)
    public void activate(@NotNull Editor editor, DataContext context, @NotNull String label, String initText, int count) {
        if (editor == null) {
            ExEntryPanel.$$$reportNull$$$0(0);
        }
        if (label == null) {
            ExEntryPanel.$$$reportNull$$$0(1);
        }
        this.activate(editor, context, label, initText);
    }

    public void activate(@NotNull Editor editor, DataContext context, @NotNull String label, String initText) {
        if (editor == null) {
            ExEntryPanel.$$$reportNull$$$0(2);
        }
        if (label == null) {
            ExEntryPanel.$$$reportNull$$$0(3);
        }
        logger.info("Activate ex entry panel");
        this.label.setText(label);
        this.label.setFont(UiHelper.selectEditorFont(editor, label));
        this.entry.reset();
        this.entry.setText(initText);
        this.entry.setFont(UiHelper.selectEditorFont(editor, initText));
        this.parent = editor.getContentComponent();
        Color foregroundColour = editor.getColorsScheme().getDefaultForeground();
        this.entry.setForeground(foregroundColour);
        Color whitespaceColour = editor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR);
        this.entry.setSpecialKeyForeground(whitespaceColour != null ? whitespaceColour : foregroundColour);
        this.label.setForeground(this.entry.getForeground());
        this.context = context;
        this.setEditor(editor);
        this.setHistIndex(VimPlugin.getHistory().getEntries(this.getHistoryType(), 0, 0).size());
        this.entry.getDocument().addDocumentListener(this.fontListener);
        if (this.isIncSearchEnabled()) {
            this.entry.getDocument().addDocumentListener(this.incSearchDocumentListener);
            this.caretOffset = editor.getCaretModel().getOffset();
            this.verticalOffset = editor.getScrollingModel().getVerticalScrollOffset();
            this.horizontalOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JRootPane root = SwingUtilities.getRootPane(this.parent);
            if (root == null) {
                return;
            }
            this.oldGlass = (JComponent)root.getGlassPane();
            this.oldLayout = this.oldGlass.getLayout();
            this.wasOpaque = this.oldGlass.isOpaque();
            this.oldGlass.setLayout(null);
            this.oldGlass.setOpaque(false);
            this.oldGlass.add(this);
            this.oldGlass.addComponentListener(this.resizePanelListener);
            this.positionPanel();
            this.oldGlass.setVisible(true);
            this.entry.requestFocusInWindow();
        }
        this.active = true;
    }

    public void deactivate(boolean refocusOwningEditor) {
        this.deactivate(refocusOwningEditor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean refocusOwningEditor, boolean resetCaret) {
        logger.info("Deactivate ex entry panel");
        if (!this.active) {
            return;
        }
        this.clearPromptCharacter();
        try {
            this.entry.getDocument().removeDocumentListener(this.fontListener);
            if (this.isIncSearchEnabled()) {
                this.entry.getDocument().removeDocumentListener(this.incSearchDocumentListener);
                Editor editor = this.getIjEditor();
                if (editor != null && !editor.isDisposed() && resetCaret) {
                    this.resetCaretOffset(editor);
                }
                VimPlugin.getSearch().resetIncsearchHighlights();
            }
            this.entry.deactivate();
        }
        finally {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (refocusOwningEditor && this.parent != null) {
                    UiHelper.requestFocus(this.parent);
                }
                this.oldGlass.removeComponentListener(this.resizePanelListener);
                this.oldGlass.setVisible(false);
                this.oldGlass.remove(this);
                this.oldGlass.setOpaque(this.wasOpaque);
                this.oldGlass.setLayout(this.oldLayout);
            }
            this.parent = null;
        }
        this.isReplaceMode = false;
        this.setEditor(null);
        this.context = null;
        this.active = false;
        this.finishOn = null;
        this.myInputInterceptor = null;
        this.inputProcessing = null;
    }

    private void reset() {
        this.deactivate(false);
    }

    private void resetCaretOffset(@NotNull Editor editor) {
        ScrollingModel scrollingModel;
        Caret primaryCaret;
        if (editor == null) {
            ExEntryPanel.$$$reportNull$$$0(4);
        }
        if ((primaryCaret = editor.getCaretModel().getPrimaryCaret()).getOffset() != this.caretOffset) {
            new IjVimCaret(primaryCaret).moveToOffset(this.caretOffset);
        }
        if ((scrollingModel = editor.getScrollingModel()).getHorizontalScrollOffset() != this.horizontalOffset || scrollingModel.getVerticalScrollOffset() != this.verticalOffset) {
            scrollingModel.scroll(this.horizontalOffset, this.verticalOffset);
        }
    }

    @NotNull
    public String getLabel() {
        String string = this.label.getText();
        if (string == null) {
            ExEntryPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void toggleReplaceMode() {
        this.entry.toggleInsertReplace();
    }

    public boolean isActive() {
        return this.active;
    }

    @NotNull
    public String getText() {
        String string = this.entry.getText();
        if (string == null) {
            ExEntryPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getRenderedText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getRenderedText(this.entry.getUI().getRootView(this.entry), stringBuilder);
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ExEntryPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void getRenderedText(View view, StringBuilder stringBuilder) {
        if (view.getElement().isLeaf()) {
            if (view instanceof GlyphView) {
                GlyphView glyphView = (GlyphView)view;
                Segment text = glyphView.getText(glyphView.getStartOffset(), glyphView.getEndOffset());
                stringBuilder.append(text);
                if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
            } else {
                stringBuilder.append("<Unknown leaf view. Expected GlyphView, got: ");
                stringBuilder.append(view.getClass().getName());
                stringBuilder.append(">");
            }
        } else {
            int viewCount = view.getViewCount();
            for (int i = 0; i < viewCount; ++i) {
                View child = view.getView(i);
                this.getRenderedText(child, stringBuilder);
            }
        }
    }

    public void setPromptCharacter(char promptCharacter) {
        TextUI textUI = this.entry.getUI();
        if (textUI instanceof ExTextFieldUI) {
            ExTextFieldUI exTextFieldUI = (ExTextFieldUI)textUI;
            exTextFieldUI.setPromptCharacter(promptCharacter);
        }
    }

    public void clearPromptCharacter() {
        TextUI textUI = this.entry.getUI();
        if (textUI instanceof ExTextFieldUI) {
            ExTextFieldUI exTextFieldUI = (ExTextFieldUI)textUI;
            exTextFieldUI.clearPromptCharacter();
        }
    }

    @NotNull
    public ExTextField getEntry() {
        ExTextField exTextField = this.entry;
        if (exTextField == null) {
            ExEntryPanel.$$$reportNull$$$0(8);
        }
        return exTextField;
    }

    public void handleKey(@NotNull KeyStroke stroke) {
        if (stroke == null) {
            ExEntryPanel.$$$reportNull$$$0(9);
        }
        this.entry.handleKey(stroke);
        if (this.finishOn != null && stroke.getKeyChar() == this.finishOn.charValue() && this.inputProcessing != null) {
            this.inputProcessing.invoke((Object)this.getText());
            this.close(true, true);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)((Object)new ExPanelBorder()));
        if (this.entry != null && this.label != null) {
            this.setFontForElements();
            this.label.setForeground(this.entry.getForeground());
            this.positionPanel();
        }
    }

    @Override
    public Color getForeground() {
        return this.entry != null ? this.entry.getForeground() : super.getForeground();
    }

    @Override
    public Color getBackground() {
        return this.entry != null ? this.entry.getBackground() : super.getBackground();
    }

    private void setFontForElements() {
        this.label.setFont(UiHelper.selectEditorFont(this.getIjEditor(), this.label.getText()));
        this.entry.setFont(UiHelper.selectEditorFont(this.getIjEditor(), this.entry.getText()));
    }

    private void positionPanel() {
        if (this.parent == null) {
            return;
        }
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.parent);
        int height = (int)this.getPreferredSize().getHeight();
        if (scroll != null) {
            Rectangle bounds = scroll.getBounds();
            bounds.translate(0, scroll.getHeight() - height);
            bounds.height = height;
            Point pos = SwingUtilities.convertPoint(scroll.getParent(), bounds.getLocation(), this.oldGlass);
            bounds.setLocation(pos);
            this.setBounds(bounds);
            this.repaint();
        }
    }

    private boolean isIncSearchEnabled() {
        return VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.injector).getIncsearch();
    }

    @NotNull
    public VimCommandLineCaret getCaret() {
        VimCommandLineCaret vimCommandLineCaret = (VimCommandLineCaret)this.entry.getCaret();
        if (vimCommandLineCaret == null) {
            ExEntryPanel.$$$reportNull$$$0(10);
        }
        return vimCommandLineCaret;
    }

    public void setText(@NotNull String string, boolean updateLastEntry) {
        if (string == null) {
            ExEntryPanel.$$$reportNull$$$0(11);
        }
        int offset = this.getCaret().getOffset();
        this.entry.updateText(string);
        if (updateLastEntry) {
            this.entry.saveLastEntry();
        }
        this.getCaret().setOffset(Math.min(offset, this.getText().length()));
    }

    public void deleteText(int offset, int length) {
        this.entry.deleteText(offset, length);
    }

    public void insertText(int offset, @NotNull String string) {
        if (string == null) {
            ExEntryPanel.$$$reportNull$$$0(12);
        }
        if (this.isReplaceMode) {
            this.entry.deleteText(offset, string.length());
        }
        this.entry.insertText(offset, string);
    }

    public void clearCurrentAction() {
        this.entry.clearCurrentAction();
    }

    public boolean isReplaceMode() {
        return this.isReplaceMode;
    }

    public void focus() {
        IdeFocusManager.findInstance().requestFocus((Component)this.entry, true);
    }

    @Nullable
    public VimInputInterceptor getInputInterceptor() {
        return this.myInputInterceptor;
    }

    public void setInputInterceptor(@Nullable VimInputInterceptor vimInputInterceptor) {
        this.myInputInterceptor = vimInputInterceptor;
    }

    @Nullable
    public Function1<String, Unit> getInputProcessing() {
        return this.inputProcessing;
    }

    @Nullable
    public Character getFinishOn() {
        return this.finishOn;
    }

    public int getHistIndex() {
        return this.histIndex;
    }

    public void setHistIndex(int i) {
        this.histIndex = i;
    }

    @NotNull
    public String getLastEntry() {
        String string = this.lastEntry;
        if (string == null) {
            ExEntryPanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setLastEntry(@NotNull String s) {
        if (s == null) {
            ExEntryPanel.$$$reportNull$$$0(14);
        }
        this.lastEntry = s;
    }

    static {
        logger = Logger.getInstance((String)ExEntryPanel.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/vim/ui/ex/ExEntryPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stroke";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/vim/ui/ex/ExEntryPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaret";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetCaretOffset";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleKey";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setLastEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 10, 13 -> new IllegalStateException(string);
        };
    }

    public static class LafListener
    implements LafManagerListener {
        public void lookAndFeelChanged(@NotNull LafManager source) {
            if (source == null) {
                LafListener.$$$reportNull$$$0(0);
            }
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (instance != null) {
                IJSwingUtilities.updateComponentTreeUI((Component)instance);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/maddyhome/idea/vim/ui/ex/ExEntryPanel$LafListener", "lookAndFeelChanged"));
        }
    }
}

