/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.widgets.mode;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.util.UiSizeUtilKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.ui.widgets.mode.ModeWidgetPopup;
import com.maddyhome.idea.vim.ui.widgets.mode.UtilKt;
import com.maddyhome.idea.vim.ui.widgets.mode.VimStatusBarWidget;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "Lcom/maddyhome/idea/vim/ui/widgets/mode/VimStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "label", "Lcom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget$JBLabelWiderThan;", "ID", "", "getComponent", "Ljavax/swing/JComponent;", "updateWidget", "", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "updateLabel", "getFocusedEditor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "JBLabelWiderThan", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimModeWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimModeWidget.kt\ncom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class VimModeWidget
implements CustomStatusBarWidget,
VimStatusBarWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JBLabelWiderThan label;
    @NotNull
    private static final String INSERT = "INSERT";
    @NotNull
    private static final String NORMAL = "NORMAL";
    @NotNull
    private static final String INSERT_PENDING_PREFIX = "(insert) ";
    @NotNull
    private static final String REPLACE = "REPLACE";
    @NotNull
    private static final String REPLACE_PENDING_PREFIX = "(replace) ";
    @NotNull
    private static final String COMMAND = "COMMAND";
    @NotNull
    private static final String VISUAL = "VISUAL";
    @NotNull
    private static final String VISUAL_LINE = "V-LINE";
    @NotNull
    private static final String VISUAL_BLOCK = "V-BLOCK";
    @NotNull
    private static final String SELECT = "SELECT";
    @NotNull
    private static final String SELECT_LINE = "S-LINE";
    @NotNull
    private static final String SELECT_BLOCK = "S-BLOCK";
    @NotNull
    private static final String SELECT_PENDING_PREFIX = "(select) ";

    /*
     * WARNING - void declaration
     */
    public VimModeWidget(@NotNull Project project) {
        void $this$label_u24lambda_u240;
        JBLabelWiderThan jBLabelWiderThan;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        JBLabelWiderThan jBLabelWiderThan2 = jBLabelWiderThan = new JBLabelWiderThan(SetsKt.setOf((Object)REPLACE));
        VimModeWidget vimModeWidget = this;
        boolean bl = false;
        $this$label_u24lambda_u240.setOpaque(true);
        vimModeWidget.label = jBLabelWiderThan;
        Editor editor = this.getFocusedEditor(this.project);
        Mode mode2 = editor != null && (editor = IjVimEditorKt.getVim(editor)) != null ? editor.getMode() : null;
        this.updateLabel(mode2);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JBPopup jBPopup = ModeWidgetPopup.Companion.createPopup();
                    if (jBPopup == null) {
                        return;
                    }
                    JBPopup popup = jBPopup;
                    Dimension dimension = popup.getContent().getPreferredSize();
                    Point widgetLocation = e.getComponent().getLocationOnScreen();
                    popup.show(new RelativePoint(new Point(widgetLocation.x + e.getComponent().getWidth() - dimension.width, widgetLocation.y - dimension.height)));
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public String ID() {
        return "IdeaVimMode";
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this.label);
    }

    public final void updateWidget() {
        Editor editor = this.getFocusedEditor(this.project);
        Mode mode2 = editor != null && (editor = IjVimEditorKt.getVim(editor)) != null ? editor.getMode() : null;
        this.updateWidget(mode2);
    }

    public final void updateWidget(@Nullable Mode mode2) {
        this.updateLabel(mode2);
        this.updateWidgetInStatusBar("IdeaVimMode", this.project);
    }

    private final void updateLabel(Mode mode2) {
        this.label.setText(Companion.getModeText(mode2));
        this.label.setForeground(UtilKt.getModeForeground(mode2));
        this.label.setBackground(UtilKt.getModeBackground(mode2));
    }

    private final Editor getFocusedEditor(Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        return fileEditorManager.getSelectedTextEditor();
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return super.getPresentation();
    }

    @Deprecated(message="implement {@link #getPresentation()} instead ")
    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return super.getPresentation(type);
    }

    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void updateWidgetInStatusBar(@NotNull String widgetID, @Nullable Project project) {
        VimStatusBarWidget.super.updateWidgetInStatusBar(widgetID, project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget$Companion;", "", "<init>", "()V", "INSERT", "", "NORMAL", "INSERT_PENDING_PREFIX", "REPLACE", "REPLACE_PENDING_PREFIX", "COMMAND", "VISUAL", "VISUAL_LINE", "VISUAL_BLOCK", "SELECT", "SELECT_LINE", "SELECT_BLOCK", "SELECT_PENDING_PREFIX", "getModeText", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "getNormalModeText", "Lcom/maddyhome/idea/vim/state/mode/Mode$NORMAL;", "getVisualModeText", "Lcom/maddyhome/idea/vim/state/mode/Mode$VISUAL;", "getSelectModeText", "Lcom/maddyhome/idea/vim/state/mode/Mode$SELECT;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getModeText(@Nullable Mode mode2) {
            String string;
            Mode mode3 = mode2;
            if (Intrinsics.areEqual((Object)mode3, (Object)Mode.INSERT.INSTANCE)) {
                string = VimModeWidget.INSERT;
            } else if (Intrinsics.areEqual((Object)mode3, (Object)Mode.REPLACE.INSTANCE)) {
                string = VimModeWidget.REPLACE;
            } else if (mode3 instanceof Mode.NORMAL) {
                string = this.getNormalModeText((Mode.NORMAL)mode2);
            } else if (mode3 instanceof Mode.CMD_LINE) {
                string = VimModeWidget.COMMAND;
            } else if (mode3 instanceof Mode.VISUAL) {
                string = this.getVisualModeText((Mode.VISUAL)mode2);
            } else if (mode3 instanceof Mode.SELECT) {
                string = this.getSelectModeText((Mode.SELECT)mode2);
            } else if (mode3 instanceof Mode.OP_PENDING || mode3 == null) {
                string = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final String getNormalModeText(Mode.NORMAL mode2) {
            return mode2.isInsertPending() ? "(insert) NORMAL" : (mode2.isReplacePending() ? "(replace) NORMAL" : VimModeWidget.NORMAL);
        }

        private final String getVisualModeText(Mode.VISUAL mode2) {
            String prefix = mode2.isInsertPending() ? VimModeWidget.INSERT_PENDING_PREFIX : (mode2.isReplacePending() ? VimModeWidget.REPLACE_PENDING_PREFIX : (mode2.isSelectPending() ? VimModeWidget.SELECT_PENDING_PREFIX : ""));
            return prefix + (switch (WhenMappings.$EnumSwitchMapping$0[mode2.getSelectionType().ordinal()]) {
                case 1 -> VimModeWidget.VISUAL;
                case 2 -> VimModeWidget.VISUAL_LINE;
                case 3 -> VimModeWidget.VISUAL_BLOCK;
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        private final String getSelectModeText(Mode.SELECT mode2) {
            String prefix = mode2.isInsertPending() ? VimModeWidget.INSERT_PENDING_PREFIX : (mode2.isReplacePending() ? VimModeWidget.REPLACE_PENDING_PREFIX : "");
            return prefix + (switch (WhenMappings.$EnumSwitchMapping$0[mode2.getSelectionType().ordinal()]) {
                case 1 -> VimModeWidget.SELECT;
                case 2 -> VimModeWidget.SELECT_LINE;
                case 3 -> VimModeWidget.SELECT_BLOCK;
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SelectionType.values().length];
                try {
                    nArray[SelectionType.CHARACTER_WISE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelectionType.LINE_WISE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelectionType.BLOCK_WISE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget$JBLabelWiderThan;", "Lcom/intellij/ui/components/JBLabel;", "words", "", "", "<init>", "(Ljava/util/Collection;)V", "wordWidth", "", "getWordWidth", "()I", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "getMaximumSize", "getComponentGraphics", "Ljava/awt/Graphics;", "g", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimModeWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimModeWidget.kt\ncom/maddyhome/idea/vim/ui/widgets/mode/VimModeWidget$JBLabelWiderThan\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
    private static final class JBLabelWiderThan
    extends JBLabel {
        @NotNull
        private final Collection<String> words;

        public JBLabelWiderThan(@NotNull Collection<String> words) {
            Intrinsics.checkNotNullParameter(words, (String)"words");
            super("", 0);
            this.words = words;
        }

        private final int getWordWidth() {
            Comparable comparable;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Iterator iterator = ((Iterable)this.words).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                String it = (String)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(fontMetrics.stringWidth(it));
                while (iterator.hasNext()) {
                    String it2 = (String)iterator.next();
                    $i$a$-maxOfOrNull-VimModeWidget$JBLabelWiderThan$wordWidth$1 = false;
                    Comparable comparable3 = Integer.valueOf(fontMetrics.stringWidth(it2));
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            return n != null ? n : 0;
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension minimumSize = super.getMinimumSize();
            int n = minimumSize.width;
            int n2 = this.getWordWidth();
            Insets insets = this.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            int n3 = n2 + UiSizeUtilKt.getWidth((Insets)insets);
            return new Dimension(Math.max(n, n3), minimumSize.height);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int n = preferredSize.width;
            int n2 = this.getWordWidth();
            Insets insets = this.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            int n3 = n2 + UiSizeUtilKt.getWidth((Insets)insets);
            return new Dimension(Math.max(n, n3), preferredSize.height);
        }

        @NotNull
        public Dimension getMaximumSize() {
            Dimension maximumSize = super.getMaximumSize();
            int n = maximumSize.width;
            int n2 = this.getWordWidth();
            Insets insets = this.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            int n3 = n2 + UiSizeUtilKt.getWidth((Insets)insets);
            return new Dimension(Math.max(n, n3), maximumSize.height);
        }

        @NotNull
        protected Graphics getComponentGraphics(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Graphics2D graphics2D = IdeBackgroundUtil.getOriginalGraphics((Graphics)g);
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getOriginalGraphics(...)");
            return graphics2D;
        }
    }
}

