/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.LineRangeKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/CmdFilterCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nCmdFilterCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmdFilterCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/CmdFilterCommand\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,121:1\n1179#2,2:122\n*S KotlinDebug\n*F\n+ 1 CmdFilterCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/CmdFilterCommand\n*L\n45#1:122,2\n*E\n"})
public final class CmdFilterCommand
extends Command.SingleExecution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    @NotNull
    private static final Logger logger;
    @Nullable
    private static String lastCommand;

    public CmdFilterCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, null, 4, null);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        ExecutionResult executionResult;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        logger.debug("execute");
        StringBuilder $this$processCommand_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean inBackslash = false;
        CharSequence $this$forEach$iv = this.argument;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            if (!inBackslash && c == '!') {
                String last = lastCommand;
                CharSequence charSequence = last;
                if (charSequence == null || charSequence.length() == 0) {
                    VimPlugin.showMessage(MessageHelper.message("e_noprev"));
                    return (ExecutionResult)ExecutionResult.Error.INSTANCE;
                }
                v0 = $this$processCommand_u24lambda_u241.append(last);
            } else if (!inBackslash && c == '%') {
                VirtualFile virtualFile = EditorHelper.getVirtualFile(IjVimEditorKt.getIj(editor));
                if (virtualFile == null) {
                    VimPlugin.showMessage(MessageHelper.message("E499"));
                    return (ExecutionResult)ExecutionResult.Error.INSTANCE;
                }
                v0 = $this$processCommand_u24lambda_u241.append(virtualFile.getPath());
            } else {
                v0 = $this$processCommand_u24lambda_u241.append(c);
            }
            inBackslash = c == '\\';
        }
        String command = stringBuilder.toString();
        if (((CharSequence)command).length() == 0) {
            return (ExecutionResult)ExecutionResult.Error.INSTANCE;
        }
        Project project = IjVimEditorKt.getIj(editor).getProject();
        String workingDirectory = project != null ? project.getBasePath() : null;
        try {
            ExecutionResult.Success success;
            if (this.range.size() == 0) {
                String string = VimPlugin.getProcess().executeCommand(editor, command, null, workingDirectory);
                if (string != null) {
                    String it = string;
                    boolean bl3 = false;
                    VimOutputPanel outputPanel = VimInjectorKt.getInjector().getOutputPanel().getOrCreate(editor, context);
                    VimOutputPanel.addText$default((VimOutputPanel)outputPanel, (String)it, (boolean)false, (int)2, null);
                    outputPanel.show();
                }
                lastCommand = command;
                success = ExecutionResult.Success.INSTANCE;
            } else {
                TextRange range = LineRangeKt.toTextRange((LineRange)this.getLineRange(editor), (VimEditor)editor);
                CharSequence input = IjVimEditorKt.getIj(editor).getDocument().getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset());
                String string = VimPlugin.getProcess().executeCommand(editor, command, input, workingDirectory);
                if (string != null) {
                    String it = string;
                    boolean bl4 = false;
                    ApplicationManager.getApplication().runWriteAction(() -> CmdFilterCommand.processCommand$lambda$4$lambda$3(editor, range, it));
                }
                lastCommand = command;
                success = ExecutionResult.Success.INSTANCE;
            }
            executionResult = (ExecutionResult)success;
        }
        catch (ProcessCanceledException processCanceledException) {
            throw new ExException("Command terminated");
        }
        catch (Exception e) {
            throw new ExException(e.getMessage());
        }
        return executionResult;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final CmdFilterCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new CmdFilterCommand(range, modifier, argument);
    }

    public static /* synthetic */ CmdFilterCommand copy$default(CmdFilterCommand cmdFilterCommand, Range range, CommandModifier commandModifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = cmdFilterCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = cmdFilterCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = cmdFilterCommand.argument;
        }
        return cmdFilterCommand.copy(range, commandModifier, string);
    }

    @NotNull
    public String toString() {
        return "CmdFilterCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CmdFilterCommand)) {
            return false;
        }
        CmdFilterCommand cmdFilterCommand = (CmdFilterCommand)((Object)other);
        if (!Intrinsics.areEqual((Object)this.range, (Object)cmdFilterCommand.range)) {
            return false;
        }
        if (this.modifier != cmdFilterCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)cmdFilterCommand.argument);
    }

    private static final void processCommand$lambda$4$lambda$3(VimEditor $editor, TextRange $range, String $it) {
        BufferPosition start2 = $editor.offsetToBufferPosition($range.getStartOffset());
        BufferPosition end = $editor.offsetToBufferPosition($range.getEndOffset());
        IjVimEditorKt.getIj($editor).getDocument().replaceString($range.getStartOffset(), $range.getEndOffset(), (CharSequence)$it);
        int linesFiltered = end.getLine() - start2.getLine();
        if (linesFiltered > 2) {
            VimPlugin.showMessage(linesFiltered + " lines filtered");
        }
    }

    static {
        Logger logger = Logger.getInstance((String)CmdFilterCommand.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CmdFilterCommand.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/CmdFilterCommand$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "lastCommand", "", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

