/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.services;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.vimscript.VimScriptGlobalEnvironment;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimBlob;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.Variable;
import com.maddyhome.idea.vim.vimscript.services.VimVariableServiceBase;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="VimVariables", storages={@Storage(value="$APP_CONFIG$/vim_settings_local.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/vimscript/services/IjVariableService;", "Lcom/maddyhome/idea/vim/vimscript/services/VimVariableServiceBase;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "storeVariable", "", "variable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Variable;", "value", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "simplify", "", "getState", "loadState", "state", "saveData", "element", "readData", "IdeaVIM"})
public final class IjVariableService
extends VimVariableServiceBase
implements PersistentStateComponent<Element> {
    public void storeVariable(@NotNull Variable variable, @NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Scope scope;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        super.storeVariable(variable, value, editor, context, vimContext);
        Scope scope2 = variable.getScope();
        if (scope2 == null) {
            scope2 = this.getDefaultVariableScope(vimContext);
        }
        if ((scope = scope2) == Scope.GLOBAL_VARIABLE) {
            Object object = variable.getScope();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            Object scopeForGlobalEnvironment = object;
            Map<String, Object> map = VimScriptGlobalEnvironment.getInstance().getVariables();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getVariables(...)");
            Map<String, Object> map2 = map;
            String string = (String)scopeForGlobalEnvironment + variable.getName().evaluate(editor, context, vimContext);
            Object object2 = this.simplify(value);
            map2.put(string, object2);
        }
    }

    private final Object simplify(VimDataType $this$simplify) {
        Object object;
        VimDataType vimDataType = $this$simplify;
        if (vimDataType instanceof VimString) {
            object = ((VimString)$this$simplify).getValue();
        } else if (vimDataType instanceof VimInt) {
            object = ((VimInt)$this$simplify).getValue();
        } else if (vimDataType instanceof VimFloat) {
            object = ((VimFloat)$this$simplify).getValue();
        } else if (vimDataType instanceof VimList) {
            object = ((VimList)$this$simplify).getValues();
        } else if (vimDataType instanceof VimDictionary) {
            object = ((VimDictionary)$this$simplify).getDictionary();
        } else if (vimDataType instanceof VimBlob) {
            object = "blob";
        } else if (vimDataType instanceof VimFuncref) {
            object = "funcref";
        } else {
            throw new IllegalStateException("Unexpected".toString());
        }
        return object;
    }

    @NotNull
    public Element getState() {
        Element element = new Element("variables");
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.readData(state);
    }

    private final void saveData(Element element) {
        Element vimVariablesElement = new Element("vim-variables");
        for (Map.Entry entry : this.getVimVariables().entrySet()) {
            Element variableElement;
            String key = (String)entry.getKey();
            VimDataType value = (VimDataType)entry.getValue();
            if (value instanceof VimString) {
                variableElement = new Element("variable");
                variableElement.setAttribute("key", key);
                variableElement.setAttribute("value", ((VimString)value).getValue());
                variableElement.setAttribute("type", "string");
                vimVariablesElement.addContent(variableElement);
                continue;
            }
            if (!(value instanceof VimInt)) continue;
            variableElement = new Element("variable");
            variableElement.setAttribute("key", key);
            variableElement.setAttribute("value", String.valueOf(((VimInt)value).getValue()));
            variableElement.setAttribute("type", "int");
            vimVariablesElement.addContent(variableElement);
        }
        element.addContent(vimVariablesElement);
    }

    private final void readData(Element element) {
        Element vimVariablesElement = element.getChild("vim-variables");
        List variableElements = vimVariablesElement.getChildren("variable");
        for (Element variableElement : variableElements) {
            VimString vimString;
            String string;
            Map map;
            String string2 = variableElement.getAttributeValue("type");
            if (Intrinsics.areEqual((Object)string2, (Object)"string")) {
                map = this.getVimVariables();
                string = variableElement.getAttributeValue("key");
                String string3 = variableElement.getAttributeValue("value");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
                vimString = new VimString(string3);
                map.put(string, vimString);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"int")) continue;
            map = this.getVimVariables();
            string = variableElement.getAttributeValue("key");
            String string4 = variableElement.getAttributeValue("value");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeValue(...)");
            vimString = new VimInt(string4);
            map.put(string, vimString);
        }
    }
}

