/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.change.delete;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimChangeGroup;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.handler.VisualOperatorActionHandler;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/maddyhome/idea/vim/action/change/delete/DeleteVisualLinesEndAction;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$ForEachCaret;", "<init>", "()V", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "flags", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/command/CommandFlags;", "getFlags", "()Ljava/util/EnumSet;", "executeAction", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "range", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDeleteVisualLinesEndAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteVisualLinesEndAction.kt\ncom/maddyhome/idea/vim/action/change/delete/DeleteVisualLinesEndAction\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n57#2,2:75\n19#2:77\n59#2,2:78\n61#2:84\n37#3:80\n36#3,3:81\n*S KotlinDebug\n*F\n+ 1 DeleteVisualLinesEndAction.kt\ncom/maddyhome/idea/vim/action/change/delete/DeleteVisualLinesEndAction\n*L\n35#1:75,2\n35#1:77\n35#1:78,2\n35#1:84\n35#1:80\n35#1:81,3\n*E\n"})
public final class DeleteVisualLinesEndAction
extends VisualOperatorActionHandler.ForEachCaret {
    @NotNull
    private final Command.Type type = Command.Type.DELETE;
    @NotNull
    private final EnumSet<CommandFlags> flags;

    public DeleteVisualLinesEndAction() {
        EnumSet<Enum> enumSet;
        CommandFlags[] commandFlagsArray = new CommandFlags[]{CommandFlags.FLAG_MOT_LINEWISE};
        Object[] value$iv = commandFlagsArray;
        boolean $i$f$enumSetOf = false;
        switch (value$iv.length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<CommandFlags> enumSet2 = EnumSet.noneOf(CommandFlags.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<Enum> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Enum[] enumArray = thisCollection$iv$iv.toArray(new CommandFlags[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray, enumArray.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        this.flags = enumSet;
    }

    @Override
    @NotNull
    public Command.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public EnumSet<CommandFlags> getFlags() {
        return this.flags;
    }

    @Override
    public boolean executeAction(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull VimSelection range, @NotNull OperatorArguments operatorArguments) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        TextRange vimTextRange = range.toVimTextRange(true);
        if (range.getType() == SelectionType.BLOCK_WISE) {
            int[] starts = vimTextRange.getStartOffsets();
            int[] ends = vimTextRange.getEndOffsets();
            int n = starts.length;
            for (int i = 0; i < n; ++i) {
                if (ends[i] <= starts[i]) continue;
                ends[i] = EngineEditorHelperKt.getLineEndForOffset(editor, starts[i]);
            }
            TextRange blockRange = new TextRange(starts, ends);
            bl = VimChangeGroup.deleteRange$default(VimInjectorKt.getInjector().getChangeGroup(), editor, context, editor.primaryCaret(), blockRange, SelectionType.BLOCK_WISE, false, false, 64, null);
        } else {
            int lineEndForOffset = EngineEditorHelperKt.getLineEndForOffset(editor, vimTextRange.getEndOffset());
            int endsWithNewLine = (long)lineEndForOffset == editor.fileSize() ? 0 : 1;
            TextRange lineRange = new TextRange(EngineEditorHelperKt.getLineStartForOffset(editor, vimTextRange.getStartOffset()), lineEndForOffset + endsWithNewLine);
            bl = VimChangeGroup.deleteRange$default(VimInjectorKt.getInjector().getChangeGroup(), editor, context, caret, lineRange, SelectionType.LINE_WISE, false, false, 64, null);
        }
        return bl;
    }
}

