/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.Graphemes;
import com.maddyhome.idea.vim.common.TextRange;
import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u001a\"\u0010\u0007\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\"\u0010\n\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\r\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\u000e\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u001a\"\u0010\u000f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u001a\u0010\u0011\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u0012\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\n\u0010\u0013\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004\u001a\u0012\u0010\u0015\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004\u001a\u001a\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010\u001c\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001a\u0010 \u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004\u001a\u001a\u0010\"\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0001\u001a\u0012\u0010$\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006%"}, d2={"endsWithNewLine", "", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getLeadingCharacterOffset", "", "line", "col", "normalizeVisualColumn", "visualLine", "allowEnd", "normalizeColumn", "getVisualLineLength", "lineLength", "visualLineToBufferLine", "normalizeLine", "normalizeOffset", "offset", "getLineEndOffset", "normalizeVisualLine", "getVisualLineCount", "getLineStartForOffset", "getLineEndForOffset", "getText", "", "start", "end", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "getOffset", "column", "getLineBuffer", "Ljava/nio/CharBuffer;", "anyNonWhitespace", "dir", "isLineEmpty", "allowBlanks", "coerceOffset", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nEngineEditorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EngineEditorHelper.kt\ncom/maddyhome/idea/vim/api/EngineEditorHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n1#2:328\n*E\n"})
public final class EngineEditorHelperKt {
    public static final boolean endsWithNewLine(@NotNull VimEditor $this$endsWithNewLine) {
        Intrinsics.checkNotNullParameter((Object)$this$endsWithNewLine, (String)"<this>");
        int textLength = (int)$this$endsWithNewLine.fileSize();
        if (textLength == 0) {
            return false;
        }
        return $this$endsWithNewLine.text().charAt(textLength - 1) == '\n';
    }

    public static final int getLeadingCharacterOffset(@NotNull VimEditor $this$getLeadingCharacterOffset, int line, int col) {
        Intrinsics.checkNotNullParameter((Object)$this$getLeadingCharacterOffset, (String)"<this>");
        int start = $this$getLeadingCharacterOffset.getLineStartOffset(line) + col;
        int end = $this$getLeadingCharacterOffset.getLineEndOffset(line);
        CharSequence chars = $this$getLeadingCharacterOffset.text();
        int pos = end;
        for (int offset = start; offset < end && offset < chars.length(); ++offset) {
            if (Character.isWhitespace(chars.charAt(offset))) continue;
            pos = offset;
            break;
        }
        return pos;
    }

    public static /* synthetic */ int getLeadingCharacterOffset$default(VimEditor vimEditor, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return EngineEditorHelperKt.getLeadingCharacterOffset(vimEditor, n, n2);
    }

    public static final int normalizeVisualColumn(@NotNull VimEditor $this$normalizeVisualColumn, int visualLine, int col, boolean allowEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeVisualColumn, (String)"<this>");
        return RangesKt.coerceIn((int)(EngineEditorHelperKt.getVisualLineLength($this$normalizeVisualColumn, visualLine) - (allowEnd ? 0 : 1)), (ClosedRange)((ClosedRange)new IntRange(0, col)));
    }

    public static final int normalizeColumn(@NotNull VimEditor $this$normalizeColumn, int line, int col, boolean allowEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeColumn, (String)"<this>");
        return RangesKt.coerceIn((int)(EngineEditorHelperKt.lineLength($this$normalizeColumn, line) - (allowEnd ? 0 : 1)), (ClosedRange)((ClosedRange)new IntRange(0, col)));
    }

    public static final int getVisualLineLength(@NotNull VimEditor $this$getVisualLineLength, int visualLine) {
        Intrinsics.checkNotNullParameter((Object)$this$getVisualLineLength, (String)"<this>");
        return EngineEditorHelperKt.lineLength($this$getVisualLineLength, EngineEditorHelperKt.visualLineToBufferLine($this$getVisualLineLength, visualLine));
    }

    public static final int lineLength(@NotNull VimEditor $this$lineLength, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$lineLength, (String)"<this>");
        return $this$lineLength.lineCount() == 0 ? 0 : RangesKt.coerceAtLeast((int)$this$lineLength.offsetToBufferPosition($this$lineLength.getLineEndOffset(line)).getColumn(), (int)0);
    }

    public static final int visualLineToBufferLine(@NotNull VimEditor $this$visualLineToBufferLine, int visualLine) {
        Intrinsics.checkNotNullParameter((Object)$this$visualLineToBufferLine, (String)"<this>");
        int bufferLine = $this$visualLineToBufferLine.visualPositionToBufferPosition(new VimVisualPosition(visualLine, 0, false, 4, null)).getLine();
        return EngineEditorHelperKt.normalizeLine($this$visualLineToBufferLine, bufferLine);
    }

    public static final int normalizeLine(@NotNull VimEditor $this$normalizeLine, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeLine, (String)"<this>");
        return RangesKt.coerceIn((int)line, (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)RangesKt.coerceAtLeast((int)$this$normalizeLine.lineCount(), (int)1))));
    }

    public static final int normalizeOffset(@NotNull VimEditor $this$normalizeOffset, int line, int offset, boolean allowEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeOffset, (String)"<this>");
        if ($this$normalizeOffset.fileSize() == 0L) {
            return 0;
        }
        int min = $this$normalizeOffset.getLineStartOffset(line);
        int max = EngineEditorHelperKt.getLineEndOffset($this$normalizeOffset, line, allowEnd);
        return RangesKt.coerceIn((int)offset, (ClosedRange)((ClosedRange)new IntRange(min, max)));
    }

    public static final int getLineEndOffset(@NotNull VimEditor $this$getLineEndOffset, int line, boolean allowEnd) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getLineEndOffset, (String)"<this>");
        if (line < 0) {
            n = 0;
        } else if (line >= $this$getLineEndOffset.lineCount()) {
            n = (int)$this$getLineEndOffset.fileSize();
        } else {
            int endOffset;
            int startOffset = $this$getLineEndOffset.getLineStartOffset(line);
            if (startOffset == (endOffset = $this$getLineEndOffset.getLineEndOffset(line)) || allowEnd) {
                n = endOffset;
            } else {
                Integer n2 = Graphemes.INSTANCE.prev($this$getLineEndOffset.text(), endOffset);
                n = n2 != null ? n2 : endOffset;
            }
        }
        return n;
    }

    public static final int normalizeOffset(@NotNull VimEditor $this$normalizeOffset, int offset, boolean allowEnd) {
        int textLength;
        Intrinsics.checkNotNullParameter((Object)$this$normalizeOffset, (String)"<this>");
        int myOffset = offset;
        if (myOffset <= 0) {
            myOffset = 0;
        }
        if (myOffset > (textLength = $this$normalizeOffset.text().length())) {
            myOffset = textLength;
        }
        int line = $this$normalizeOffset.offsetToBufferPosition(myOffset).getLine();
        return EngineEditorHelperKt.normalizeOffset($this$normalizeOffset, line, myOffset, allowEnd);
    }

    public static /* synthetic */ int normalizeOffset$default(VimEditor vimEditor, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return EngineEditorHelperKt.normalizeOffset(vimEditor, n, bl);
    }

    public static final int normalizeVisualLine(@NotNull VimEditor $this$normalizeVisualLine, int visualLine) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeVisualLine, (String)"<this>");
        return RangesKt.coerceIn((int)visualLine, (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)RangesKt.coerceAtLeast((int)EngineEditorHelperKt.getVisualLineCount($this$normalizeVisualLine), (int)1))));
    }

    public static final int getVisualLineCount(@NotNull VimEditor $this$getVisualLineCount) {
        Intrinsics.checkNotNullParameter((Object)$this$getVisualLineCount, (String)"<this>");
        int count = $this$getVisualLineCount.lineCount();
        return count == 0 ? 0 : $this$getVisualLineCount.bufferLineToVisualLine(count - 1) + 1;
    }

    public static final int getLineStartForOffset(@NotNull VimEditor $this$getLineStartForOffset, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartForOffset, (String)"<this>");
        BufferPosition pos = $this$getLineStartForOffset.offsetToBufferPosition(EngineEditorHelperKt.normalizeOffset($this$getLineStartForOffset, offset, true));
        return $this$getLineStartForOffset.getLineStartOffset(pos.getLine());
    }

    public static final int getLineEndForOffset(@NotNull VimEditor $this$getLineEndForOffset, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineEndForOffset, (String)"<this>");
        BufferPosition pos = $this$getLineEndForOffset.offsetToBufferPosition(EngineEditorHelperKt.normalizeOffset($this$getLineEndForOffset, offset, true));
        return $this$getLineEndForOffset.getLineEndOffset(pos.getLine());
    }

    @NotNull
    public static final String getText(@NotNull VimEditor $this$getText, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        if (start == end) {
            return "";
        }
        CharSequence documentChars = $this$getText.text();
        return ((Object)documentChars.subSequence(EngineEditorHelperKt.normalizeOffset$default($this$getText, start, false, 2, null), EngineEditorHelperKt.normalizeOffset$default($this$getText, end, false, 2, null))).toString();
    }

    @NotNull
    public static final String getText(@NotNull VimEditor $this$getText, @NotNull TextRange range) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int len = range.size();
        if (len == 1) {
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            string = EngineEditorHelperKt.getText($this$getText, start, end);
        } else {
            StringBuilder res = new StringBuilder();
            int max = range.getMaxLength();
            for (int i = 0; i < len; ++i) {
                int end;
                int start;
                String line;
                if (i > 0 && ((CharSequence)res).length() > 0 && res.charAt(res.length() - 1) != '\n') {
                    res.append('\n');
                }
                if (((CharSequence)(line = EngineEditorHelperKt.getText($this$getText, start = range.getStartOffsets()[i], end = range.getEndOffsets()[i]))).length() == 0) {
                    int n = 0;
                    while (n < max) {
                        int it = n++;
                        boolean bl = false;
                        res.append(' ');
                    }
                    continue;
                }
                res.append(line);
            }
            String string2 = res.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    public static final int getOffset(@NotNull VimEditor $this$getOffset, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)$this$getOffset, (String)"<this>");
        return $this$getOffset.bufferPositionToOffset(new BufferPosition(line, column, false, 4, null));
    }

    @NotNull
    public static final CharBuffer getLineBuffer(@NotNull VimEditor $this$getLineBuffer, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineBuffer, (String)"<this>");
        int start = $this$getLineBuffer.getLineStartOffset(line);
        CharBuffer charBuffer = CharBuffer.wrap($this$getLineBuffer.text(), start, start + EngineEditorHelperKt.getLineEndOffset($this$getLineBuffer, line, true) - $this$getLineBuffer.getLineStartOffset(line));
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"wrap(...)");
        return charBuffer;
    }

    public static final boolean anyNonWhitespace(@NotNull VimEditor $this$anyNonWhitespace, int offset, int dir) {
        Intrinsics.checkNotNullParameter((Object)$this$anyNonWhitespace, (String)"<this>");
        int start = 0;
        int end = 0;
        int fileSize = (int)$this$anyNonWhitespace.fileSize();
        if (dir > 0) {
            start = RangesKt.coerceAtMost((int)(offset + 1), (int)(fileSize - 1));
            end = RangesKt.coerceAtMost((int)EngineEditorHelperKt.getLineEndForOffset($this$anyNonWhitespace, offset), (int)(fileSize - 1));
        } else {
            start = EngineEditorHelperKt.getLineStartForOffset($this$anyNonWhitespace, offset);
            end = RangesKt.coerceAtLeast((int)(offset - 1), (int)0);
        }
        CharSequence chars = $this$anyNonWhitespace.text();
        int i = start;
        if (i <= end) {
            while (true) {
                if (!Character.isWhitespace(chars.charAt(i))) {
                    return true;
                }
                if (i == end) break;
                ++i;
            }
        }
        return false;
    }

    public static final boolean isLineEmpty(@NotNull VimEditor $this$isLineEmpty, int line, boolean allowBlanks) {
        Intrinsics.checkNotNullParameter((Object)$this$isLineEmpty, (String)"<this>");
        CharSequence chars = $this$isLineEmpty.text();
        if (chars.length() == 0) {
            return true;
        }
        int offset = $this$isLineEmpty.getLineStartOffset(line);
        if (offset >= chars.length() || chars.charAt(offset) == '\n') {
            return true;
        }
        if (allowBlanks) {
            while (offset < chars.length()) {
                if (chars.charAt(offset) == '\n') {
                    return true;
                }
                if (!Character.isWhitespace(chars.charAt(offset))) {
                    return false;
                }
                ++offset;
            }
        }
        return false;
    }

    public static final int coerceOffset(@NotNull VimEditor $this$coerceOffset, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$coerceOffset, (String)"<this>");
        if (offset < 0) {
            return 0;
        }
        if ((long)offset > $this$coerceOffset.fileSize()) {
            return (int)$this$coerceOffset.fileSize();
        }
        return offset;
    }
}

