/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.helper.VimLockLabel;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH&J\b\u0010\r\u001a\u00020\tH&J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H&J\b\u0010\u0011\u001a\u00020\tH'J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0003H&J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H&J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H&R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\n\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\u0005\"\u0004\b\f\u0010\u0007R\u0018\u0010\u001e\u001a\u00020\u001fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u0004\u0018\u00010%X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006*\u00c0\u0006\u0003"}, d2={"Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "vimLastColumn", "", "getVimLastColumn", "()I", "setVimLastColumn", "(I)V", "resetLastColumn", "", "vimSelectionStart", "getVimSelectionStart", "setVimSelectionStart", "vimSelectionStartClear", "setSelection", "start", "end", "removeSelection", "moveToOffset", "offset", "moveToOffsetNative", "moveToInlayAwareOffset", "newOffset", "moveToBufferPosition", "position", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "moveToVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "setVimLastColumnAndGetCaret", "col", "vimInsertStart", "Lcom/maddyhome/idea/vim/common/LiveRange;", "getVimInsertStart", "()Lcom/maddyhome/idea/vim/common/LiveRange;", "setVimInsertStart", "(Lcom/maddyhome/idea/vim/common/LiveRange;)V", "vimLastVisualOperatorRange", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "getVimLastVisualOperatorRange", "()Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "setVimLastVisualOperatorRange", "(Lcom/maddyhome/idea/vim/group/visual/VisualChange;)V", "vim-engine"})
public interface VimCaret
extends ImmutableVimCaret {
    @Override
    public int getVimLastColumn();

    public void setVimLastColumn(int var1);

    public void resetLastColumn();

    @Override
    public int getVimSelectionStart();

    public void setVimSelectionStart(int var1);

    public void vimSelectionStartClear();

    public void setSelection(int var1, int var2);

    @VimLockLabel.RequiresWriteLock
    public void removeSelection();

    @NotNull
    default public VimCaret moveToOffset(int offset) {
        VimCaret vimCaret;
        if (offset < 0 || offset > this.getEditor().text().length() || !this.isValid()) {
            return this;
        }
        if (EditorExtensionsKt.getInBlockSelection(this.getEditor())) {
            StrictMode.INSTANCE.assertTrue(Intrinsics.areEqual((Object)this, (Object)this.getEditor().primaryCaret()), "Block selection can only be moved with primary caret!");
            EngineVisualGroupKt.vimMoveBlockSelectionToOffset(this.getEditor(), offset);
            VimInjectorKt.getInjector().getScroll().scrollCaretIntoView(this.getEditor());
            return this;
        }
        int oldOffset = this.getOffset();
        VimCaret updatedCaret = this.moveToInlayAwareOffset(offset);
        if (Intrinsics.areEqual((Object)this, (Object)this.getEditor().primaryCaret())) {
            VimInjectorKt.getInjector().getScroll().scrollCaretIntoView(this.getEditor());
        }
        if (EditorExtensionsKt.getInVisualMode(this.getEditor()) || EditorExtensionsKt.getInSelectMode(this.getEditor()) || EditorExtensionsKt.getInCommandLineModeWithVisual(this.getEditor())) {
            EngineVisualGroupKt.vimMoveSelectionToCaret(updatedCaret, this.getVimSelectionStart());
            vimCaret = (VimCaret)this.getEditor().findLastVersionOfCaret((ImmutableVimCaret)updatedCaret);
            if (vimCaret == null) {
                vimCaret = updatedCaret;
            }
        } else {
            EngineModeExtensionsKt.exitVisualMode(this.getEditor());
            vimCaret = updatedCaret;
        }
        updatedCaret = vimCaret;
        return updatedCaret;
    }

    public void moveToOffsetNative(int var1);

    @NotNull
    public VimCaret moveToInlayAwareOffset(int var1);

    public void moveToBufferPosition(@NotNull BufferPosition var1);

    public void moveToVisualPosition(@NotNull VimVisualPosition var1);

    @NotNull
    public VimCaret setVimLastColumnAndGetCaret(int var1);

    @NotNull
    public LiveRange getVimInsertStart();

    public void setVimInsertStart(@NotNull LiveRange var1);

    @Nullable
    public VisualChange getVimLastVisualOperatorRange();

    public void setVimLastVisualOperatorRange(@Nullable VisualChange var1);

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static VimCaret moveToOffset(@NotNull VimCaret $this, int offset) {
            return $this.moveToOffset(offset);
        }
    }
}

