/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimFile;
import com.maddyhome.idea.vim.api.VimFileBaseKt;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.WordCount;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/api/VimFileBase;", "Lcom/maddyhome/idea/vim/api/VimFile;", "<init>", "()V", "displayHexInfo", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "displayLocationInfo", "vim-engine"})
public abstract class VimFileBase
implements VimFile {
    @Override
    public void displayHexInfo(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int offset = editor.currentCaret().getOffset();
        char ch = editor.text().charAt(offset);
        VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, Long.toHexString(ch));
    }

    @Override
    public void displayLocationInfo(@NotNull VimEditor editor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        StringBuilder $this$displayLocationInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        VimCaret caret = editor.currentCaret();
        int offset = editor.currentCaret().getOffset();
        long totalByteCount = editor.fileSize();
        WordCount totalWordCount = VimFileBaseKt.countBigWords$default(editor, offset, 0, 0, 12, null);
        if (!EditorExtensionsKt.getInVisualMode(editor)) {
            BufferPosition pos = caret.getBufferPosition();
            int line = pos.getLine() + 1;
            int col = pos.getColumn() + 1;
            int lineEndOffset = editor.getLineEndOffset(pos.getLine());
            int lineEndCol = editor.offsetToBufferPosition(lineEndOffset).getColumn();
            $this$displayLocationInfo_u24lambda_u240.append("Col ").append(col).append(" of ").append(lineEndCol);
            $this$displayLocationInfo_u24lambda_u240.append("; Line ").append(line).append(" of ").append(editor.lineCount());
            $this$displayLocationInfo_u24lambda_u240.append("; Word ").append(totalWordCount.getCurrentWord()).append(" of ").append(totalWordCount.getCount());
            v0 = $this$displayLocationInfo_u24lambda_u240.append("; Byte ").append(offset + 1).append(" of ").append(totalByteCount);
        } else {
            $this$displayLocationInfo_u24lambda_u240.append("Selected ");
            int n = caret.getVimSelectionStart();
            int n2 = caret.getOffset();
            SelectionType selectionType = ModeExtensionsKt.getSelectionType(editor.getMode());
            if (selectionType == null) {
                selectionType = SelectionType.CHARACTER_WISE;
            }
            TextRange selection = VimSelection.toVimTextRange$default(VimSelection.Companion.create(n, n2, selectionType, editor), false, 1, null);
            int selectedLineCount = 0;
            int selectedWordCount = 0;
            if (selection.isMultiple()) {
                selectedLineCount = selection.size();
                int count = 0;
                int n3 = selection.size();
                for (int i = 0; i < n3; ++i) {
                    WordCount wordCount = VimFileBaseKt.access$countBigWords(editor, offset, selection.getStartOffsets()[i], selection.getEndOffsets()[i]);
                    count += wordCount.getCount();
                }
                selectedWordCount = count;
                $this$displayLocationInfo_u24lambda_u240.append(selection.getMaxLength()).append(" Cols; ");
            } else {
                BufferPosition startPos = editor.offsetToBufferPosition(selection.getStartOffset());
                BufferPosition endPos = editor.offsetToBufferPosition(EngineHelperKt.getEndOffsetInclusive(selection));
                selectedLineCount = endPos.getLine() - startPos.getLine() + 1;
                WordCount wordCount = VimFileBaseKt.access$countBigWords(editor, offset, selection.getStartOffset(), selection.getEndOffset());
                selectedWordCount = wordCount.getCount();
            }
            $this$displayLocationInfo_u24lambda_u240.append(selectedLineCount).append(" of ").append(editor.lineCount()).append(" Lines; ");
            $this$displayLocationInfo_u24lambda_u240.append(selectedWordCount).append(" of ").append(totalWordCount.getCount()).append(" Words; ");
            v0 = $this$displayLocationInfo_u24lambda_u240.append(selection.getSelectionCount()).append(" of ").append(totalByteCount).append(" Bytes");
        }
        String msg = stringBuilder.toString();
        VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, msg);
    }
}

