/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimJumpService;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.mark.Jump;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\t\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\r\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n\u001a\"\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n\u00a8\u0006\u0015"}, d2={"addJump", "", "Lcom/maddyhome/idea/vim/api/VimJumpService;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "reset", "", "getJump", "Lcom/maddyhome/idea/vim/mark/Jump;", "count", "", "getJumps", "", "getJumpSpot", "jump", "removeJump", "dropLastJump", "updateJumpsFromInsert", "startOffset", "length", "updateJumpsFromDelete", "vim-engine"})
public final class VimJumpServiceKt {
    public static final void addJump(@NotNull VimJumpService $this$addJump, @NotNull VimEditor editor, boolean reset) {
        Intrinsics.checkNotNullParameter((Object)$this$addJump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimVirtualFile vimVirtualFile = editor.getVirtualFile();
        if (vimVirtualFile == null) {
            return;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String path = virtualFile.getPath();
        String protocol = virtualFile.getProtocol();
        BufferPosition position = editor.offsetToBufferPosition(editor.currentCaret().getOffset());
        Jump jump = new Jump(position.getLine(), position.getColumn(), path, protocol);
        VimJumpServiceKt.addJump($this$addJump, editor, jump, reset);
    }

    @Nullable
    public static final Jump getJump(@NotNull VimJumpService $this$getJump, @NotNull VimEditor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$getJump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return $this$getJump.getJump(editor.getProjectId(), count);
    }

    @NotNull
    public static final List<Jump> getJumps(@NotNull VimJumpService $this$getJumps, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)$this$getJumps, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return $this$getJumps.getJumps(editor.getProjectId());
    }

    public static final int getJumpSpot(@NotNull VimJumpService $this$getJumpSpot, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)$this$getJumpSpot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return $this$getJumpSpot.getJumpSpot(editor.getProjectId());
    }

    public static final void addJump(@NotNull VimJumpService $this$addJump, @NotNull VimEditor editor, @NotNull Jump jump, boolean reset) {
        Intrinsics.checkNotNullParameter((Object)$this$addJump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        $this$addJump.addJump(editor.getProjectId(), jump, reset);
    }

    public static final void removeJump(@NotNull VimJumpService $this$removeJump, @NotNull VimEditor editor, @NotNull Jump jump) {
        Intrinsics.checkNotNullParameter((Object)$this$removeJump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        $this$removeJump.removeJump(editor.getProjectId(), jump);
    }

    public static final void dropLastJump(@NotNull VimJumpService $this$dropLastJump, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)$this$dropLastJump, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        $this$dropLastJump.dropLastJump(editor.getProjectId());
    }

    public static final void updateJumpsFromInsert(@NotNull VimJumpService $this$updateJumpsFromInsert, @NotNull VimEditor editor, int startOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$updateJumpsFromInsert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        $this$updateJumpsFromInsert.updateJumpsFromInsert(editor.getProjectId(), startOffset, length);
    }

    public static final void updateJumpsFromDelete(@NotNull VimJumpService $this$updateJumpsFromDelete, @NotNull VimEditor editor, int startOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$updateJumpsFromDelete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        $this$updateJumpsFromDelete.updateJumpsFromDelete(editor.getProjectId(), startOffset, length);
    }
}

