/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualMotionGroup;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.group.visual.VisualOperation;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.VimLockLabel;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0004R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/api/VimVisualMotionGroupBase;", "Lcom/maddyhome/idea/vim/api/VimVisualMotionGroup;", "<init>", "()V", "exclusiveSelection", "", "getExclusiveSelection", "()Z", "selectionAdj", "", "getSelectionAdj", "()I", "enterVisualMode", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "selectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "returnTo", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "enterSelectMode", "toggleVisual", "count", "rawCount", "toggleSelectVisual", "", "adjustCaretsForSelectionPolicy", "previouslyExclusive", "processSingleVisualCommand", "detectSelectionType", "seemsLikeBlockMode", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimVisualMotionGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimVisualMotionGroupBase.kt\ncom/maddyhome/idea/vim/api/VimVisualMotionGroupBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1869#2,2:256\n1869#2,2:258\n1740#2,3:260\n1563#2:263\n1634#2,3:264\n1056#2:267\n1878#2,3:269\n1869#2,2:272\n1#3:268\n*S KotlinDebug\n*F\n+ 1 VimVisualMotionGroupBase.kt\ncom/maddyhome/idea/vim/api/VimVisualMotionGroupBase\n*L\n164#1:256,2\n171#1:258,2\n212#1:260,3\n228#1:263\n228#1:264,3\n231#1:267\n236#1:269,3\n42#1:272,2\n*E\n"})
public abstract class VimVisualMotionGroupBase
implements VimVisualMotionGroup {
    @Override
    public boolean getExclusiveSelection() {
        return StringsKt.contains$default((CharSequence)VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSelection(), (CharSequence)"exclusive", (boolean)false, (int)2, null);
    }

    @Override
    public int getSelectionAdj() {
        return this.getExclusiveSelection() ? 0 : 1;
    }

    @Override
    public boolean enterVisualMode(@NotNull VimEditor editor, @NotNull SelectionType selectionType, @NotNull Mode returnTo) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        Intrinsics.checkNotNullParameter((Object)returnTo, (String)"returnTo");
        editor.setMode(new Mode.VISUAL(selectionType, returnTo));
        VimInjectorKt.getInjector().getApplication().runReadAction(() -> VimVisualMotionGroupBase.enterVisualMode$lambda$2(selectionType, editor));
        return true;
    }

    @Override
    public boolean enterSelectMode(@NotNull VimEditor editor, @NotNull SelectionType selectionType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        Mode mode = editor.getMode();
        editor.setMode(mode instanceof Mode.VISUAL && ((Mode.VISUAL)mode).isSelectPending() ? ((Mode.VISUAL)mode).getReturnTo() : (mode instanceof Mode.VISUAL || mode instanceof Mode.SELECT ? (Mode)new Mode.SELECT(selectionType, mode.getReturnTo()) : (mode instanceof Mode.NORMAL ? (Mode)new Mode.SELECT(selectionType, ((Mode.NORMAL)mode).getReturnTo()) : (Mode)new Mode.SELECT(selectionType, mode))));
        VimInjectorKt.getInjector().getApplication().runReadAction(() -> VimVisualMotionGroupBase.enterSelectMode$lambda$4(editor));
        return true;
    }

    @Override
    public boolean toggleVisual(@NotNull VimEditor editor, int count, int rawCount, @NotNull SelectionType selectionType, @Nullable Mode returnTo) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        if (!EditorExtensionsKt.getInVisualMode(editor)) {
            if (rawCount > 0) {
                Object object = editor.primaryCaret().getVimLastVisualOperatorRange();
                if (object == null || (object = object.getType()) == null) {
                    object = selectionType;
                }
                Object primarySelectionType = object;
                editor.setMode(new Mode.VISUAL((SelectionType)((Object)primarySelectionType), editor.getMode().getReturnTo()));
                editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> VimVisualMotionGroupBase.toggleVisual$lambda$5(selectionType, editor, count, arg_0)));
            } else {
                Mode mode = returnTo;
                if (mode == null) {
                    mode = editor.getMode().getReturnTo();
                }
                editor.setMode(new Mode.VISUAL(selectionType, mode));
                editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)VimVisualMotionGroupBase::toggleVisual$lambda$6));
            }
            return true;
        }
        if (selectionType == ModeExtensionsKt.getSelectionType(editor.getMode())) {
            EngineModeExtensionsKt.exitVisualMode(editor);
            return true;
        }
        Mode mode = editor.getMode();
        if (!(mode instanceof Mode.VISUAL)) {
            throw new IllegalStateException("Check failed.");
        }
        editor.setMode(Mode.VISUAL.copy$default((Mode.VISUAL)mode, selectionType, null, 2, null));
        for (VimCaret caret : editor.carets()) {
            if (!caret.isValid()) continue;
            EngineVisualGroupKt.vimUpdateEditorSelection(caret);
        }
        return true;
    }

    @Override
    public void toggleSelectVisual(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Mode mode = editor.getMode();
        if (mode instanceof Mode.VISUAL) {
            boolean previouslyExclusive = this.getExclusiveSelection();
            this.enterSelectMode(editor, ((Mode.VISUAL)mode).getSelectionType());
            this.adjustCaretsForSelectionPolicy(editor, previouslyExclusive);
        } else if (mode instanceof Mode.SELECT) {
            boolean previouslyExclusive = true;
            this.enterVisualMode(editor, ((Mode.SELECT)mode).getSelectionType());
            this.adjustCaretsForSelectionPolicy(editor, previouslyExclusive);
        }
    }

    private final void adjustCaretsForSelectionPolicy(VimEditor editor, boolean previouslyExclusive) {
        block2: {
            boolean isSelectionExclusive;
            block3: {
                Mode mode = editor.getMode();
                boolean bl = isSelectionExclusive = this.getExclusiveSelection() || mode instanceof Mode.SELECT;
                if (ModeExtensionsKt.getSelectionType(mode) == SelectionType.LINE_WISE) break block2;
                if (!isSelectionExclusive || previouslyExclusive) break block3;
                Iterable $this$forEach$iv = editor.nativeCarets();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VimCaret it = (VimCaret)element$iv;
                    boolean bl2 = false;
                    if (it.getOffset() != it.getSelectionEnd() - 1) continue;
                    it.moveToInlayAwareOffset(it.getSelectionEnd());
                }
                break block2;
            }
            if (isSelectionExclusive || !previouslyExclusive) break block2;
            Iterable $this$forEach$iv = editor.nativeCarets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                if (it.getOffset() != it.getSelectionEnd() || it.getVisualLineStart() >= it.getOffset()) continue;
                it.moveToInlayAwareOffset(it.getSelectionEnd() - 1);
            }
        }
    }

    @Override
    public void processSingleVisualCommand(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Mode mode = editor.getMode();
        if (mode instanceof Mode.SELECT) {
            boolean previouslyExclusive = true;
            editor.setMode(new Mode.VISUAL(((Mode.SELECT)mode).getSelectionType(), mode));
            this.adjustCaretsForSelectionPolicy(editor, previouslyExclusive);
        } else if (mode instanceof Mode.VISUAL && ((Mode.VISUAL)mode).isSelectPending()) {
            this.toggleSelectVisual(editor);
        }
    }

    @Override
    @VimLockLabel.RequiresReadLock
    @NotNull
    public SelectionType detectSelectionType(@NotNull VimEditor editor) {
        boolean all;
        block5: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (editor.carets().size() > 1 && this.seemsLikeBlockMode(editor)) {
                return SelectionType.BLOCK_WISE;
            }
            Iterable $this$all$iv = editor.nativeCarets();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VimCaret caret = (VimCaret)element$iv;
                    boolean bl = false;
                    int selectionStart = caret.getSelectionStart();
                    int selectionEnd = caret.getSelectionEnd();
                    int startLine = editor.offsetToBufferPosition(selectionStart).getLine();
                    BufferPosition endPosition = editor.offsetToBufferPosition(selectionEnd);
                    int endLine = endPosition.getColumn() == 0 ? RangesKt.coerceAtLeast((int)(endPosition.getLine() - 1), (int)0) : endPosition.getLine();
                    int lineStartOfSelectionStart = editor.getLineStartOffset(startLine);
                    int lineEndOfSelectionEnd = EngineEditorHelperKt.getLineEndOffset(editor, endLine, true);
                    if (lineStartOfSelectionStart == selectionStart && (lineEndOfSelectionEnd + 1 == selectionEnd || lineEndOfSelectionEnd == selectionEnd)) continue;
                    v0 = false;
                    break block5;
                }
                v0 = all = true;
            }
        }
        if (all) {
            return SelectionType.LINE_WISE;
        }
        return SelectionType.CHARACTER_WISE;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean seemsLikeBlockMode(@NotNull VimEditor editor) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$map$iv = editor.nativeCarets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VimCaret vimCaret = (VimCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int adj = editor.offsetToBufferPosition(it.getSelectionEnd()).getColumn() == 0 ? 1 : 0;
            collection.add(TuplesKt.to((Object)it.getSelectionStart(), (Object)RangesKt.coerceAtLeast((int)(it.getSelectionEnd() - adj), (int)0)));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List selections = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        int selectionStartColumn = editor.offsetToBufferPosition(((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue()).getColumn();
        int selectionStartLine = editor.offsetToBufferPosition(((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue()).getLine();
        Iterator iterator = ((Iterable)selections).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            Pair it = (Pair)iterator.next();
            boolean bl = false;
            Object object2 = editor.offsetToBufferPosition(((Number)it.getSecond()).intValue()).getColumn();
            while (iterator.hasNext()) {
                Object it2 = (Pair)iterator.next();
                $i$a$-maxOfOrNull-VimVisualMotionGroupBase$seemsLikeBlockMode$maxColumn$1 = false;
                if (object2.compareTo(it2 = (Comparable)Integer.valueOf(editor.offsetToBufferPosition(((Number)it2.getSecond()).intValue()).getColumn())) >= 0) continue;
                object2 = it2;
            }
            object = object2;
        }
        Integer n = (Integer)object;
        if (n == null) {
            return false;
        }
        int maxColumn = n;
        Iterable $this$forEachIndexed$iv = selections;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair adj = (Pair)item$iv;
            int i = n2;
            boolean bl = false;
            if (editor.offsetToBufferPosition(((Number)it.getFirst()).intValue()).getLine() != editor.offsetToBufferPosition(((Number)it.getSecond()).intValue()).getLine()) {
                return false;
            }
            if (editor.offsetToBufferPosition(((Number)it.getFirst()).intValue()).getColumn() != selectionStartColumn) {
                return false;
            }
            int lineEnd = editor.offsetToBufferPosition(EngineEditorHelperKt.getLineEndForOffset(editor, ((Number)it.getSecond()).intValue())).getColumn();
            if (editor.offsetToBufferPosition(((Number)it.getSecond()).intValue()).getColumn() != RangesKt.coerceAtMost((int)maxColumn, (int)lineEnd)) {
                return false;
            }
            if (editor.offsetToBufferPosition(((Number)it.getFirst()).intValue()).getLine() == selectionStartLine + i) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean enterVisualMode(@NotNull VimEditor editor, @NotNull SelectionType selectionType) {
        return VimVisualMotionGroup.super.enterVisualMode(editor, selectionType);
    }

    private static final Unit enterVisualMode$lambda$2(SelectionType $selectionType, VimEditor $editor) {
        if ($selectionType == SelectionType.BLOCK_WISE) {
            VimCaret $this$enterVisualMode_u24lambda_u242_u24lambda_u240 = $editor.primaryCaret();
            boolean bl = false;
            $this$enterVisualMode_u24lambda_u242_u24lambda_u240.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset($this$enterVisualMode_u24lambda_u242_u24lambda_u240));
        } else {
            Iterable $this$forEach$iv = $editor.nativeCarets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                it.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset(it));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit enterSelectMode$lambda$4$lambda$3(VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset(it));
        return Unit.INSTANCE;
    }

    private static final Unit enterSelectMode$lambda$4(VimEditor $editor) {
        $editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)VimVisualMotionGroupBase::enterSelectMode$lambda$4$lambda$3));
        return Unit.INSTANCE;
    }

    private static final Unit toggleVisual$lambda$5(SelectionType $selectionType, VimEditor $editor, int $count, VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VisualChange visualChange = it.getVimLastVisualOperatorRange();
        if (visualChange == null) {
            visualChange = VisualChange.Companion.default($selectionType);
        }
        VisualChange range = visualChange;
        int end = VisualOperation.INSTANCE.calculateRange($editor, range, $count, it);
        int intendedColumn = range.getColumns() == 9999 ? 9999 : $editor.offsetToBufferPosition(end).getColumn();
        it.setVimLastColumn(intendedColumn);
        EngineVisualGroupKt.vimSetSelection(it, it.getOffset(), end, true);
        it.setVimLastColumn(intendedColumn);
        return Unit.INSTANCE;
    }

    private static final Unit toggleVisual$lambda$6(VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EngineVisualGroupKt.vimSetSelection$default(it, it.getOffset(), 0, false, 6, null);
        return Unit.INSTANCE;
    }
}

