/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.DuplicableOperatorAction;
import com.maddyhome.idea.vim.common.CurrentCommandState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.ExternalActionHandler;
import com.maddyhome.idea.vim.handler.MotionActionHandler;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.key.KeyStrokeTrie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 X2\u00020\u0001:\u0001XBA\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0006\u0010,\u001a\u00020\u0007J\u0006\u00100\u001a\u00020)J\u0006\u00101\u001a\u000202J\u0006\u00107\u001a\u000202J\u0006\u00108\u001a\u00020)J\u0006\u0010:\u001a\u00020)J\u000e\u0010;\u001a\u0002022\u0006\u0010<\u001a\u00020\tJ\u0006\u0010=\u001a\u000202J\u000e\u0010?\u001a\u0002022\u0006\u0010<\u001a\u00020\tJ\u000e\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\u0012J\u000e\u0010B\u001a\u0002022\u0006\u0010<\u001a\u00020\tJ\u000e\u0010C\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010D\u001a\u0002022\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010E\u001a\u00020)2\u0006\u0010<\u001a\u00020\t2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002020GJ\u000e\u0010H\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tJ\u0006\u0010I\u001a\u00020)J\u0006\u0010J\u001a\u00020KJ\u0014\u0010L\u001a\u0002022\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010M\u001a\u0002022\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\t0PH\u0007J\u0013\u0010Q\u001a\u00020)2\b\u0010R\u001a\u0004\u0018\u00010SH\u0096\u0002J\b\u0010T\u001a\u00020\u0007H\u0016J\b\u0010U\u001a\u00020\u0000H\u0016J\b\u0010V\u001a\u00020WH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00078B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0011\u0010+\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010*R\u0013\u0010-\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0013\u00103\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010*R\u0011\u00109\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010*R\u001e\u0010>\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010*\u00a8\u0006Y"}, d2={"Lcom/maddyhome/idea/vim/command/CommandBuilder;", "", "keyStrokeTrie", "Lcom/maddyhome/idea/vim/key/KeyStrokeTrie;", "Lcom/maddyhome/idea/vim/action/change/LazyVimCommand;", "counts", "", "", "typedKeyStrokes", "Ljavax/swing/KeyStroke;", "commandKeyStrokes", "<init>", "(Lcom/maddyhome/idea/vim/key/KeyStrokeTrie;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "initialUncommittedRawCount", "(Lcom/maddyhome/idea/vim/key/KeyStrokeTrie;I)V", "commandState", "Lcom/maddyhome/idea/vim/common/CurrentCommandState;", "selectedRegister", "", "Ljava/lang/Character;", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "fallbackArgumentType", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "motionArgument", "Lcom/maddyhome/idea/vim/command/Argument$Motion;", "getMotionArgument", "()Lcom/maddyhome/idea/vim/command/Argument$Motion;", "value", "currentCount", "getCurrentCount", "()I", "setCurrentCount", "(I)V", "keys", "", "getKeys", "()Ljava/lang/Iterable;", "isEmpty", "", "()Z", "isReady", "calculateCount0Snapshot", "registerSnapshot", "getRegisterSnapshot", "()Ljava/lang/Character;", "hasCurrentCommandPartArgument", "resetCount", "", "expectedArgumentType", "getExpectedArgumentType", "()Lcom/maddyhome/idea/vim/command/Argument$Type;", "isAwaitingArgument", "fallbackToCharacterArgument", "isAwaitingCharOrDigraphArgument", "isExpectingCount", "hasCountCharacters", "addCountCharacter", "key", "deleteCountCharacter", "isRegisterPending", "startWaitingForRegister", "selectRegister", "register", "addTypedKeyStroke", "addAction", "addArgument", "processKey", "processor", "Lkotlin/Function1;", "convertDuplicateOperatorKeyStrokeToMotion", "isBuildingMultiKeyCommand", "buildCommand", "Lcom/maddyhome/idea/vim/command/Command;", "resetAll", "resetCommandTrie", "getCurrentTrie", "getCurrentCommandKeys", "", "equals", "other", "", "hashCode", "clone", "toString", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBuilder.kt\ncom/maddyhome/idea/vim/command/CommandBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 5 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n*L\n1#1,430:1\n1740#2,3:431\n1563#2:434\n1634#2,3:435\n2783#2,7:438\n1#3:445\n33#4,4:446\n27#4,4:450\n27#4,4:454\n27#4,4:458\n27#4,4:462\n27#4,4:466\n27#4,4:470\n27#4,4:474\n27#4,4:478\n33#4,4:482\n38#4:487\n19#5:486\n*S KotlinDebug\n*F\n+ 1 CommandBuilder.kt\ncom/maddyhome/idea/vim/command/CommandBuilder\n*L\n87#1:431,3\n87#1:434\n87#1:435,3\n87#1:438,7\n138#1:446,4\n183#1:450,4\n197#1:454,4\n208#1:458,4\n269#1:462,4\n278#1:466,4\n282#1:470,4\n298#1:474,4\n304#1:478,4\n320#1:482,4\n427#1:487\n331#1:486\n*E\n"})
public final class CommandBuilder
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private KeyStrokeTrie<LazyVimCommand> keyStrokeTrie;
    @NotNull
    private final List<Integer> counts;
    @NotNull
    private final List<KeyStroke> typedKeyStrokes;
    @NotNull
    private final List<KeyStroke> commandKeyStrokes;
    @NotNull
    private CurrentCommandState commandState;
    @Nullable
    private Character selectedRegister;
    @Nullable
    private EditorActionHandlerBase action;
    @Nullable
    private Argument argument;
    @Nullable
    private Argument.Type fallbackArgumentType;
    private boolean isRegisterPending;
    @NotNull
    private static final VimLogger logger;

    private CommandBuilder(KeyStrokeTrie<LazyVimCommand> keyStrokeTrie, List<Integer> counts, List<KeyStroke> typedKeyStrokes, List<KeyStroke> commandKeyStrokes) {
        this.keyStrokeTrie = keyStrokeTrie;
        this.counts = counts;
        this.typedKeyStrokes = typedKeyStrokes;
        this.commandKeyStrokes = commandKeyStrokes;
        this.commandState = CurrentCommandState.NEW_COMMAND;
    }

    public CommandBuilder(@NotNull KeyStrokeTrie<LazyVimCommand> keyStrokeTrie, int initialUncommittedRawCount) {
        Intrinsics.checkNotNullParameter(keyStrokeTrie, (String)"keyStrokeTrie");
        Object[] objectArray = new Integer[]{initialUncommittedRawCount};
        this(keyStrokeTrie, CollectionsKt.mutableListOf((Object[])objectArray), new ArrayList(), new ArrayList());
    }

    public /* synthetic */ CommandBuilder(KeyStrokeTrie keyStrokeTrie, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(keyStrokeTrie, n);
    }

    private final Argument.Motion getMotionArgument() {
        Argument argument = this.argument;
        return argument instanceof Argument.Motion ? (Argument.Motion)argument : null;
    }

    private final int getCurrentCount() {
        return ((Number)CollectionsKt.last(this.counts)).intValue();
    }

    private final void setCurrentCount(int value) {
        this.counts.set(this.counts.size() - 1, value);
    }

    @NotNull
    public final Iterable<KeyStroke> getKeys() {
        return this.typedKeyStrokes;
    }

    public final boolean isEmpty() {
        return this.commandState == CurrentCommandState.NEW_COMMAND && this.selectedRegister == null && this.counts.size() == 1 && this.action == null && this.argument == null && this.fallbackArgumentType == null;
    }

    public final boolean isReady() {
        return this.commandState == CurrentCommandState.READY;
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateCount0Snapshot() {
        int n;
        boolean bl;
        block8: {
            Iterable $this$all$iv = this.counts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (it == 0) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            n = 0;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.counts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            int $i$f$mapTo = 0;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n2 = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(RangesKt.coerceAtLeast((int)it, (int)1));
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl4 = false;
                accumulator$iv = acc * i;
            }
            n = ((Number)accumulator$iv).intValue();
        }
        return n;
    }

    @Nullable
    public final Character getRegisterSnapshot() {
        return this.selectedRegister;
    }

    public final boolean hasCurrentCommandPartArgument() {
        return this.getMotionArgument() != null || this.argument != null;
    }

    public final void resetCount() {
        this.counts.set(this.counts.size() - 1, 0);
    }

    @Nullable
    public final Argument.Type getExpectedArgumentType() {
        Argument.Type type = this.fallbackArgumentType;
        if (type == null) {
            Argument.Motion motion = this.getMotionArgument();
            if (motion != null) {
                Argument.Motion it = motion;
                boolean bl = false;
                return it.getMotion().getArgumentType();
            }
            EditorActionHandlerBase editorActionHandlerBase = this.action;
            type = editorActionHandlerBase != null ? editorActionHandlerBase.getArgumentType() : null;
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAwaitingArgument() {
        if (this.getExpectedArgumentType() == null) return false;
        Argument.Motion motion = this.getMotionArgument();
        if (motion != null) {
            Argument.Motion it = motion;
            boolean bl = false;
            if (it.getArgument() != null) return false;
            return true;
        }
        if (this.argument != null) return false;
        return true;
    }

    public final void fallbackToCharacterArgument() {
        boolean bl;
        logger.trace("fallbackToCharacterArgument is executed");
        boolean bl2 = bl = this.getExpectedArgumentType() == Argument.Type.DIGRAPH;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cannot move state from " + this.getExpectedArgumentType() + " to CHARACTER";
            throw new AssertionError((Object)string);
        }
        this.fallbackArgumentType = Argument.Type.CHARACTER;
    }

    public final boolean isAwaitingCharOrDigraphArgument() {
        boolean awaiting = this.getExpectedArgumentType() == Argument.Type.CHARACTER || this.getExpectedArgumentType() == Argument.Type.DIGRAPH;
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Awaiting char or digraph: " + awaiting);
        }
        return awaiting;
    }

    public final boolean isExpectingCount() {
        return this.commandState == CurrentCommandState.NEW_COMMAND && !this.isRegisterPending && this.getExpectedArgumentType() != Argument.Type.CHARACTER && this.getExpectedArgumentType() != Argument.Type.DIGRAPH;
    }

    public final boolean hasCountCharacters() {
        return this.getCurrentCount() > 0;
    }

    public final void addCountCharacter(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.setCurrentCount(this.getCurrentCount() * 10 + (key.getKeyChar() - 48));
        if (this.getCurrentCount() < 0) {
            this.setCurrentCount(999999999);
        }
        this.addTypedKeyStroke(key);
    }

    public final void deleteCountCharacter() {
        this.setCurrentCount(this.getCurrentCount() / 10);
        this.typedKeyStrokes.removeLast();
    }

    public final boolean isRegisterPending() {
        return this.isRegisterPending;
    }

    public final void startWaitingForRegister(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.isRegisterPending = true;
        this.addTypedKeyStroke(key);
    }

    public final void selectRegister(char register) {
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Selected register '" + register + "'");
        }
        this.selectedRegister = Character.valueOf(register);
        this.isRegisterPending = false;
        this.fallbackArgumentType = null;
        this.counts.add(0);
    }

    public final void addTypedKeyStroke(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("added key to command builder: " + key);
        }
        this.typedKeyStrokes.add(key);
    }

    public final void addAction(@NotNull EditorActionHandlerBase action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("addAction is executed. action = " + action);
        }
        if (this.action == null) {
            this.action = action;
        } else {
            Argument.Motion motion;
            StrictMode.INSTANCE.assertTrue(this.argument == null, "Command builder already has an action and a fully populated argument");
            EditorActionHandlerBase editorActionHandlerBase = action;
            if (editorActionHandlerBase instanceof MotionActionHandler) {
                motion = new Argument.Motion((MotionActionHandler)action, null);
            } else if (editorActionHandlerBase instanceof TextObjectActionHandler) {
                motion = new Argument.Motion((TextObjectActionHandler)action);
            } else if (editorActionHandlerBase instanceof ExternalActionHandler) {
                motion = new Argument.Motion((ExternalActionHandler)action);
            } else {
                throw new RuntimeException("Unexpected action type: " + action);
            }
            this.argument = motion;
        }
        this.counts.add(0);
        this.fallbackArgumentType = null;
        if (!this.isAwaitingArgument()) {
            logger.trace("Action does not require an argument. Setting command state to READY");
            this.commandState = CurrentCommandState.READY;
        }
    }

    public final void addArgument(@NotNull Argument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        logger.trace("addArgument is executed");
        Argument.Motion motion = this.getMotionArgument();
        this.argument = motion != null && (motion = motion.withArgument(argument)) != null ? (Argument)motion : argument;
        this.fallbackArgumentType = null;
        if (!this.isAwaitingArgument()) {
            logger.trace("Argument is simple type, or motion with own argument. No further argument required. Setting command state to READY");
            this.commandState = CurrentCommandState.READY;
        }
    }

    public final boolean processKey(@NotNull KeyStroke key, @NotNull Function1<? super EditorActionHandlerBase, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.commandKeyStrokes.add(key);
        KeyStrokeTrie.TrieNode<LazyVimCommand> node = this.keyStrokeTrie.getTrieNode(this.commandKeyStrokes);
        if (node == null) {
            VimLogger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTrace()) {
                VimLogger vimLogger = $this$trace$iv;
                boolean bl = false;
                vimLogger.trace("No command or part command for key sequence: " + VimInjectorKt.getInjector().getParser().toPrintableString(this.commandKeyStrokes));
            }
            this.commandKeyStrokes.clear();
            return false;
        }
        this.addTypedKeyStroke(key);
        LazyVimCommand command = node.getData();
        if (command == null) {
            VimLogger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTrace()) {
                VimLogger vimLogger = $this$trace$iv;
                boolean bl = false;
                vimLogger.trace("Found unfinished key sequence for " + VimInjectorKt.getInjector().getParser().toPrintableString(this.commandKeyStrokes) + " - " + node.getDebugString());
            }
            return true;
        }
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Found command for " + VimInjectorKt.getInjector().getParser().toPrintableString(this.commandKeyStrokes) + " - " + node.getDebugString());
        }
        this.commandKeyStrokes.clear();
        processor.invoke(command.getInstance());
        return true;
    }

    @NotNull
    public final KeyStroke convertDuplicateOperatorKeyStrokeToMotion(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("convertDuplicateOperatorKeyStrokeToMotion is executed. key = " + key);
        }
        if (this.action != null && this.argument == null) {
            EditorActionHandlerBase editorActionHandlerBase = this.action;
            DuplicableOperatorAction duplicableOperatorAction = editorActionHandlerBase instanceof DuplicableOperatorAction ? (DuplicableOperatorAction)((Object)editorActionHandlerBase) : null;
            if (duplicableOperatorAction != null) {
                DuplicableOperatorAction it = duplicableOperatorAction;
                boolean bl = false;
                VimLogger $this$trace$iv2 = logger;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTrace()) {
                    VimLogger vimLogger = $this$trace$iv2;
                    boolean bl2 = false;
                    vimLogger.trace("action = " + this.action);
                }
                if (it.getDuplicateWith() == key.getKeyChar()) {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke('_');
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
                    return keyStroke;
                }
            }
        }
        return key;
    }

    public final boolean isBuildingMultiKeyCommand() {
        boolean isMultikey = !((Collection)this.commandKeyStrokes).isEmpty();
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Building multikey command: " + this.commandKeyStrokes);
        }
        return isMultikey;
    }

    @NotNull
    public final Command buildCommand() {
        int rawCount = this.calculateCount0Snapshot();
        EditorActionHandlerBase editorActionHandlerBase = this.action;
        Intrinsics.checkNotNull((Object)editorActionHandlerBase);
        EditorActionHandlerBase editorActionHandlerBase2 = this.action;
        Intrinsics.checkNotNull((Object)editorActionHandlerBase2);
        Command.Type type = editorActionHandlerBase2.getType();
        Object object = this.action;
        if (object == null || (object = ((EditorActionHandlerBase)object).getFlags()) == null) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<CommandFlags> enumSet = EnumSet.noneOf(CommandFlags.class);
            object = enumSet;
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        }
        Command command = new Command(this.selectedRegister, rawCount, editorActionHandlerBase, this.argument, type, (EnumSet<CommandFlags>)object);
        this.resetAll(this.keyStrokeTrie);
        return command;
    }

    public final void resetAll(@NotNull KeyStrokeTrie<LazyVimCommand> keyStrokeTrie) {
        Intrinsics.checkNotNullParameter(keyStrokeTrie, (String)"keyStrokeTrie");
        logger.trace("resetAll is executed");
        this.keyStrokeTrie = keyStrokeTrie;
        this.commandState = CurrentCommandState.NEW_COMMAND;
        this.commandKeyStrokes.clear();
        this.counts.clear();
        this.counts.add(0);
        this.isRegisterPending = false;
        this.selectedRegister = null;
        this.action = null;
        this.argument = null;
        this.typedKeyStrokes.clear();
        this.fallbackArgumentType = null;
    }

    public final void resetCommandTrie(@NotNull KeyStrokeTrie<LazyVimCommand> keyStrokeTrie) {
        Intrinsics.checkNotNullParameter(keyStrokeTrie, (String)"keyStrokeTrie");
        logger.trace("resetCommandTrieRootNode is executed");
        this.keyStrokeTrie = keyStrokeTrie;
    }

    @TestOnly
    @NotNull
    public final KeyStrokeTrie<LazyVimCommand> getCurrentTrie() {
        return this.keyStrokeTrie;
    }

    @TestOnly
    @NotNull
    public final List<KeyStroke> getCurrentCommandKeys() {
        return this.commandKeyStrokes;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.command.CommandBuilder");
        CommandBuilder cfr_ignored_0 = (CommandBuilder)other;
        if (!Intrinsics.areEqual(this.keyStrokeTrie, ((CommandBuilder)other).keyStrokeTrie)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.counts, ((CommandBuilder)other).counts)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selectedRegister, (Object)((CommandBuilder)other).selectedRegister)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.action, (Object)((CommandBuilder)other).action)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.argument, (Object)((CommandBuilder)other).argument)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.typedKeyStrokes, ((CommandBuilder)other).typedKeyStrokes)) {
            return false;
        }
        if (this.commandState != ((CommandBuilder)other).commandState) {
            return false;
        }
        if (this.getExpectedArgumentType() != ((CommandBuilder)other).getExpectedArgumentType()) {
            return false;
        }
        return this.fallbackArgumentType == ((CommandBuilder)other).fallbackArgumentType;
    }

    public int hashCode() {
        int result = this.keyStrokeTrie.hashCode();
        result = 31 * result + ((Object)this.counts).hashCode();
        Character c = this.selectedRegister;
        result = 31 * result + (c != null ? ((Object)c).hashCode() : 0);
        EditorActionHandlerBase editorActionHandlerBase = this.action;
        result = 31 * result + (editorActionHandlerBase != null ? editorActionHandlerBase.hashCode() : 0);
        Argument argument = this.argument;
        result = 31 * result + (argument != null ? argument.hashCode() : 0);
        result = 31 * result + ((Object)this.typedKeyStrokes).hashCode();
        result = 31 * result + this.commandState.hashCode();
        Argument.Type type = this.getExpectedArgumentType();
        result = 31 * result + (type != null ? ((Object)((Object)type)).hashCode() : 0);
        Argument.Type type2 = this.fallbackArgumentType;
        result = 31 * result + (type2 != null ? ((Object)((Object)type2)).hashCode() : 0);
        return result;
    }

    @NotNull
    public CommandBuilder clone() {
        CommandBuilder result = new CommandBuilder(this.keyStrokeTrie, CollectionsKt.toMutableList((Collection)this.counts), CollectionsKt.toMutableList((Collection)this.typedKeyStrokes), CollectionsKt.toMutableList((Collection)this.commandKeyStrokes));
        result.selectedRegister = this.selectedRegister;
        result.action = this.action;
        result.argument = this.argument;
        result.commandState = this.commandState;
        result.fallbackArgumentType = this.fallbackArgumentType;
        return result;
    }

    @NotNull
    public String toString() {
        return "Command state = " + this.commandState + ", key list = " + VimInjectorKt.getInjector().getParser().toKeyNotation(this.typedKeyStrokes) + ", selected register = " + this.selectedRegister + ", counts = " + this.counts + ", action = " + this.action + ", argument = " + this.argument + ", command part node - " + this.keyStrokeTrie;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandBuilder.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/command/CommandBuilder$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

